/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.inspectors;

import java.net.InetAddress;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.inspectors.SNMPNasConnectionInspector;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.varbind;

public class SNMPNasConnectionCheckObserver
implements Observer {
    private static final Logger logger = Logger.getLogger((String)"connections");
    private final int version;
    private final NasConnection<?> connection;
    private final InetAddress nasIPAddress;

    public SNMPNasConnectionCheckObserver(int version, NasConnection<?> connection, InetAddress nasIPAddress) {
        this.version = version;
        this.connection = connection;
        this.nasIPAddress = nasIPAddress;
    }

    public SNMPNasConnectionCheckObserver(int version, NasConnection<?> connection, SNMPNasConnectionInspector insp) {
        this(version, connection, insp.getHost());
    }

    @Override
    public void update(Observable obs, Object ov) {
        try {
            varbind var = (varbind)ov;
            AsnObject obj = var.getValue();
            if (obj.getRespType() != -126) {
                String login = var.getValue().toString().trim();
                logger.debug((Object)("SNMP check response: " + login));
                if (this.compareLoginWithConnection(login)) {
                    logger.debug((Object)("SNMP NASConnection is active: " + login));
                    if (this.connection.getStatus() == NasConnection.Status.suspended) {
                        this.connection.setStatus(NasConnection.Status.working);
                    }
                } else {
                    logger.debug((Object)("SNMP NASConnection not active: " + login));
                    if (this.connection.getStatus() == NasConnection.Status.working) {
                        this.connection.setStatus(NasConnection.Status.suspended);
                    }
                }
            }
        }
        catch (Exception ex) {
            if (this.connection.getStatus() == NasConnection.Status.working) {
                this.connection.setStatus(NasConnection.Status.suspended);
            }
            logger.info((Object)("SNMP response  [ SNMP" + this.version + ", host=" + this.nasIPAddress + ", msg=" + ex.getMessage() + ", recived object=" + ov.toString() + " ]"));
        }
    }

    protected boolean compareLoginWithConnection(String login) {
        boolean responseOK = false;
        String loginName = this.connection.getSession().getUserName();
        if (login != null) {
            if ("2".equals(login)) {
                responseOK = true;
            } else if (login.equals(loginName)) {
                responseOK = true;
            }
        }
        return responseOK;
    }
}

