/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptBackup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ScriptBackupManager
extends AbstractIdDao<ScriptBackup> {
    public ScriptBackupManager(Connection con) {
        super(con, 0, "script_backup");
    }

    @Override
    protected void updateImpl(ScriptBackup b2) throws BGException, SQLException {
        try {
            PreparedStatement ps;
            if (b2.getId() == -1) {
                ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (script_id, title, script, user_id, comment, type) VALUES (?, ?, ?, ?, ?, ?)", 1);
            } else {
                ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET script_id=?, title=?, script=?, user_id=?, comment=?, type=? WHERE id=?");
                ps.setInt(7, b2.getId());
            }
            ps.setInt(1, b2.getScriptId());
            ps.setString(2, b2.getTitle());
            ps.setString(3, b2.getScript());
            ps.setInt(4, b2.getUserId());
            ps.setString(5, b2.getComment());
            ps.setInt(6, b2.getType());
            ps.executeUpdate();
            if (b2.getId() == -1) {
                b2.setId(ServerUtils.lastInsertId(ps));
            }
            b2.setTimeRevision(((ScriptBackup)this.get(b2.getId())).getTimeRevision());
            ps.close();
        }
        catch (SQLException e) {
            if (e.getSQLState() != null && e.getSQLState().startsWith("23")) {
                throw new BGMessageException("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            }
            throw e;
        }
    }

    public List<ScriptBackup> list(int scriptId, int type) throws BGException {
        return this.list("script_id=? AND type=?", "change_time", scriptId, type);
    }

    public void deleteBackups(int scriptId, int type) throws BGException {
        for (ScriptBackup backup : this.list(scriptId, type)) {
            this.delete(backup.getId());
        }
    }

    @Override
    protected ScriptBackup getFromRS(ResultSet rs) throws SQLException, BGException {
        ScriptBackup result = new ScriptBackup();
        result.setId(rs.getInt("id"));
        result.setScriptId(rs.getInt("script_id"));
        result.setTitle(rs.getString("title"));
        result.setScript(rs.getString("script"));
        result.setUserId(rs.getInt("user_id"));
        result.setTimeRevision(rs.getTimestamp("change_time"));
        result.setComment(rs.getString("comment"));
        result.setType(rs.getInt("type"));
        return result;
    }
}

