/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.bean;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TreeNode;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class TariffPlanDao
extends AbstractIdDao<TariffPlan>
implements Directory<TariffPlan> {
    protected static final String TABLE_TARIFF_PLAN = "tariff_plan";

    public TariffPlanDao(Connection con) {
        super(con, 0, TABLE_TARIFF_PLAN);
    }

    public Map<Integer, TariffPlan> getTariffPlanMap() throws BGException {
        List<TariffPlan> list = this.list();
        return Id.newMap(list);
    }

    @Deprecated
    public TariffPlan getTariffPlan(int id) throws BGException {
        return (TariffPlan)this.get(id);
    }

    public List<TariffPlan> getTariffPlanList() throws BGException {
        return this.list();
    }

    @Override
    public List<TariffPlan> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }

    public List<TariffPlan> getTariffPlanList(List<Integer> idFilter) throws BGException {
        return this.list(idFilter);
    }

    public List<TariffPlan> list(List<Integer> idFilter) throws BGException {
        ArrayList<TariffPlan> result = new ArrayList<TariffPlan>();
        try {
            if (idFilter != null && !idFilter.isEmpty()) {
                StringBuffer query = new StringBuffer("SELECT * FROM ").append(TABLE_TARIFF_PLAN);
                query.append(" WHERE id IN ( ").append(Utils.toString(idFilter)).append(" )");
                query.append(" ORDER BY title");
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query.toString());
                while (rs.next()) {
                    result.add(this.getFromRS(rs));
                }
                rs.close();
                st.close();
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public List<TariffPlan> getTariffPlanList(int defaultID, long groups, int face, String title) throws BGException {
        ArrayList<TariffPlan> result = new ArrayList<TariffPlan>();
        try {
            String query = "SELECT * FROM ".concat(TABLE_TARIFF_PLAN).concat(" WHERE ID=? OR ( ( gr =0 OR ( gr & ? ) > 0 ) AND (face = 0 OR face - 1 = ?) AND (? LIKE pattern OR pattern = '' OR pattern IS NULL ) ) ORDER BY title");
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, defaultID);
            ps.setLong(2, groups);
            ps.setInt(3, face);
            ps.setString(4, title);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public int copyTariffPlan(int tpid) throws BGException {
        int copyTpId = 0;
        try {
            TariffPlan tp = this.getTariffPlan(tpid);
            copyTpId = this.copyTariffPlan(tp);
            int treeId = this.getTariffPlanTreeId(tpid);
            String query = "INSERT INTO tariff_tree SET parent_tree=0";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.executeUpdate();
            int copyTreeId = ServerUtils.lastInsertId(ps);
            ps.close();
            ps = this.con.prepareStatement("UPDATE ".concat(TABLE_TARIFF_PLAN).concat(" SET tree_id=? WHERE id=?"));
            ps.setInt(1, copyTreeId);
            ps.setInt(2, copyTpId);
            ps.executeUpdate();
            ps.close();
            query = "SELECT * FROM module_tariff_tree WHERE tree_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, treeId);
            ResultSet rs = ps.executeQuery();
            String copyModuleTariffTreeQuery = "INSERT INTO module_tariff_tree (mid, tree_id, parent_tree, lm) VALUES ( ?, ?, ?, ? )";
            PreparedStatement psModuleTariffTree = this.con.prepareStatement(copyModuleTariffTreeQuery, 1);
            psModuleTariffTree.setInt(2, copyTreeId);
            psModuleTariffTree.setLong(4, System.currentTimeMillis());
            String selectNodeQuery = "SELECT * FROM mtree_node WHERE mtree_id=? ORDER BY parent_node";
            PreparedStatement psSelectNode = this.con.prepareStatement(selectNodeQuery);
            ResultSet nodesRS = null;
            HashMap<Integer, Integer> linkNodeIds = new HashMap<Integer, Integer>();
            while (rs.next()) {
                psModuleTariffTree.setInt(1, rs.getInt("mid"));
                psModuleTariffTree.setInt(3, rs.getInt("parent_tree"));
                psModuleTariffTree.executeUpdate();
                int newMTreeId = ServerUtils.lastInsertId(psModuleTariffTree);
                int mtreeId = rs.getInt("id");
                psSelectNode.setInt(1, mtreeId);
                nodesRS = psSelectNode.executeQuery();
                String insertNodeQuery = "INSERT INTO mtree_node ( parent_node, mtree_id, type, data, pos ) VALUES ( ?, ?, ?, ?, ? )";
                PreparedStatement psInsertNode = this.con.prepareStatement(insertNodeQuery, 1);
                psInsertNode.setInt(2, newMTreeId);
                LinkedHashMap<Integer, TreeNode> nodeMap = new LinkedHashMap<Integer, TreeNode>();
                while (nodesRS.next()) {
                    TreeNode node = new TreeNode();
                    node.parentNodeId = nodesRS.getInt("parent_node");
                    node.id = nodesRS.getInt("id");
                    node.pos = nodesRS.getInt("pos");
                    node.data = nodesRS.getString("data");
                    node.type = nodesRS.getString("type");
                    nodeMap.put(node.id, node);
                }
                nodesRS.close();
                for (TreeNode treeNode : nodeMap.values()) {
                    this.insertNodeCopy(linkNodeIds, psInsertNode, nodeMap, treeNode);
                }
                psInsertNode.close();
            }
            psModuleTariffTree.close();
            psSelectNode.close();
            ps.close();
            rs.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return copyTpId;
    }

    protected int insertNodeCopy(Map<Integer, Integer> linkNodeIds, PreparedStatement psInsertNode, Map<Integer, TreeNode> oldNodeMap, TreeNode oldTreeNode) throws SQLException {
        int newParentNodeId;
        if (linkNodeIds.get(oldTreeNode.id) != null) {
            return 0;
        }
        if (oldTreeNode.parentNodeId == 0) {
            newParentNodeId = 0;
        } else if (linkNodeIds.get(oldTreeNode.parentNodeId) != null) {
            newParentNodeId = linkNodeIds.get(oldTreeNode.parentNodeId);
        } else if (oldNodeMap.get(oldTreeNode.parentNodeId) != null) {
            TreeNode oldParentNode = oldNodeMap.get(oldTreeNode.parentNodeId);
            newParentNodeId = this.insertNodeCopy(linkNodeIds, psInsertNode, oldNodeMap, oldParentNode);
            psInsertNode.setInt(1, newParentNodeId);
        } else {
            newParentNodeId = oldTreeNode.parentNodeId;
        }
        psInsertNode.setInt(1, newParentNodeId);
        psInsertNode.setString(3, oldTreeNode.type);
        psInsertNode.setString(4, oldTreeNode.data);
        psInsertNode.setInt(5, oldTreeNode.pos);
        psInsertNode.executeUpdate();
        int newNodeId = ServerUtils.lastInsertId(psInsertNode);
        linkNodeIds.put(oldTreeNode.id, newNodeId);
        return newNodeId;
    }

    protected int insertNode(PreparedStatement psInsertNode, TreeNode treeNode) throws SQLException {
        psInsertNode.setString(3, treeNode.type);
        psInsertNode.setString(4, treeNode.data);
        psInsertNode.setInt(5, treeNode.pos);
        psInsertNode.executeUpdate();
        int copyNodeId = ServerUtils.lastInsertId(psInsertNode);
        return copyNodeId;
    }

    public int copyTariffPlan(TariffPlan tp) throws BGException {
        int id = 0;
        try {
            int index = 1;
            String query = "INSERT INTO ".concat(TABLE_TARIFF_PLAN).concat(" SET title=?, actual=?, lm=?, gr=?, pattern=?, face=?, config=?");
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.setString(index++, tp.getTitle() + " copy");
            ps.setBoolean(index++, tp.isUsed());
            ps.setLong(index++, System.currentTimeMillis());
            ps.setLong(index++, tp.getFilterGroups());
            ps.setString(index++, tp.getFilterMask());
            ps.setInt(index++, tp.getFilterFace());
            ps.setString(index++, tp.getConfig());
            ps.executeUpdate();
            id = ServerUtils.lastInsertId(ps);
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return id;
    }

    public int getTariffPlanTreeId(int tariffPlanId) throws BGException {
        int treeId = 0;
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT tree_id FROM " + TABLE_TARIFF_PLAN + " WHERE id=" + tariffPlanId);
            if (rs.next()) {
                treeId = rs.getInt("tree_id");
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return treeId;
    }

    public Map<Integer, Integer> getModuleTrees(int treeId) throws BGException {
        HashMap<Integer, Integer> moduleTreesMap = new HashMap<Integer, Integer>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, mid FROM module_tariff_tree WHERE tree_id=" + treeId);
            while (rs.next()) {
                moduleTreesMap.put(rs.getInt("id"), rs.getInt("mid"));
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return moduleTreesMap;
    }

    public boolean usesModule(int tariffPlanId, int moduleId) throws BGException {
        boolean result = true;
        try {
            String query = "SELECT * FROM module_tariff_tree as t1 " + "JOIN ".concat(TABLE_TARIFF_PLAN).concat(" AS t2 ON t1.tree_id=t2.tree_id WHERE mid=") + moduleId + " AND t2.id=" + tariffPlanId;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            result = rs.next();
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public void searchTariffPlans(SearchResult<TariffPlan> searchResult, int showActual, List<Integer> moduleIds, List<Integer> labelIds, String titleMask) throws BGException {
        Page page = searchResult.getPage();
        List<TariffPlan> tariffList = searchResult.getList();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT SQL_CALC_FOUND_ROWS DISTINCT tp.id, tp.title, tp.comment FROM ".concat(TABLE_TARIFF_PLAN).concat(" AS tp"));
            if (moduleIds != null && moduleIds.size() > 0) {
                query.append(" INNER JOIN module_tariff_tree AS mtt ON tp.tree_id=mtt.tree_id");
            }
            if (labelIds != null && labelIds.size() > 0) {
                query.append(" INNER JOIN tariff_label_link AS label ON tp.id=label.tariff_id");
            }
            query.append(" WHERE true ");
            if (moduleIds != null && moduleIds.size() > 0) {
                query.append(" AND mtt.mid IN ( " + Utils.toString(moduleIds, ", ") + " )");
            }
            if (labelIds != null && labelIds.size() > 0) {
                query.append(" AND label.label_id IN ( " + Utils.toString(labelIds, ", ") + " )");
            }
            if (showActual != 2) {
                query.append(" AND tp.actual=");
                query.append(showActual);
            }
            if (Utils.notEmptyString(titleMask)) {
                query.append(" AND UPPER(tp.title) REGEXP ?");
            }
            query.append(" ORDER BY tp.title");
            if (page.getPageSize() > 0) {
                query.append(page.sqlLimit());
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            if (Utils.notEmptyString(titleMask)) {
                ps.setString(1, titleMask.toUpperCase());
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                TariffPlan tariffPlan = new TariffPlan();
                tariffPlan.setId(rs.getInt("tp.id"));
                tariffPlan.setTitle(rs.getString("tp.title"));
                tariffPlan.setComment(rs.getString("tp.comment"));
                tariffList.add(tariffPlan);
            }
            rs.close();
            ps.close();
            page.setRecordCount(ServerUtils.foundRows(this.con));
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public Map<Integer, TariffPlanCounts> getTariffContractCount(List<Integer> tariffIds) throws BGException {
        HashMap<Integer, TariffPlanCounts> counts = new HashMap<Integer, TariffPlanCounts>();
        try {
            TariffPlanCounts values;
            int tpid;
            StringBuilder query = new StringBuilder();
            query.append("SELECT tpid, COUNT(*) FROM contract_tariff ");
            if (tariffIds != null && !tariffIds.isEmpty()) {
                query.append(" WHERE tpid IN ( ");
                query.append(Utils.toString(tariffIds));
                query.append(" )");
            }
            query.append(" GROUP BY tpid");
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                counts.put(rs.getInt(1), new TariffPlanCounts(BigDecimal.ZERO, BigDecimal.ZERO, new BigDecimal(rs.getInt(2))));
            }
            rs.close();
            query = new StringBuilder("SELECT tpid, COUNT(*) FROM contract_tariff WHERE date1 <= CURDATE() AND ( date2 IS NULL OR date2 >= CURDATE() )");
            if (tariffIds != null && !tariffIds.isEmpty()) {
                query.append(" AND tpid IN ( ").append(Utils.toString(tariffIds)).append(" )");
            }
            query.append(" GROUP BY tpid");
            rs = st.executeQuery(query.toString());
            while (rs.next()) {
                tpid = rs.getInt(1);
                values = (TariffPlanCounts)counts.get(tpid);
                if (values == null) {
                    values = new TariffPlanCounts(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                    counts.put(tpid, values);
                }
                values.countActive = new BigDecimal(rs.getInt(2));
            }
            rs.close();
            query = new StringBuilder("SELECT tp.id, COUNT( DISTINCT mtt.tree_id ) FROM ").append(TABLE_TARIFF_PLAN).append(" AS tp LEFT JOIN module_tariff_tree AS mtt ON mtt.parent_tree=tp.tree_id WHERE true");
            if (tariffIds != null && !tariffIds.isEmpty()) {
                query.append(" AND tp.id IN ( ").append(Utils.toString(tariffIds)).append(" )");
            }
            query.append(" GROUP BY tp.id");
            rs = st.executeQuery(query.toString());
            while (rs.next()) {
                tpid = rs.getInt(1);
                values = (TariffPlanCounts)counts.get(tpid);
                if (values == null) {
                    values = new TariffPlanCounts(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                    counts.put(tpid, values);
                }
                values.countChild = new BigDecimal(rs.getInt(2));
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return counts;
    }

    public List<IdTitle> getModuleList() throws BGException {
        ArrayList<IdTitle> moduleList = new ArrayList<IdTitle>();
        try {
            List<BGModule> modules = ModuleCache.getInstance().getModulesList();
            String files = "";
            for (BGModule module : modules) {
                URL url = this.getClass().getResource("/bitel/billing/common/tariff/" + module.getName() + ".xml");
                if (url == null) continue;
                if (!files.equals("")) {
                    files = files + ",";
                }
                files = files + "'" + module.getName() + "'";
            }
            if (!files.isEmpty()) {
                String query = "SELECT DISTINCT module.id, module.title FROM module " + "WHERE module.name IN ( ".concat(files).concat(" ) ORDER BY module.title");
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    moduleList.add(new IdTitle(rs.getInt("module.id"), rs.getString("module.title")));
                }
                rs.close();
                st.close();
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return moduleList;
    }

    @Deprecated
    public void updateTariffPlan(TariffPlan tariffPlan) throws BGException {
        this.update(tariffPlan);
    }

    @Override
    protected TariffPlan getFromRS(ResultSet rs) throws SQLException, BGException {
        TariffPlan plan = new TariffPlan();
        plan.setId(rs.getInt("id"));
        plan.setTitle(rs.getString("title"));
        plan.setUsed(rs.getInt("actual") == 1);
        plan.setFilterGroups(rs.getLong("gr"));
        plan.setFilterFace(rs.getInt("face"));
        plan.setFilterMask(rs.getString("pattern"));
        String titleWeb = rs.getString("title_web");
        plan.setUseTitleInWeb(titleWeb == null);
        plan.setTitleWeb(titleWeb == null ? plan.getTitle() : titleWeb);
        plan.setConfig(rs.getString("config"));
        plan.setComment(rs.getString("comment"));
        return plan;
    }

    @Override
    protected void updateImpl(TariffPlan tariffPlan) throws BGException, SQLException {
        if (tariffPlan == null) {
            throw new NullPointerException("TariffPlan is null!!!");
        }
        int index = 1;
        String query = "UPDATE tariff_plan SET title=?, title_web=?, actual=?, gr=?, face=?, pattern=?, config=?, comment=?  WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(index++, tariffPlan.getTitle());
        ps.setString(index++, tariffPlan.isUseTitleInWeb() ? null : tariffPlan.getTitleWeb());
        ps.setInt(index++, tariffPlan.isUsed() ? 1 : 0);
        ps.setLong(index++, tariffPlan.getFilterGroups());
        ps.setInt(index++, tariffPlan.getFilterFace());
        ps.setString(index++, tariffPlan.getFilterMask());
        ps.setString(index++, tariffPlan.getConfig());
        ps.setString(index++, tariffPlan.getComment());
        ps.setInt(index, tariffPlan.getId());
        ps.executeUpdate();
        ps.close();
    }

    @Override
    public TariffPlan get(String title) throws BGException {
        return (TariffPlan)super.get("title=?", title);
    }

    public class TariffPlanCounts {
        public BigDecimal countChild;
        public BigDecimal countActive;
        public BigDecimal countAll;

        public TariffPlanCounts(BigDecimal countChild, BigDecimal countActive, BigDecimal countAll) {
            this.countChild = countChild;
            this.countActive = countActive;
            this.countAll = countAll;
        }
    }
}

