/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.task;

import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.util.MailMsg;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;

public class TaskChekNewAddressCustom
extends TaskBase {
    @Override
    protected boolean initTask() {
        return true;
    }

    @Override
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try (ContractParameterPrefDao dao = new ContractParameterPrefDao(con);){
            String email;
            StringBuilder report = new StringBuilder();
            report.append("\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u043e\u0432\u044b\u0435 \u043d\u0435\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043d\u044b\u0435 \u0430\u0434\u0440\u0435\u0441\u0430. \n");
            ContractParameterManager contractParameterManager = new ContractParameterManager(con);
            Map<Integer, Integer> addressCustomMap = contractParameterManager.getAddressCustomParam();
            if (addressCustomMap.size() > 0) {
                List<ContractParameterPref> list = dao.getContractParameterPrefList(ContractParameterPrefType.TYPE_ADDRESS);
                for (ContractParameterPref p : list) {
                    if (addressCustomMap.get(p.getId()) == null) continue;
                    report.append("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"" + p.getTitle() + "\" \u0438\u043c\u0435\u0435\u0442 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 - " + addressCustomMap.get(p.getId()) + "\n");
                }
            }
            if ((email = this.taskSetup.get("mail.to", null)) != null && !email.isEmpty() && report.length() > 0) {
                MailMsg msg = new MailMsg(this.setup);
                String mailSubject = this.taskSetup.get("mail.subject", "\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u043e\u0432\u044b\u0435 \u043d\u0435\u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043d\u044b\u0435 \u0430\u0434\u0440\u0435\u0441\u0430");
                msg.sendMessage(email, mailSubject, report.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getDescription() {
        return null;
    }
}

