/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Date;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.wifi.WiFiManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.bootstrap.Shutdown;

public class AdminPortListener
extends Thread {
    private static Logger logger = Logger.getLogger(AdminPortListener.class);
    private DatagramSocket socket;
    WiFiManager manager = null;
    private Date startTime = new Date();

    public AdminPortListener(int port, WiFiManager manager) {
        this.manager = manager;
        try {
            this.socket = new DatagramSocket(port);
        }
        catch (Exception ex) {
            logger.error((Object)("Port " + port + " is busy!!! [" + ex.getMessage() + "]"));
            System.exit(1);
        }
        this.start();
    }

    @Override
    public void run() {
        byte[] buffer = new byte[100];
        byte[] data = null;
        while (true) {
            try {
                while (true) {
                    final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.socket.receive(packet);
                    data = packet.getData();
                    String command = new String(data, 0, packet.getLength(), "ISO-8859-1").trim();
                    logger.info((Object)("Admin command: " + command));
                    if (command.equals("stop")) {
                        Shutdown.addOnShutdown(new Shutdown.OnShutdown(){

                            @Override
                            public void onShutdown() {
                                try {
                                    AdminPortListener.this.sendResponse("OK stopping..", packet);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        this.manager.halt();
                        System.exit(0);
                        continue;
                    }
                    if (command.equals("status")) {
                        this.sendResponse(this.getStatus(), packet);
                        continue;
                    }
                    this.sendResponse("Unknown admin command: " + command, packet);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("AdminPortListener error " + ex.getMessage()));
                continue;
            }
            break;
        }
    }

    private void sendResponse(String responseStr, DatagramPacket inPacket) throws Exception {
        int MAX_SIZE = 65533;
        if (responseStr.length() > MAX_SIZE) {
            responseStr = responseStr.substring(0, MAX_SIZE);
        }
        byte[] responseBytes = responseStr.getBytes("ISO-8859-1");
        DatagramPacket response = new DatagramPacket(responseBytes, responseBytes.length, inPacket.getAddress(), inPacket.getPort());
        this.socket.send(response);
    }

    private String getStatus() {
        StringBuffer status = new StringBuffer();
        status.append("WiFiAgent");
        status.append("\n");
        status.append(ServerUtils.uptimeStatus(this.startTime));
        status.append("\n");
        status.append(Utils.memoryStatus());
        return status.toString();
    }
}

