/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi;

import java.util.Map;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.WiFiManager;
import ru.bitel.bgbilling.kernel.wifi.common.IpInfo;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;
import ru.bitel.common.model.Pair;

public class WiFiChecker
extends Thread {
    private WiFiManager manager = null;
    private static Logger log = Logger.getLogger(WiFiChecker.class);

    public void init(WiFiManager manager) {
        this.manager = manager;
    }

    @Override
    public void run() {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        while (true) {
            try {
                while (true) {
                    Map<String, Pair<Long, Long>> ipCountMap = this.manager.getScriptUtil().getIpCountInfo();
                    for (Map.Entry<String, Pair<Long, Long>> entry : ipCountMap.entrySet()) {
                        String ip = entry.getKey();
                        Pair<Long, Long> pair = entry.getValue();
                        log.debug((Object)("ip = " + ip));
                        log.debug((Object)("bytes in/out=" + pair.getFirst() + "/" + pair.getSecond()));
                    }
                    this.manager.updateLiveInfo(ipCountMap);
                    if (cfg.isSendRadiusUpdates()) {
                        this.sendUpdateInfo(ipCountMap);
                    }
                    Thread.sleep(60000L);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e1) {
                    log.error((Object)"", (Throwable)e);
                    throw new RuntimeException("Thread was interrupted!");
                }
            }
        }
    }

    private void sendUpdateInfo(Map<String, Pair<Long, Long>> ipCountMap) {
        try {
            Map<Integer, IpInfo> clients = this.manager.getIpHash();
            for (Map.Entry<Integer, IpInfo> entry : clients.entrySet()) {
                int ip = entry.getKey();
                IpInfo ipInfo = entry.getValue();
                String strIp = WiFiUtil.getIp(ip);
                Pair<Long, Long> pair = ipCountMap.get(strIp);
                long inputBytes = 0L;
                long outBytes = 0L;
                if (pair != null) {
                    inputBytes = pair.getFirst();
                    outBytes = pair.getSecond();
                }
                this.manager.getRadiusUtil().sendUpdatePacket(ipInfo.getLogin(), strIp, inputBytes, outBytes, ipInfo.getAcctSessionId(), ipInfo.getStartDate());
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }
}

