/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import bitel.billing.server.admin.bgsecure.bean.UserGroupManager;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class ClosedDateChecker {
    private static Calendar DEFAULT_CLOSED_DATE = new GregorianCalendar(1990, 0, 1);
    private static ClosedDateChecker instance = new ClosedDateChecker();

    public static ClosedDateChecker getInstance() {
        return instance;
    }

    public Calendar getClosePeriodDate(int typeId) {
        Calendar dt = null;
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        dt = TimeUtils.convertStringToCalendar(ServerUtils.getSetupValue(con, "closed_date_" + typeId));
        ServerUtils.closeConnection(con);
        if (dt == null) {
            dt = (Calendar)DEFAULT_CLOSED_DATE.clone();
        }
        return dt;
    }

    private int getClosePeriodType(String key, int mid) {
        Setup setup = Setup.getSetup();
        if (mid > 0) {
            return setup.getModuleSetup(mid).getInt("closed.date.type." + key, 1);
        }
        return setup.getInt("closed.date.type." + key, 1);
    }

    public void setClosePeriodDate(int typeId, Date dt) {
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        ServerUtils.setSetupValue(con, "closed_date_" + typeId, TimeUtils.formatDate(dt));
        ServerUtils.closeConnection(con);
    }

    public static Calendar getClosePeriodDateIfChecking(String key, int mid, int userId) {
        return ClosedDateChecker.getInstance().getClosePeriodDateIfCheckingNoStatic(key, mid, userId);
    }

    private Calendar getClosePeriodDateIfCheckingNoStatic(String key, int mid, int userId) {
        if (!this.isDateCheckingEnabled(key, mid, userId)) {
            return (Calendar)DEFAULT_CLOSED_DATE.clone();
        }
        return this.getClosePeriodDate(this.getClosePeriodType(key, mid));
    }

    private boolean isDateCheckingEnabled(String key, int mid, Integer userId) {
        List<Integer> listUsers;
        if (Setup.getSetup().getInt("closed.date.enabled", 0) == 0) {
            return false;
        }
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        List<Integer> listGroups1 = new UserGroupManager(con).getUserGroups(userId);
        ServerUtils.closeConnection(con);
        List<Integer> listGroups2 = Setup.getSetup().getIntegerList("closed.date.groups.id", null);
        if (listGroups1 != null && listGroups2 != null) {
            for (Integer groupId : listGroups2) {
                if (!listGroups1.contains(groupId)) continue;
                return false;
            }
        }
        if ((listUsers = Setup.getSetup().getIntegerList("closed.date.users.id", null)) != null && listUsers.contains(userId)) {
            return false;
        }
        if (key == null) {
            return true;
        }
        if (mid > 0 && Setup.getSetup().getModuleSetup(mid).getInt("closed.date.disabled." + key, 0) != 0) {
            return false;
        }
        return mid != -1 || Setup.getSetup().getInt("closed.date.disabled." + key, 0) == 0;
    }

    public static void checkDatesForDelete(Calendar closedDate, Date date) throws BGMessageException {
        ClosedDateChecker.checkDatesForDelete(closedDate, TimeUtils.convertDateToCalendar(date));
    }

    public static void checkDatesForDelete(Calendar closedDate, LocalDate date) throws BGMessageException {
        ClosedDateChecker.checkDatesForDelete(closedDate, TimeUtils.convertLocalDateToDate(date));
    }

    public static void checkDatesForDelete(Calendar closedDate, Calendar dateFrom) throws BGMessageException {
        boolean leftBeforeClosed;
        boolean bl = leftBeforeClosed = dateFrom != null && TimeUtils.dateBefore(dateFrom, closedDate);
        if (leftBeforeClosed) {
            throw new BGMessageException("\u0414\u0430\u0442\u0430 \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 - \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e!");
        }
    }

    public static void checkDatesForUpdate(Calendar closedDate, Date dateFrom, Date dateTo, Date newDateFrom, Date newDateTo) throws BGMessageException {
        ClosedDateChecker.checkDatesForUpdate(closedDate, TimeUtils.convertDateToCalendar(dateFrom), TimeUtils.convertDateToCalendar(dateTo), TimeUtils.convertDateToCalendar(newDateFrom), TimeUtils.convertDateToCalendar(newDateTo));
    }

    public static void checkDatesForUpdate(Calendar closedDate, Date date, Date newDate) throws BGMessageException {
        ClosedDateChecker.checkDatesForUpdate(closedDate, TimeUtils.convertDateToCalendar(date), TimeUtils.convertDateToCalendar(newDate));
    }

    public static void checkDatesForUpdate(Calendar closedDate, LocalDate date, LocalDate newDate) throws BGMessageException {
        ClosedDateChecker.checkDatesForUpdate(closedDate, TimeUtils.convertLocalDateToDate(date), TimeUtils.convertLocalDateToDate(newDate));
    }

    public static void checkDatesForUpdate(Calendar closedDate, Calendar dateFrom, Calendar dateTo, Calendar newDateFrom, Calendar newDateTo) throws BGMessageException {
        boolean newLeftBeforeClosed;
        boolean newRightBeforeClosed;
        boolean leftChanged;
        boolean rightBeforeClosed;
        boolean bl = rightBeforeClosed = dateTo != null && TimeUtils.dateBefore(dateTo, closedDate);
        if (rightBeforeClosed) {
            throw new BGMessageException("\u041f\u0435\u0440\u0438\u043e\u0434 \u043f\u043e\u043b\u043d\u043e\u0441\u0442\u044c\u044e \u043b\u0435\u0436\u0438\u0442 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435 - \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e!", "closedPeriodError.period");
        }
        boolean leftBeforeClosed = dateFrom != null && TimeUtils.dateBefore(dateFrom, closedDate);
        boolean bl2 = leftChanged = !TimeUtils.dateEqual(dateFrom, newDateFrom);
        if (leftBeforeClosed && leftChanged) {
            throw new BGMessageException("\u041b\u0435\u0432\u0430\u044f \u0433\u0440\u0430\u043d\u0438\u0446\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043b\u0435\u0436\u0438\u0442 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435 - \u0435\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e!", "closedPeriodError.from");
        }
        boolean rightChanged = !TimeUtils.dateEqual(dateTo, newDateTo);
        boolean bl3 = newRightBeforeClosed = newDateTo != null && TimeUtils.dateBefore(newDateTo, closedDate);
        if (rightChanged && newRightBeforeClosed) {
            throw new BGMessageException("\u041d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0430\u0432\u043e\u0439 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u043e\u043f\u0430\u0434\u0430\u0435\u0442 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 - \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e!", "closedPeriodError.newTo");
        }
        boolean bl4 = newLeftBeforeClosed = newDateFrom != null && TimeUtils.dateBefore(newDateFrom, closedDate);
        if (leftChanged && newLeftBeforeClosed) {
            throw new BGMessageException("\u041d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043b\u0435\u0432\u043e\u0439 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u043e\u043f\u0430\u0434\u0430\u0435\u0442 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 - \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e!", "closedPeriodError.newFrom");
        }
    }

    public static void checkDatesForUpdate(Calendar closedDate, Calendar date, Calendar newDate) throws BGMessageException {
        if (date != null && TimeUtils.dateBefore(date, closedDate)) {
            throw new BGMessageException("\u0414\u0430\u0442\u0430 \u043b\u0435\u0436\u0438\u0442 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435 - \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e!");
        }
        if (newDate != null && TimeUtils.dateBefore(newDate, closedDate)) {
            throw new BGMessageException("\u041d\u043e\u0432\u0430\u044f \u0434\u0430\u0442\u0430 \u043b\u0435\u0436\u0438\u0442 \u0432 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u0435 - \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e!");
        }
    }
}

