/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ContractParameterPhoneConvertor {
    private static final int MIN_IDLE_DEFAULT = 1;
    private static final int MAX_IDLE_DEFAULT = 20;
    private static final int MAX_ACTIVE_DEFAULT = 300;
    private static final String PROPERTY_USER = "user";
    private static final String PROPERTY_PASSWORD = "password";
    private DataSource dataSource = null;

    public ContractParameterPhoneConvertor() {
        DefaultServerSetup setup = new DefaultServerSetup("data.data");
        this.dataSource = ContractParameterPhoneConvertor.getDataSource(setup);
        this.convert();
    }

    public static void main(String[] args) {
        new ContractParameterPhoneConvertor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convert() {
        Connection con = null;
        try {
            ResultSet rs = null;
            PreparedStatement selectCurrentPs = null;
            PreparedStatement insertCurrentPs = null;
            PreparedStatement insertCurrentItemPs = null;
            PreparedStatement selectHistoryPs = null;
            PreparedStatement insertHistoryPs = null;
            con = this.dataSource.getConnection();
            Statement st = con.createStatement();
            st.executeUpdate("CREATE TABLE IF NOT EXISTS contract_parameter_type_phone ( pid int(11) NOT NULL, cid int(11) NOT NULL, value varchar(255) NOT NULL, PRIMARY KEY (`pid`,`cid`) )");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS contract_parameter_type_phone_item ( `pid` int(11) NOT NULL, `cid` int(11) NOT NULL, `n` tinyint(4) NOT NULL, `phone` varchar(11) DEFAULT NULL, `format` varchar(2) DEFAULT NULL, `comment` varchar(255) DEFAULT NULL, PRIMARY KEY (`pid`,`cid`,`n`), KEY `phone` (`phone`) )");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS contract_parameter_type_phone_log ( `pid` int(11) NOT NULL, `cid` int(11) NOT NULL, `val` varchar(255) DEFAULT NULL, `data` text, `dt_change` datetime NOT NULL, `user_id` int(11) NOT NULL, KEY `cid_pid` (`cid`,`pid`) )");
            st.executeQuery("SELECT * FROM contract_parameter_type_9 LIMIT 1");
            st.executeUpdate("DELETE FROM contract_parameter_type_phone");
            st.executeUpdate("DELETE FROM contract_parameter_type_phone_item");
            st.executeUpdate("DELETE FROM contract_parameter_type_phone_log");
            selectCurrentPs = con.prepareStatement("SELECT * FROM contract_parameter_type_9");
            selectHistoryPs = con.prepareStatement("SELECT * FROM contract_parameter_type_9_log");
            insertCurrentPs = con.prepareStatement("INSERT INTO contract_parameter_type_phone SET pid=?, cid=?, value=?");
            insertCurrentItemPs = con.prepareStatement("INSERT INTO contract_parameter_type_phone_item SET pid=?, cid=?, n=?, phone=?, format=?, comment=?");
            insertHistoryPs = con.prepareStatement("INSERT INTO contract_parameter_type_phone_log SET pid=?, cid=?, val=?, data=?, dt_change=?, user_id=?");
            rs = selectCurrentPs.executeQuery();
            while (rs.next()) {
                int pid = rs.getInt("pid");
                int cid = rs.getInt("cid");
                insertCurrentPs.setInt(1, pid);
                insertCurrentPs.setInt(2, cid);
                insertCurrentPs.setString(3, rs.getString("value"));
                insertCurrentPs.executeUpdate();
                insertCurrentItemPs.setInt(1, pid);
                insertCurrentItemPs.setInt(2, cid);
                for (int index = 1; index < 6; ++index) {
                    String phone = rs.getString("phone" + index);
                    String format = rs.getString("phone_format" + index);
                    String comment = rs.getString("phone_comm" + index);
                    insertCurrentItemPs.setInt(3, index);
                    insertCurrentItemPs.setString(4, phone);
                    insertCurrentItemPs.setString(5, format);
                    insertCurrentItemPs.setString(6, comment);
                    if (phone == null || phone.isEmpty()) continue;
                    insertCurrentItemPs.executeUpdate();
                }
            }
            rs.close();
            selectCurrentPs.close();
            rs = selectHistoryPs.executeQuery();
            while (rs.next()) {
                StringBuilder data = new StringBuilder();
                for (int index = 1; index < 6; ++index) {
                    data.append("phone.");
                    data.append(index + 1);
                    data.append("=");
                    data.append(this.maskNull(rs.getString("phone" + index)));
                    data.append(" ");
                    data.append(this.maskNull(rs.getString("phone_format" + index)));
                    data.append(" ");
                    data.append(this.maskNull(rs.getString("phone_comm" + index)));
                    data.append("\n");
                }
                insertHistoryPs.setInt(1, rs.getInt("pid"));
                insertHistoryPs.setInt(2, rs.getInt("cid"));
                insertHistoryPs.setString(3, rs.getString("val"));
                insertHistoryPs.setString(4, data.toString());
                insertHistoryPs.setTimestamp(5, rs.getTimestamp("dt_change"));
                insertHistoryPs.setInt(6, rs.getInt("user_id"));
                insertHistoryPs.executeUpdate();
            }
            rs.close();
            selectHistoryPs.close();
            st.executeUpdate("ALTER TABLE contract_parameter_type_9 RENAME TO contract_parameter_type_9_old");
            st.executeUpdate("ALTER TABLE contract_parameter_type_9_log RENAME TO contract_parameter_type_9_log_old");
            st.close();
            ServerUtils.closeConnection(con);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private String maskNull(String value) {
        String result = "";
        if (value != null) {
            result = value;
            result = result.replace('\n', ' ');
        }
        return result;
    }

    public static final DataSource getDataSource(DefaultServerSetup setup) {
        PoolingDataSource result = null;
        String dbDriver = setup.get("db.driver", null);
        String dbURL = setup.get("db.url", null);
        String dbUser = setup.get("db.user", null);
        String dbPswd = setup.get("db.pswd", null);
        int minIdle = setup.getInt("db.minIdle", 1);
        int maxIdle = setup.getInt("db.maxIdle", 20);
        int maxActive = setup.getInt("db.maxActive", 300);
        Properties properties = new Properties();
        ContractParameterPhoneConvertor.setDataSourceProperty(properties, PROPERTY_USER, dbUser);
        ContractParameterPhoneConvertor.setDataSourceProperty(properties, PROPERTY_PASSWORD, dbPswd);
        boolean testOnBorrow = true;
        boolean testOnReturn = false;
        try {
            Class.forName(dbDriver).newInstance();
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, properties);
            GenericObjectPool connectionPool = new GenericObjectPool(null);
            connectionPool.setMinIdle(minIdle);
            connectionPool.setMaxIdle(maxIdle);
            connectionPool.setMaxActive(maxActive);
            connectionPool.setTestOnBorrow(testOnBorrow);
            connectionPool.setTestOnReturn(testOnReturn);
            new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, "SELECT 1", false, true);
            result = new PoolingDataSource((ObjectPool)connectionPool);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static final void setDataSourceProperty(Properties properties, String key, String value) {
        if (key != null && value != null) {
            properties.setProperty(key, value);
        }
    }
}

