/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import ru.bitel.common.BGXMLEventReaderImpl;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.xml.NodeListElementIterator;

public class XMLUtils {
    private static final Logger logger = Logger.getLogger(XMLUtils.class);
    protected static final Pattern slashPattern = Pattern.compile("/");

    public static final XMLInputFactory newXMLInputFactory() {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return xmlif;
    }

    public static final BGXMLEventReader newXMLEventReader(Reader reader) {
        return XMLUtils.newXMLEventReader(XMLUtils.newXMLInputFactory(), reader);
    }

    public static final BGXMLEventReader newXMLEventReader(InputStream is) {
        return XMLUtils.newXMLEventReader(XMLUtils.newXMLInputFactory(), is);
    }

    public static final BGXMLEventReader newXMLEventReader(XMLInputFactory xmlif, Reader reader) {
        try {
            XMLEventReader xmlr = xmlif.createXMLEventReader(reader);
            return new BGXMLEventReaderImpl(xmlif, xmlr);
        }
        catch (XMLStreamException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static final BGXMLEventReader newXMLEventReader(XMLInputFactory xmlif, InputStream is) {
        try {
            XMLEventReader xmlr = xmlif.createXMLEventReader(is);
            return new BGXMLEventReaderImpl(xmlif, xmlr);
        }
        catch (XMLStreamException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static final Document newDocument() {
        try {
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            return docBuilder.newDocument();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static final Element newElement(Element parent, String name) {
        return XMLUtils.createElement(parent, name);
    }

    @Deprecated
    public static final Element newElement(Document parent, String name) {
        return XMLUtils.createElement(parent, name);
    }

    public static final Element createElement(Document parent, String name) {
        Element result = parent.createElement(name);
        parent.appendChild(result);
        return result;
    }

    public static Element createElement(Element parentElement, String name) {
        Element element = null;
        if (parentElement != null && name != null) {
            element = parentElement.getOwnerDocument().createElement(name);
            parentElement.appendChild(element);
        }
        return element;
    }

    public static void createTextNode(Node node, String text) {
        if (node != null && text != null) {
            node.appendChild(node.getOwnerDocument().createTextNode(text));
        }
    }

    public static Element createListElement(Element parentElement, String name, List<?> list, Class<?> clazz) {
        return XMLUtils.createListElement(parentElement, name, list, clazz, null);
    }

    public static Element createListElement(Element parentElement, String name, List<?> list, Class<?> clazz, String[] fields) {
        return XMLUtils.createListElement(parentElement, name, "item", list, clazz, fields);
    }

    public static Element createListElement(Element parentElement, String name, String itemName, List<?> list, Class<?> clazz, String[] fields) {
        Element listElement;
        block13: {
            listElement = null;
            if (parentElement == null || name == null) break block13;
            listElement = XMLUtils.createElement(parentElement, name);
            if (list != null) {
                if (clazz.isArray()) {
                    for (Object object : list) {
                        Element itemElement = XMLUtils.createElement(listElement, itemName);
                        if (!(object instanceof String[])) continue;
                        String[] strings = (String[])object;
                        for (int index = 0; index < fields.length; ++index) {
                            if (index >= strings.length) continue;
                            itemElement.setAttribute(fields[index], strings[index]);
                        }
                    }
                } else {
                    Method[] methods = clazz.getMethods();
                    if (fields != null && fields.length > 0) {
                        ArrayList<Method> methodList = new ArrayList<Method>();
                        for (String field : fields) {
                            String methodName = "get".concat(field.substring(0, 1).toUpperCase()).concat(field.substring(1));
                            try {
                                Method method = clazz.getMethod(methodName, new Class[0]);
                                if (method == null) continue;
                                methodList.add(method);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        methods = methodList.toArray(new Method[0]);
                    }
                    for (Object object : list) {
                        Element itemElement = XMLUtils.createElement(listElement, itemName);
                        for (Method method : methods) {
                            String attrName = method.getName();
                            attrName = attrName.substring(3);
                            attrName = attrName.substring(0, 1).toLowerCase().concat(attrName.substring(1));
                            try {
                                Object attrValue = method.invoke(object, (Object[])null);
                                itemElement.setAttribute(attrName, attrValue == null ? "" : attrValue.toString());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return listElement;
    }

    public static void setAttribute(Element element, String name, String value) {
        if (value != null) {
            element.setAttribute(name, value);
        }
    }

    public static Document parseDocument(String data) {
        return XMLUtils.parseDocument(new InputSource(new StringReader(data)), true);
    }

    public static Document parseDocument(byte[] data) {
        return XMLUtils.parseDocument(data, true);
    }

    public static Document parseDocument(byte[] data, boolean showError) {
        return XMLUtils.parseDocument(new InputSource(new ByteArrayInputStream(data)), showError);
    }

    public static Document parseDocument(InputSource source) {
        return XMLUtils.parseDocument(source, true);
    }

    public static Document parseDocument(InputSource source, boolean showError) {
        Document result;
        block3: {
            result = null;
            if (source != null) {
                try {
                    DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                    dFactory.setNamespaceAware(true);
                    dFactory.setValidating(false);
                    DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
                    result = docBuilder.parse(source);
                }
                catch (Exception e) {
                    if (!showError) break block3;
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }

    public static void parseDocument(InputSource source, ContentHandler handler) {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            parser.setContentHandler(handler);
            parser.parse(source);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Element getElement(Document doc, String elementName) {
        return (Element)XMLUtils.getNode(doc, elementName);
    }

    public static Node getNode(Document doc, String nodeName) {
        Node node = null;
        if (doc == null) {
            return node;
        }
        NodeList list = doc.getElementsByTagName(nodeName);
        if (list != null && list.getLength() > 0) {
            node = list.item(0);
        } else {
            node = doc.createElement(nodeName);
            doc.getDocumentElement().appendChild(node);
        }
        return node;
    }

    public static Element selectElement(Node node, String expression) {
        return (Element)XMLUtils.selectNode(node, expression);
    }

    public static Node selectNode(Node node, String expression) {
        try {
            return XPathAPI.selectSingleNode((Node)node, (String)expression);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Iterable<Element> selectElements(Node node, String expression) {
        try {
            NodeList nodeList = XPathAPI.selectNodeList((Node)node, (String)expression);
            return XMLUtils.elements(nodeList);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Iterable<Element> elements(final NodeList nodeList) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new NodeListElementIterator(nodeList);
            }
        };
    }

    public static String selectText(Node node, String expression) {
        return XMLUtils.selectText(node, expression, null);
    }

    public static String selectText(Node node, String expression, String defaultValue) {
        try {
            Node result = XPathAPI.selectSingleNode((Node)node, (String)expression);
            return result != null ? result.getTextContent() : defaultValue;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return defaultValue;
        }
    }

    @Deprecated
    public static Element findElement(Node el, String elementName) {
        Node child;
        for (child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals(elementName)) continue;
            return (Element)child;
        }
        for (child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element result;
            if (child.getNodeType() != 1 || (result = XMLUtils.findElement(child, elementName)) == null) continue;
            return result;
        }
        return null;
    }

    public static String getAttribute(Element element, String name) {
        return XMLUtils.getAttribute(element, name, null);
    }

    public static String getAttribute(Element element, String name, String defaultValue) {
        return element != null && element.hasAttribute(name) ? element.getAttribute(name) : defaultValue;
    }

    @Deprecated
    public static int getIntAttribute(Element element, String name, int defaultValue) {
        return element.hasAttribute(name) ? Utils.parseInt(element.getAttribute(name), defaultValue) : defaultValue;
    }

    public static <E extends Enum<E>> E getEnumAttribute(Element element, String name, E defaultValue) {
        Object value = defaultValue;
        try {
            value = Enum.valueOf(defaultValue.getClass(), element.getAttribute(name));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public static int getAttributeIntValue(Node node, String name, int defaultValue) {
        int value = defaultValue;
        try {
            value = Integer.parseInt(XMLUtils.getAttribute((Element)node, name, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    @Deprecated
    public static Map<String, String> attributesToMap(Element element) {
        return XMLUtils.attributesToMap0(element, true);
    }

    private static Map<String, String> attributesToMap0(Element element, boolean needEmpty) {
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        HashMap<String, String> result = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            Node attribute = attributes.item(i);
            String value = attribute.getNodeValue();
            if (needEmpty) {
                result.put(attribute.getNodeName(), attribute.getNodeValue());
                continue;
            }
            if (value == null || value.length() <= 0) continue;
            result.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        return result;
    }

    public static ParameterMap attributesToParameterMap(Element element) {
        return new ElementParameterMap(element);
    }

    public static void serialize(Node node, OutputStream os, String encoding) {
        XMLUtils.serialize(node, new StreamResult(os), encoding);
    }

    public static void serialize(Node node, Writer writer) {
        XMLUtils.serialize(node, new StreamResult(writer), null);
    }

    public static void serialize(Node node, Writer writer, String encoding) {
        XMLUtils.serialize(node, new StreamResult(writer), encoding);
    }

    public static void serialize(Node node, Result result, String encoding) {
        XMLUtils.serialize(node, result, encoding, false);
    }

    public static void serialize(Node node, Result result, String encoding, boolean indent) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            if (indent) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.transform(new DOMSource(node), result);
        }
        catch (FactoryConfigurationError e) {
            logger.error((Object)"Could not locate a factory class", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            logger.error((Object)"TransformerConfigurationException", (Throwable)e);
        }
        catch (TransformerException e) {
            logger.error((Object)"TransformerException", (Throwable)e);
        }
    }

    public static void prepareElementToSerialize(Node el) {
        StringBuilder buf = new StringBuilder(100);
        int size = 0;
        NamedNodeMap map = el.getAttributes();
        if (map != null) {
            size = map.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = map.item(i);
                String nodeValue = node.getNodeValue();
                node.setNodeValue(XMLUtils.prepareString(buf, nodeValue));
            }
        }
        if (el.getNodeValue() != null) {
            el.setNodeValue(XMLUtils.prepareString(buf, el.getNodeValue()));
        }
        NodeList childs = el.getChildNodes();
        size = childs.getLength();
        for (int i = 0; i < size; ++i) {
            Node child = childs.item(i);
            XMLUtils.prepareElementToSerialize(child);
        }
    }

    public static String prepareString(StringBuilder buf, String nodeValue) {
        buf.setLength(0);
        for (int j = 0; j < nodeValue.length(); ++j) {
            char ch = nodeValue.charAt(j);
            char ich = ch;
            if (ich == '\t' || ich == '\n' || ich == '\r' || ich >= ' ' && ich <= '\ud7ff' || ich >= '\ue000' && ich <= '\ufffd' || ich >= '\u10000' && ich <= '\u10ffff') {
                buf.append(ch);
                continue;
            }
            buf.append("\\u");
            buf.append((int)ich);
        }
        return buf.toString();
    }

    public static void transform(Source xml, Source xslt, Result res, String enc) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(xslt);
        transformer.transform(xml, res);
        if (enc != null) {
            transformer.setOutputProperty("encoding", enc);
        }
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
    }

    public static List<Element> toList(Iterable<Element> elements) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Element rowElement : elements) {
            list.add(rowElement);
        }
        return list;
    }

    public static String escapeXmlNotValid(StringBuilder buf, String value) {
        boolean was = false;
        if (buf == null) {
            buf = new StringBuilder(value.length() + 10);
        } else {
            buf.setLength(0);
        }
        for (int j = 0; j < value.length(); ++j) {
            char ch = value.charAt(j);
            char ich = ch;
            if (ich >= ' ' && ich <= '\ud7ff' || ich == '\t' || ich == '\n' || ich == '\r' || ich >= '\ue000' && ich <= '\ufffd' || ich >= '\u10000' && ich <= '\u10ffff') {
                if (!was) continue;
                buf.append(ch);
                continue;
            }
            if (!was) {
                was = true;
                buf.append(value, 0, j);
            }
            buf.append("\\u");
            buf.append((int)ich);
        }
        if (!was) {
            return value;
        }
        return buf.toString();
    }

    private static class ElementParameterMap
    extends ParameterMap {
        private Element element;
        private Map<String, String> data = null;

        public ElementParameterMap(Element element) {
            assert (element != null);
            this.element = element;
        }

        @Override
        public String get(String key, String def) {
            if (this.data != null) {
                String result = this.data.get(key);
                return result != null ? result : def;
            }
            assert (this.element != null);
            String value = this.element.getAttribute(key);
            if (value == null || value.length() == 0) {
                return def;
            }
            return value;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            if (this.data != null) {
                return this.data.entrySet();
            }
            this.data = XMLUtils.attributesToMap0(this.element, false);
            this.element = null;
            return this.data.entrySet();
        }
    }

    public static class XMLEventReaderParameterMap
    extends ParameterMap.DefaultParameterMap {
        public XMLEventReaderParameterMap() {
            super(new HashMap<String, String>());
        }

        public void read(StartElement element) {
            this.data.clear();
            Iterator<Attribute> i = element.getAttributes();
            while (i.hasNext()) {
                Attribute attr = i.next();
                this.data.put(attr.getName().getLocalPart(), attr.getValue());
            }
        }
    }

    public static class XMLStreamReaderParameterMap
    extends ParameterMap.DefaultParameterMap {
        public XMLStreamReaderParameterMap() {
            super(new HashMap<String, String>());
        }

        public void read(XMLStreamReader reader) {
            this.data.clear();
            int size = reader.getAttributeCount();
            for (int i = 0; i < size; ++i) {
                this.data.put(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
            }
        }
    }

    public static interface BGXMLEventReader
    extends XMLEventReader {
        public int getCurrentDepth();

        @Deprecated
        public Iterable<StartElement> newStartElementIterator(String var1);

        public Iterable<StartElement> iterable(String var1);

        public String getAttributeValue(StartElement var1, String var2);

        public Map<String, String> getAttributes(StartElement var1);
    }
}

