/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.bootstrap;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.LogManager;
import ru.bitel.common.bootstrap.BootstrapClassLoader;

public class Boot {
    public static final String PREFIX = "ru.bitel.common.bootstrap.";
    public static final String ADMIN_PORT = "ru.bitel.common.bootstrap.adminPort";
    public static final String BOOTSTRAP_BUNDLE = "ru.bitel.common.bootstrap.bootstrapBundle";
    protected static Boot bootstrap;
    protected String mainClass;
    protected ClassLoader classLoader;
    public static final String LIB_APP_DIR = "lib/app";
    public static final String LIB_APP_UPDATE_DIR = "lib.app.update";

    protected String[] init(String[] args) throws SecurityException, IllegalArgumentException, MalformedURLException {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        BootstrapClassLoader loader = new BootstrapClassLoader("lib", new URL[]{new File("classes").toURI().toURL()}, parent);
        Thread.currentThread().setContextClassLoader(loader);
        if (args.length <= 0 || args[0] == null || args[0].length() == 0) {
            throw new IllegalArgumentException("Main class not specified!");
        }
        this.mainClass = args[0];
        this.classLoader = loader;
        return Arrays.copyOfRange(args, 1, args.length);
    }

    private void updateLibs() {
        File currentLib = new File(LIB_APP_DIR);
        File libUpdate = new File(LIB_APP_UPDATE_DIR);
        if (libUpdate.exists() && libUpdate.canRead() && currentLib.exists() && currentLib.canWrite()) {
            for (File file : libUpdate.listFiles()) {
                String existsLibName = currentLib.getAbsolutePath() + File.separator + file.getName();
                File existsLib = new File(existsLibName);
                if (existsLib.exists()) {
                    existsLib.delete();
                }
                file.renameTo(new File(existsLibName));
                System.out.println("Updated " + file.getName());
            }
        }
    }

    private void print() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(System.getProperty("java.vendor"));
        buffer.append(" ");
        buffer.append(System.getProperty("java.vm.name"));
        buffer.append(" [");
        buffer.append(System.getProperty("java.version"));
        buffer.append("] ");
        buffer.append(System.getProperty("java.home"));
        System.out.println("Java Runtime: " + buffer.toString());
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeMXBean != null) {
            System.out.println("  Runtime name: " + runtimeMXBean.getName());
        }
        System.out.println("  Java endorsed dirs: " + System.getProperty("java.endorsed.dirs"));
        System.out.println("  OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " [" + System.getProperty("os.arch") + "], file.encoding: " + System.getProperty("file.encoding") + ", user.name: " + System.getProperty("user.name"));
        buffer = new StringBuilder();
        buffer.append("current=");
        buffer.append(Runtime.getRuntime().totalMemory() / 1024L);
        buffer.append("k  free=");
        buffer.append(Runtime.getRuntime().freeMemory() / 1024L);
        buffer.append("k  max=");
        buffer.append(Runtime.getRuntime().maxMemory() / 1024L);
        buffer.append("k");
        System.out.println("  Heap sizes: " + buffer.toString());
    }

    protected void boot(String[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MalformedURLException {
        if (System.getProperty("log4j.configuration") != null || args.length > 1 && ("start".equals(args[1]) || "-estart".equals(args[1]))) {
            this.updateLibs();
        }
        args = this.init(args);
        if (!"0".equals(System.getProperty("boot.info", "0"))) {
            this.print();
        }
        Class<?> clazz = Class.forName(this.mainClass, true, this.classLoader);
        Method main = clazz.getMethod("main", String[].class);
        main.invoke(null, new Object[]{args});
    }

    protected boolean exitImpl() {
        try {
            Class<?> clazz = Class.forName(this.mainClass, true, this.classLoader);
            Method exit = clazz.getMethod("exit", new Class[0]);
            exit.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void loadProperies(ClassLoader loader, String bundleName) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), loader);
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = bundle.getString(key);
                if (System.getProperties().containsKey(key) || value == null || value.trim().length() <= 0) continue;
                System.setProperty(key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        try {
            bootstrap = new Boot();
            bootstrap.boot(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogManager.shutdown();
            System.exit(1);
        }
    }

    public static void exit() {
        bootstrap.exitImpl();
    }
}

