/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.io.IOException;
import java.io.InputStream;
import ru.bitel.common.io.Base64;

public class Base64InputStream
extends InputStream {
    private InputStream inputStream;
    private int[] currentBuffer;
    private int currentBufferCounter = 0;
    private boolean eof = false;

    public Base64InputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.currentBuffer == null || this.currentBufferCounter == this.currentBuffer.length) {
            if (this.eof) {
                return -1;
            }
            this.flushbuffer();
            if (this.currentBuffer.length == 0) {
                this.currentBuffer = null;
                return -1;
            }
            this.currentBufferCounter = 0;
        }
        return this.currentBuffer[this.currentBufferCounter++];
    }

    private void flushbuffer() throws IOException {
        int l;
        char[] four = new char[4];
        int i = 0;
        do {
            int b2;
            if ((b2 = this.inputStream.read()) == -1) {
                if (i != 0) {
                    throw new IOException("Bad base64 stream");
                }
                this.currentBuffer = new int[0];
                this.eof = true;
                return;
            }
            char c = (char)b2;
            if (Base64.CHARS.indexOf(c) != -1 || c == Base64.PAD) {
                four[i++] = c;
                continue;
            }
            if (c == '\r' || c == '\n') continue;
            throw new IOException("Bad base64 stream");
        } while (i < 4);
        boolean padded = false;
        for (i = 0; i < 4; ++i) {
            if (four[i] != Base64.PAD) {
                if (!padded) continue;
                throw new IOException("Bad base64 stream");
            }
            if (padded) continue;
            padded = true;
        }
        if (four[3] == Base64.PAD) {
            if (this.inputStream.read() != -1) {
                throw new IOException("Bad base64 stream");
            }
            this.eof = true;
            l = four[2] == Base64.PAD ? 1 : 2;
        } else {
            l = 3;
        }
        int aux = 0;
        for (i = 0; i < 4; ++i) {
            if (four[i] == Base64.PAD) continue;
            aux |= Base64.CHARS.indexOf(four[i]) << 6 * (3 - i);
        }
        this.currentBuffer = new int[l];
        for (i = 0; i < l; ++i) {
            this.currentBuffer[i] = aux >>> 8 * (2 - i) & 0xFF;
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

