/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class ThreadedPrintStream
extends PrintStream {
    protected PrintStream wrapped = null;
    protected ThreadLocal<PrintStream> streams = new InheritableThreadLocal<PrintStream>();
    protected ThreadLocal<ByteArrayOutputStream> data = new InheritableThreadLocal<ByteArrayOutputStream>();

    public ThreadedPrintStream(PrintStream wrapped) {
        super(wrapped);
        this.wrapped = wrapped;
    }

    public PrintStream getWrapped() {
        return this.wrapped;
    }

    public void startCapture() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        this.data.set(baos);
        this.streams.set(new PrintStream(baos));
    }

    public void startCapture(PrintStream printStream) {
        this.streams.set(printStream);
    }

    public void stopCapture() {
        this.streams.set(null);
        this.data.set(null);
    }

    public String stopCaptureAndGet() {
        ByteArrayOutputStream baos = this.data.get();
        this.streams.set(null);
        if (baos == null) {
            return null;
        }
        this.data.set(null);
        return baos.toString();
    }

    protected PrintStream getPrintStream() {
        PrintStream ps = this.streams.get();
        if (ps == null) {
            ps = this.wrapped;
        }
        return ps;
    }

    @Override
    public void flush() {
        this.getPrintStream().flush();
    }

    @Override
    public void close() {
        this.getPrintStream().close();
    }

    @Override
    public boolean checkError() {
        return this.getPrintStream().checkError();
    }

    @Override
    protected void setError() {
    }

    @Override
    public void write(int b2) {
        this.getPrintStream().write(b2);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.getPrintStream().write(b2);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.getPrintStream().write(buf, off, len);
    }

    @Override
    public void print(boolean b2) {
        this.getPrintStream().print(b2);
    }

    @Override
    public void print(char c) {
        this.getPrintStream().print(c);
    }

    @Override
    public void print(int i) {
        this.getPrintStream().print(i);
    }

    @Override
    public void print(long l) {
        this.getPrintStream().print(l);
    }

    @Override
    public void print(float f) {
        this.getPrintStream().print(f);
    }

    @Override
    public void print(double d) {
        this.getPrintStream().print(d);
    }

    @Override
    public void print(char[] s) {
        this.getPrintStream().print(s);
    }

    @Override
    public void print(String s) {
        this.getPrintStream().print(s);
    }

    @Override
    public void print(Object obj) {
        this.getPrintStream().print(obj);
    }

    @Override
    public void println() {
        this.getPrintStream().println();
    }

    @Override
    public void println(boolean x) {
        this.getPrintStream().println(x);
    }

    @Override
    public void println(char x) {
        this.getPrintStream().println(x);
    }

    @Override
    public void println(int x) {
        this.getPrintStream().println(x);
    }

    @Override
    public void println(long x) {
        this.getPrintStream().println(x);
    }

    @Override
    public void println(float x) {
        this.getPrintStream().println(x);
    }

    @Override
    public void println(double x) {
        this.getPrintStream().println(x);
    }

    @Override
    public void println(char[] x) {
        this.getPrintStream().println(x);
    }

    @Override
    public void println(String x) {
        this.getPrintStream().println(x);
    }

    @Override
    public void println(Object x) {
        this.getPrintStream().println(x);
    }
}

