/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.CyclicBuffer;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.TriggeringEventEvaluator;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

public class Log4jIMAppender
extends AppenderSkeleton {
    private String host;
    private String serviceName;
    private int port = 5222;
    private String username;
    private String password;
    private String recipient;
    private String resource;
    private int bufferSize = 56;
    protected TriggeringEventEvaluator evaluator;
    protected CyclicBuffer cb;
    protected XMPPConnection con;
    protected Chat chat;

    public Log4jIMAppender() {
        this.evaluator = new TriggeringEventEvaluator(){

            public boolean isTriggeringEvent(LoggingEvent event) {
                return Log4jIMAppender.this.isAsSevereAsThreshold((Priority)event.getLevel());
            }
        };
    }

    public Log4jIMAppender(TriggeringEventEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void setThreshold(Priority threshold) {
        super.setThreshold(threshold);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setEvaluatorClass(String value) {
        this.evaluator = (TriggeringEventEvaluator)OptionConverter.instantiateByClassName((String)value, TriggeringEventEvaluator.class, (Object)this.evaluator);
    }

    public String getEvaluatorClass() {
        return this.evaluator == null ? null : this.evaluator.getClass().getName();
    }

    public void activateOptions() {
        try {
            this.cb = new CyclicBuffer(this.bufferSize);
            ConnectionConfiguration conf = new ConnectionConfiguration(this.host, this.port, this.serviceName);
            conf.setSASLAuthenticationEnabled(true);
            XMPPConnection connection = new XMPPConnection(conf);
            connection.connect();
            connection.login(this.username, this.password, this.resource != null ? this.resource : "Log4jIMAppender");
            this.con = connection;
            this.chat = connection.getChatManager().createChat(this.recipient, new MessageListener(){

                public void processMessage(Chat arg0, Message arg1) {
                }
            });
        }
        catch (Exception e) {
            this.errorHandler.error("Error while activating options for appender named [" + this.name + "]", e, 0);
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug((String)("Closing appender [" + this.name + "]"));
        this.closed = true;
        if (this.con != null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setStatus("Shutdown...");
            this.con.sendPacket((Packet)presence);
            this.con.disconnect();
        }
        this.con = null;
        this.chat = null;
    }

    public void append(LoggingEvent event) {
        try {
            this.cb.add(event);
            if (this.evaluator.isTriggeringEvent(event)) {
                this.sendBuffer();
            }
        }
        catch (Exception e) {
            if (this.chat == null) {
                this.errorHandler.error("Chat object not configured");
            } else if (this.layout == null) {
                this.errorHandler.error("No layout set for appender named [" + this.name + "]");
            }
            this.errorHandler.error("Exception: ", e, 0);
        }
    }

    protected void sendBuffer() {
        try {
            StringBuilder buf = new StringBuilder();
            int len = this.cb.length();
            for (int i = 0; i < len; ++i) {
                String[] s;
                LoggingEvent event = this.cb.get();
                buf.append(this.layout.format(event));
                if (!this.layout.ignoresThrowable() || (s = event.getThrowableStrRep()) == null) continue;
                for (int j = 0; j < s.length; ++j) {
                    buf.append(Layout.LINE_SEP);
                    buf.append(s[j]);
                }
            }
            this.chat.sendMessage(buf.toString());
        }
        catch (Exception e) {
            this.errorHandler.error("Could not send message in IMAppender [" + this.name + "]", e, 0);
        }
    }

    public boolean requiresLayout() {
        return true;
    }
}

