/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.ws.Service;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingSOAPHandlerClient
implements SOAPHandler<SOAPMessageContext> {
    private final Service service;
    private final Logger logger;
    private final Level level;

    public LoggingSOAPHandlerClient(Service service, Logger logger, Level level) {
        this.service = service;
        this.logger = logger;
        this.level = level;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext context) {
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (!this.logger.isEnabledFor((Priority)this.level)) {
            return true;
        }
        try {
            boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outbound) {
                QName operation = (QName)context.get((Object)"javax.xml.ws.wsdl.operation");
                this.logger.log((Priority)this.level, (Object)(this.service.getWSDLDocumentLocation() + " -> " + context.get((Object)"javax.xml.ws.wsdl.service") + (operation != null ? ":" + operation.getLocalPart() : "")));
                if (!(context.getMessage().countAttachments() != 0 || operation != null && operation.getLocalPart().contains("File"))) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(500);
                    context.getMessage().writeTo((OutputStream)out);
                    this.logger.log((Priority)this.level, (Object)new String(out.toByteArray(), "UTF-8"));
                }
            } else if (context.getMessage().countAttachments() == 0) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(500);
                context.getMessage().writeTo((OutputStream)out);
                this.logger.log((Priority)this.level, (Object)new String(out.toByteArray(), "UTF-8"));
            }
        }
        catch (SOAPException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

