/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.server.multipart;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.server.multipart.FilePart;
import ru.bitel.common.server.multipart.MultipartParser;
import ru.bitel.common.server.multipart.ParamPart;
import ru.bitel.common.server.multipart.Part;
import ru.bitel.common.server.multipart.UploadedFile;

public class MultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    protected Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    protected Map<String, UploadedFile> files = new HashMap<String, UploadedFile>();

    public MultipartRequest(ServletRequest request, String saveDirectory) throws IOException {
        this((HttpServletRequest)request, saveDirectory);
    }

    public MultipartRequest(ServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this((HttpServletRequest)request, saveDirectory, maxPostSize);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory) throws IOException {
        this(request, saveDirectory, Setup.getSetup().getInt("multipart.max.post.size", 0x100000));
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        Part part = null;
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (saveDirectory == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (maxPostSize <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        File dir = new File(saveDirectory);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + saveDirectory);
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + saveDirectory);
        }
        MultipartParser parser = new MultipartParser(request, maxPostSize);
        while ((part = parser.readNextPart()) != null) {
            String name = part.getName();
            if (part.isParam()) {
                ParamPart paramPart = (ParamPart)part;
                String value = paramPart.getStringValue(request.getCharacterEncoding());
                List<String> existingValues = this.parameters.get(name);
                if (existingValues == null) {
                    existingValues = new ArrayList<String>();
                    this.parameters.put(name, existingValues);
                }
                existingValues.add(value);
                continue;
            }
            if (!part.isFile()) continue;
            FilePart filePart = (FilePart)part;
            String fileName = filePart.getFileName();
            if (fileName != null) {
                filePart.writeTo(dir);
                this.files.put(name, new UploadedFile(dir.toString(), fileName, filePart.getContentType()));
                continue;
            }
            this.files.put(name, new UploadedFile(null, null, null));
        }
        for (Map.Entry p : request.getParameterMap().entrySet()) {
            String name = (String)p.getKey();
            for (String value : (String[])p.getValue()) {
                List<String> existingValues = this.parameters.get(name);
                if (existingValues == null) {
                    existingValues = new ArrayList<String>();
                    this.parameters.put(name, existingValues);
                }
                existingValues.add(value);
            }
        }
    }

    public String getFileContentType(String name) {
        String fileContentType = null;
        try {
            UploadedFile uploadedFile = this.files.get(name);
            if (uploadedFile != null) {
                fileContentType = uploadedFile.getContentType();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileContentType;
    }

    public File getFile(String name) {
        File file = null;
        try {
            UploadedFile uploadedFile = this.files.get(name);
            if (uploadedFile != null) {
                file = uploadedFile.getFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public Set<String> getFileNames() {
        return this.files.keySet();
    }

    public String getFileSystemName(String name) {
        String fileName = null;
        try {
            UploadedFile uploadedFile = this.files.get(name);
            if (uploadedFile != null) {
                fileName = uploadedFile.getFileSystemName();
            }
        }
        catch (Exception _ex) {
            return null;
        }
        return fileName;
    }

    public String getParameter(String name) {
        try {
            List<String> values = this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            String value = values.get(values.size() - 1);
            return value;
        }
        catch (Exception _ex) {
            return null;
        }
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public String[] getParameterValues(String name) {
        String[] valuesArray = null;
        try {
            List<String> values = this.parameters.get(name);
            if (values != null && values.size() > 0) {
                valuesArray = new String[values.size()];
                values.toArray(valuesArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valuesArray;
    }
}

