/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.CityItem;

abstract class AbstractCityItemDao<B extends IdTitle>
extends AbstractIdDao<B>
implements Directory<B> {
    public AbstractCityItemDao(Connection con, String tableName) {
        super(con, 0, tableName);
    }

    protected abstract B newBean();

    @Override
    protected B getFromRS(ResultSet rs) throws SQLException, BGException {
        B result = this.newBean();
        ((Id)result).setId(rs.getInt("id"));
        ((CityItem)result).setCityId(rs.getInt("cityid"));
        ((IdTitle)result).setTitle(rs.getString("title"));
        return result;
    }

    @Override
    protected void updateImpl(B b2) throws BGException, SQLException {
        PreparedStatement ps;
        if (((Id)b2).getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (cityid, title) VALUES (?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET cityid=?, title=? WHERE id=?");
            ps.setInt(3, ((Id)b2).getId());
        }
        ps.setInt(1, ((CityItem)b2).getCityId());
        ps.setString(2, ((IdTitle)b2).getTitle());
        ps.executeUpdate();
        if (((Id)b2).getId() <= 0) {
            ((Id)b2).setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    public List<B> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }

    @Override
    public B get(String title) throws BGException {
        return (B)((IdTitle)super.get("title=?", title));
    }

    public List<B> list(int cityId, String title) throws BGException {
        return super.list("(? OR cityid=?) AND (? OR title LIKE ?)", "title", cityId <= 0, cityId, Utils.isBlankString(title), title + "%");
    }
}

