/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrHouse;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrHouseDao
extends EntityAttrDefaultDao<EntityAttrHouse> {
    public EntityAttrHouseDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String houseTable) {
        super(con, entityAttrDao, houseTable);
    }

    @Override
    protected PreparedStatement getSelectPS(int entityId, int entitySpecAttrId) throws SQLException {
        if (this.selectPS == null) {
            this.selectPS = this.con.prepareStatement("SELECT v." + this.valueName() + ", t.title FROM " + this.table + " as v LEFT JOIN address_house as t ON t.id=v." + this.valueName() + " WHERE v." + this.idName() + "=? AND v." + this.typeName() + "=?");
        }
        this.selectPS.setInt(1, entityId);
        this.selectPS.setInt(2, entitySpecAttrId);
        return this.selectPS;
    }

    @Override
    public EntityAttrHouse get(int entityId, int attrSpecId) throws SQLException {
        PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        EntityAttrHouse result = rs.next() ? new EntityAttrHouse(entityId, attrSpecId, rs.getInt(1), rs.getString(2)) : null;
        rs.close();
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a2) throws SQLException {
        PreparedStatement ps = this.getInsertPS(entityId, a2.getEntitySpecAttrId());
        ps.setInt(3, ((EntityAttrHouse)a2).getHouseId());
        ps.executeUpdate();
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrHouse attr) throws SQLException {
        PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
        ps.setInt(1, attr.getHouseId());
        if (ps.executeUpdate() == 0) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            ps.setInt(3, attr.getHouseId());
            ps.executeUpdate();
            return true;
        }
        ps = this.entityAttrDao.getSelectOldValuePS();
        ResultSet rs = ps.executeQuery();
        int oldValue = rs.next() ? rs.getInt(1) : 0;
        rs.close();
        return attr.getHouseId() != oldValue;
    }
}

