/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server.tariff;

import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.tree.server.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class ProductSpecFilterTariffTreeNode
extends TariffTreeNode<AbstractTariffRequest<?>, TariffContext, TreeContext, ThreadContext> {
    private final Set<Integer> productSpecIds;
    private final boolean modeOr;

    public ProductSpecFilterTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.productSpecIds = new HashSet<Integer>(Utils.toIntegerList(parameterMap.get("productSpecIds", "")));
        this.modeOr = parameterMap.getInt("mode", 0) == 0;
    }

    protected Set<Integer> getActiveProductSpecIds(AbstractTariffRequest<?> req) {
        long time = req.getTime().getTimeInMillis();
        return req.getActiveProductSpecIds(time, null);
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        if (this.productSpecIds.size() == 0) {
            Set<Long> acceptedSet = req.getAcceptedSet(ProductSpecFilterTariffTreeNode.class);
            if (!acceptedSet.contains(parentTreeNodeId)) {
                acceptedSet.add(parentTreeNodeId);
                return 1;
            }
            return 0;
        }
        Set<Integer> activeProductSpecIds = this.getActiveProductSpecIds(req);
        if (activeProductSpecIds == null) {
            return 0;
        }
        if (this.modeOr) {
            if (activeProductSpecIds.size() < this.productSpecIds.size()) {
                for (Integer id : activeProductSpecIds) {
                    if (!this.productSpecIds.contains(id)) continue;
                    Set<Long> acceptedSet = req.getAcceptedSet(ProductSpecFilterTariffTreeNode.class);
                    acceptedSet.add(parentTreeNodeId);
                    return 1;
                }
            } else {
                for (Integer id : this.productSpecIds) {
                    if (!activeProductSpecIds.contains(id)) continue;
                    Set<Long> acceptedSet = req.getAcceptedSet(ProductSpecFilterTariffTreeNode.class);
                    acceptedSet.add(parentTreeNodeId);
                    return 1;
                }
            }
        } else if (activeProductSpecIds.containsAll(this.productSpecIds)) {
            Set<Long> acceptedSet = req.getAcceptedSet(ProductSpecFilterTariffTreeNode.class);
            acceptedSet.add(parentTreeNodeId);
            return 1;
        }
        return 0;
    }
}

