/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneCategory;

public class PhoneCategoryDao
extends AbstractIdDao<PhoneCategory> {
    public PhoneCategoryDao(Connection con, int moduleId) {
        super(con, moduleId, "inv_phone_category");
    }

    public List<PhoneCategory> listPhoneCategory() throws BGException {
        return super.list(null, "id", new Object[0]);
    }

    @Override
    protected PhoneCategory getFromRS(ResultSet rs) throws SQLException, BGException {
        PhoneCategory result = new PhoneCategory();
        result.setId(rs.getInt("id"));
        result.setParentId(rs.getInt("parentId"));
        result.setTitle(rs.getString("title"));
        return result;
    }

    @Override
    protected void updateImpl(PhoneCategory phoneCategory) throws BGException, SQLException {
        if (phoneCategory == null || Utils.isBlankString(phoneCategory.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        boolean insert = phoneCategory.getId() <= 0;
        int parameterIndex = 1;
        try (PreparedStatement ps = this.con.prepareStatement((insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET parentId=?, title=?" + (insert ? "" : " WHERE id=?"), 1);){
            if (phoneCategory.getParentId() > 0) {
                ps.setInt(parameterIndex++, phoneCategory.getParentId());
            } else {
                ps.setNull(parameterIndex++, 4);
            }
            ps.setString(parameterIndex++, phoneCategory.getTitle());
            if (!insert) {
                ps.setInt(parameterIndex++, phoneCategory.getId());
            }
            ps.executeUpdate();
            if (insert) {
                phoneCategory.setId(ServerUtils.lastInsertId(ps));
            }
        }
    }

    public PhoneCategory root() throws BGException {
        PhoneCategory root = new PhoneCategory();
        root.setId(0);
        root.setTitle("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u043d\u043e\u043c\u0435\u0440\u043e\u0432");
        return TreeUtils.tree(this.list(null, null, new Object[0]), root);
    }
}

