/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.order.product.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.PersonalTariffManager;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.jws.WebService;
import org.apache.commons.collections.CollectionUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.tv.runtime.TvTarifficationManager;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Tied;
import ru.bitel.common.util.Ranger;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;
import ru.bitel.oss.systems.order.product.common.event.ProductOfferingListEvent;
import ru.bitel.oss.systems.order.product.common.event.ProductOrderEvent;
import ru.bitel.oss.systems.order.product.common.service.ProductOrderService;

@WebService(endpointInterface="ru.bitel.oss.systems.order.product.common.service.ProductOrderService")
public class ProductOrderServiceImpl
extends AbstractService
implements ProductOrderService {
    @Resource
    private ProductService productService;
    private ContractManager contractManager;
    private Tied.Utils<Product, ProductSpec> tiedUtils = null;
    private Tied.TieResolver<Product, ProductSpec> tiedResolver = null;

    private ContractManager getContractManager() {
        if (this.contractManager == null) {
            this.contractManager = new ContractManager(this.getConnection());
        }
        return this.contractManager;
    }

    public Tied.TieResolver<Product, ProductSpec> getTiedResolver() throws BGException {
        if (this.tiedResolver != null) {
            return this.tiedResolver;
        }
        final Map<Integer, ProductSpec> map = Id.newMap(this.productService.productSpecList(null, null, null, null, null));
        this.tiedResolver = new Tied.TieResolver<Product, ProductSpec>(){

            @Override
            public ProductSpec resolve(Product t) {
                return (ProductSpec)map.get(this.resolveId(t));
            }

            @Override
            public int resolveId(Product t) {
                return t.getProductSpecId();
            }

            @Override
            public ProductSpec resolve(Integer id) {
                return (ProductSpec)map.get(id);
            }
        };
        return this.tiedResolver;
    }

    public Tied.Utils<Product, ProductSpec> getTieUtils() throws BGException {
        if (this.tiedUtils != null) {
            return this.tiedUtils;
        }
        this.tiedUtils = new Tied.Utils<Product, ProductSpec>(this.getTiedResolver(), new Ranger<Product, Date>(){

            @Override
            public Date getMaxValue(Product r) {
                return r.getTimeTo();
            }

            @Override
            public Date getMinValue(Product r) {
                return r.getTimeFrom();
            }
        });
        return this.tiedUtils;
    }

    protected void processTieException(Tied.TieUnresolvedException ex) throws BGMessageException {
        StringBuilder sb = new StringBuilder();
        if (ex.getDependsUnresolved().size() > 0) {
            for (Map.Entry<? extends Tied, Set<Object>> e : ex.getDependsUnresolved().entrySet()) {
                sb.append(MessageFormat.format("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \"{0}\" \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0430 {2,choice,1#\u043f\u0440\u043e\u0434\u0443\u043a\u0442|1<\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b:} \"{1}\".", e.getKey(), Utils.toString((Iterable)e.getValue(), "\", \""), e.getValue().size())).append("\n");
            }
        }
        if (ex.getIncompatibleUnresolved().size() > 0) {
            for (Map.Entry<? extends Tied, Set<Object>> e : ex.getIncompatibleUnresolved().entrySet()) {
                sb.append(MessageFormat.format("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \"{0}\" \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 {2,choice,1#\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u043c|1<\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430\u043c\u0438:} \"{1}\".", e.getKey(), Utils.toString((Iterable)e.getValue(), "\", \""), e.getValue().size())).append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        throw new BGMessageException(sb.toString());
    }

    @Override
    public List<ProductOffering> productTariffOfferingList(Integer moduleId, int tariffId, Date time, boolean availableOnly) throws BGException {
        List<ProductOffering> result;
        if (moduleId == null && this.moduleId > 0) {
            moduleId = this.moduleId;
        }
        if (time == null) {
            time = new Date();
        }
        List<ProductSpec> fullProductSpecList = this.productService.productSpecList(moduleId, time, time, null, null);
        if (moduleId != null && moduleId > 0) {
            fullProductSpecList.addAll(this.productService.productSpecList(0, time, time, null, null));
        }
        HashSet<Integer> tariffIds = new HashSet<Integer>();
        tariffIds.add(tariffId);
        List<ProductOffering> productOfferingList = new ArrayList<ProductOffering>();
        for (ProductSpec productSpec : fullProductSpecList) {
            ProductOffering productOffering = new ProductOffering();
            productOffering.setProductSpec(productSpec);
            ArrayList<ProductOfferingActivationMode> productOfferingActivationModeList = new ArrayList<ProductOfferingActivationMode>();
            productOffering.setActivationModeList(productOfferingActivationModeList);
            productOfferingList.add(productOffering);
            if (productSpec.getTariffIds().size() > 0 && CollectionUtils.intersection(productSpec.getTariffIds(), tariffIds).size() == 0 || productSpec.getActivationModeList() == null || productSpec.getActivationModeList().size() == 0) continue;
            for (ProductSpecActivationMode activationMode : productSpec.getActivationModeList()) {
                if (!TimeUtils.dateInRange(time, activationMode.getDateFrom(), activationMode.getDateTo())) continue;
                productOfferingActivationModeList.add(new ProductOfferingActivationMode(activationMode, BigDecimal.ZERO));
            }
            productOffering.setEnable(true);
        }
        new TvTarifficationManager(this.context.getSetup(), this.getConnectionSet(), moduleId.intValue()).tarifficateOfferings(this.getConnection(), tariffId, productOfferingList, time);
        ProductOfferingListEvent availableListEvent = EventProcessor.getInstance().request(new ProductOfferingListEvent(moduleId, 0, 0, this.userId, time, null, tariffIds, null, availableOnly, productOfferingList));
        productOfferingList = availableListEvent.getProductOfferingList();
        if (availableOnly) {
            result = new ArrayList();
            for (ProductOffering productOffering : productOfferingList) {
                if (!productOffering.isEnable()) continue;
                result.add(productOffering);
            }
        } else {
            result = productOfferingList;
        }
        return result;
    }

    @Override
    public ProductOffering productOfferingGet(Integer moduleId, int contractId, int accountId, int productSpecId, int activationModeId, Date time, boolean availableOnly, boolean customer) throws BGException {
        List<ProductOffering> productOfferingList = this.productOfferingList(moduleId, contractId, accountId, time, availableOnly, customer, null, productSpecId, activationModeId);
        if (productOfferingList.size() > 0) {
            return productOfferingList.get(0);
        }
        return null;
    }

    @Override
    public List<ProductOffering> productOfferingList(Integer moduleId, int contractId, int accountId, int productSpecId, Date time, boolean availableOnly, boolean customer) throws BGException {
        return this.productOfferingList(moduleId, contractId, accountId, time, availableOnly, customer, null, productSpecId, -1);
    }

    private List<ProductOffering> productOfferingList(Integer moduleId, int contractId, int accountId, Date time, boolean availableOnly, boolean customer, List<Product> activeProductList, int productSpecId, int activationModeId) throws BGException {
        List<ProductOffering> result;
        if (moduleId == null && this.moduleId > 0) {
            moduleId = this.moduleId;
        }
        if (contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (time == null) {
            time = new Date();
        }
        if (activeProductList == null) {
            activeProductList = this.activeProductList(contractId, accountId, time);
        }
        List<ProductSpec> fullProductSpecList = this.productService.productSpecList(moduleId, time, time, null, null);
        if (moduleId != null && moduleId > 0) {
            fullProductSpecList.addAll(this.productService.productSpecList(0, time, time, null, null));
        }
        ContractTariffDao contractTariffDao = new ContractTariffDao(this.getConnection());
        HashSet<Integer> tariffIds = new HashSet<Integer>();
        for (ContractTariff contractTariff : contractTariffDao.list(contractId, time)) {
            tariffIds.add(contractTariff.getTariffPlanId());
        }
        tariffIds.addAll(new PersonalTariffManager(this.getConnection()).getParentTreeTariffIds(contractId, time));
        Contract contract = new ContractManager(this.getConnection()).getContractById(contractId);
        List<ProductOffering> productOfferingList = new ArrayList<ProductOffering>();
        for (ProductSpec productSpec : fullProductSpecList) {
            if (productSpecId > 0 && productSpec.getId() != productSpecId) continue;
            ProductOffering productOffering = new ProductOffering();
            productOffering.setProductSpec(productSpec);
            ArrayList<ProductOfferingActivationMode> productOfferingActivationModeList = new ArrayList<ProductOfferingActivationMode>();
            productOffering.setActivationModeList(productOfferingActivationModeList);
            productOfferingList.add(productOffering);
            if (productSpec.getTariffIds().size() > 0 && CollectionUtils.intersection(productSpec.getTariffIds(), tariffIds).size() == 0 || productSpec.getContractGroups() != 0L && (contract.getGroups() & productSpec.getContractGroups()) == 0L || customer && (productSpec.isHideForCustomer() || (productSpec.getHideForContractGroupsMode() != 0 ? (contract.getGroups() & productSpec.getHideForContractGroups()) == productSpec.getHideForContractGroups() : productSpec.getHideForContractGroups() != 0L && (contract.getGroups() & productSpec.getHideForContractGroups()) != 0L))) continue;
            if (productSpec.getActivationModeList() == null || productSpec.getActivationModeList().size() == 0) continue;
            for (ProductSpecActivationMode activationMode : productSpec.getActivationModeList()) {
                if (activationModeId > 0 && activationMode.getId() != activationModeId || !TimeUtils.dateInRange(time, activationMode.getDateFrom(), activationMode.getDateTo())) continue;
                productOfferingActivationModeList.add(new ProductOfferingActivationMode(activationMode, BigDecimal.ZERO));
            }
            productOffering.setEnable(true);
        }
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnection(), (Integer)contractId);
        new TvTarifficationManager(this.context.getSetup(), this.getConnectionSet(), moduleId.intValue()).tarifficateOfferings(contractId, accountId, productOfferingList, time);
        ProductOfferingListEvent productOfferingListEvent = new ProductOfferingListEvent(moduleId, contractId, accountId, this.userId, time, contract, tariffIds, activeProductList, availableOnly, productOfferingList);
        ProductOfferingListEvent availableListEvent = EventProcessor.getInstance().request(productOfferingListEvent);
        productOfferingList = availableListEvent.getProductOfferingList();
        if (availableOnly) {
            result = new ArrayList();
            for (ProductOffering productOffering : productOfferingList) {
                if (!productOffering.isEnable()) continue;
                result.add(productOffering);
            }
        } else {
            result = productOfferingList;
        }
        return result;
    }

    private static boolean containsProductSpec(List<ProductOffering> productOfferingList, ProductSpec productSpec) {
        int size = productOfferingList.size();
        for (int i = 0; i < size; ++i) {
            if (!productSpec.equals(productOfferingList.get(i).getProductSpec())) continue;
            return true;
        }
        return false;
    }

    private List<Product> activeProductList(int contractId, int accountId, Date time) throws BGException {
        return this.productService.productList(-1, contractId, accountId, true, null, null, time, null, false, false);
    }

    @Override
    @Deprecated
    public int productActivate(Product product, boolean customer, boolean sync) throws BGException {
        return this.productActivate(product, null, customer, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int productActivate(Product product, Date time, boolean customer, boolean sync) throws BGException {
        boolean timeFromSet;
        if (product == null || product.getContractId() <= 0 || product.getProductSpecId() <= 0 || product.getActivationModeId() <= 0) {
            throw new BGIllegalArgumentException();
        }
        ProductSpec productSpec = this.productService.productSpecGet(product.getProductSpecId());
        if (productSpec == null) {
            throw new BGMessageException("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
        }
        int contractId = product.getContractId();
        int accountId = product.getAccountId();
        boolean timeSet = time != null;
        boolean bl = timeFromSet = product.getTimeFrom() != null && time == null;
        if (timeFromSet) {
            time = product.getTimeFrom();
        }
        time = time == null ? new Date(TimeUtils.rountToSeconds(System.currentTimeMillis())) : new Date(TimeUtils.rountToSeconds(time.getTime()));
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId);
        contractRuntime.lock();
        try {
            List<Product> activeProductList = this.activeProductList(contractId, accountId, time);
            List<ProductOffering> productOffering = this.productOfferingList(productSpec.getModuleId(), contractId, accountId, time, true, customer, activeProductList, productSpec.getId(), product.getActivationModeId());
            if (!ProductOrderServiceImpl.containsProductSpec(productOffering, productSpec)) {
                throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
            }
            ProductSpecActivationMode activationMode = null;
            for (ProductSpecActivationMode mode : productSpec.getActivationModeList()) {
                if (mode.getId() != product.getActivationModeId()) continue;
                activationMode = mode;
                break;
            }
            if (activationMode == null || activationMode.getProductSpecId() != productSpec.getId()) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441 ID " + product.getActivationModeId() + ".");
            }
            if (!TimeUtils.dateInRange(time, activationMode.getDateFrom(), activationMode.getDateTo())) {
                throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u0440\u0435\u0436\u0438\u043c\u043e\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430!");
            }
            ContractManager cm = this.getContractManager();
            Contract contract = cm.getContractById(contractId);
            if (contract == null) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 ID " + contractId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            }
            product.setActivationTime(time);
            product.setDeviceState(sync ? (short)-1 : 1);
            product.setUserId(this.userId);
            product.setTimeFrom(time);
            this.adjustProductPeriod(product, activationMode, timeFromSet);
            Date _productTimeTo = product.getTimeTo();
            try {
                product.setTimeTo(new Date(product.getTimeFrom().getTime() + 1000L));
                this.getTieUtils().checkAdd(activeProductList, product, 14);
            }
            catch (Tied.TieUnresolvedException ex) {
                if (customer || !timeSet && !timeFromSet || ex.getDependsUnresolved() != null && ex.getDependsUnresolved().size() > 0) {
                    this.processTieException(ex);
                }
            }
            finally {
                product.setTimeTo(_productTimeTo);
            }
            int id = this.productService.productUpdate(product);
            product.setId(id);
            ProductOrderEvent activateOrderEvent = EventProcessor.getInstance().request(new ProductOrderEvent(1, contractId, this.userId, customer, productSpec, activationMode, null, product, sync, true));
            if (!activateOrderEvent.isProcess()) {
                throw new BGMessageException(activateOrderEvent.getMessage());
            }
            product = activateOrderEvent.getNewProduct();
            int n = product.getId();
            return n;
        }
        finally {
            contractRuntime.unlock();
        }
    }

    private void adjustProductPeriod(Product product, ProductSpecActivationMode activationMode, boolean timeFromSet) {
        int calendarField;
        int[] modeValue = ProductSpecActivationMode.mode(activationMode.getPeriodMode());
        int modeField = modeValue[0];
        int modeBegin = modeValue[1];
        int modeEnd = modeValue[2];
        switch (modeField) {
            case 1: {
                calendarField = 12;
                break;
            }
            case 2: {
                calendarField = 11;
                break;
            }
            case 3: {
                calendarField = 5;
                break;
            }
            case 4: {
                calendarField = 3;
                break;
            }
            case 5: {
                calendarField = 2;
                break;
            }
            default: {
                calendarField = 2;
            }
        }
        Calendar calendar = TimeUtils.convertDateToCalendar(product.getTimeFrom());
        if (!timeFromSet) {
            if (modeBegin == 2 || modeBegin == 3) {
                TimeUtils.floor(calendar, calendarField);
                if (modeBegin == 3) {
                    calendar.add(calendarField, 1);
                }
            } else if (modeBegin == 4) {
                TimeUtils.clear_MIN_MIL_SEC(calendar);
                calendar.add(11, 1);
            }
            product.setTimeFrom(TimeUtils.convertCalendarToDate(calendar));
        }
        if (product.getTimeTo() == null) {
            if (activationMode.getPeriodAmount() == 0) {
                product.setTimeTo(null);
            } else {
                if (modeEnd == 2) {
                    TimeUtils.floor(calendar, calendarField);
                }
                calendar.add(calendarField, activationMode.getPeriodAmount());
                calendar.add(14, -1);
                product.setTimeTo(TimeUtils.convertCalendarToDate(calendar));
            }
        } else {
            calendar.setTime(product.getTimeTo());
            calendar.set(14, 999);
            product.setTimeTo(TimeUtils.convertCalendarToDate(calendar));
        }
    }

    @Override
    @Deprecated
    public void productDeactivate(int contractId, int productId, Date time, boolean customer, boolean sync) throws BGException {
        this.productDeactivate(contractId, productId, time, customer, sync, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void productDeactivate(int contractId, int productId, Date time, boolean customer, boolean sync, boolean now) throws BGException {
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId);
        contractRuntime.lock();
        try {
            Product product = this.productService.productGet(contractId, productId);
            if (product == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID " + productId + ".");
            }
            if (customer) {
                now = false;
            }
            Product oldProduct = product.clone();
            ProductSpec productSpec = this.productService.productSpecGet(product.getProductSpecId());
            if (productSpec == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0441 ID " + product.getProductSpecId() + ".");
            }
            ProductSpecActivationMode activationMode = null;
            for (ProductSpecActivationMode mode : productSpec.getActivationModeList()) {
                if (mode.getId() != product.getActivationModeId()) continue;
                activationMode = mode;
            }
            if (activationMode == null || activationMode.getProductSpecId() != product.getProductSpecId()) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441 ID " + product.getActivationModeId() + ".");
            }
            GregorianCalendar calendar = new GregorianCalendar();
            try {
                Date close;
                if (time == null) {
                    time = new Date();
                }
                calendar.setTime(time);
                calendar.set(14, 0);
                time = calendar.getTime();
                List<Product> activeProductList = this.activeProductList(contractId, product.getAccountId(), time);
                if (product.getTimeTo() != null && (customer || !product.getTimeTo().after(time))) {
                    throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0443\u0436\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442.");
                }
                if (product.getTimeFrom().compareTo(time) > 0) {
                    close = time;
                    product.setTimeTo(close);
                    this.getTieUtils().checkRemove(activeProductList, product, 14);
                } else {
                    close = time;
                    calendar.setTime(close);
                    calendar.set(14, 0);
                    int deactivationMode = now ? 0 : activationMode.getDeactivationMode();
                    switch (deactivationMode) {
                        case 10: {
                            List<ProductPeriod> productPeriodList = this.productService.productPeriodList(contractId, productId);
                            if (productPeriodList.size() <= 0) break;
                            ProductPeriod lastPeriod = productPeriodList.get(productPeriodList.size() - 1);
                            if (lastPeriod.getTimeTo() == null) {
                                throw new BGException("lastProductPeriod.getTimeTo() == null");
                            }
                            if (calendar.getTime().compareTo(lastPeriod.getTimeTo()) >= 0) break;
                            calendar.setTime(lastPeriod.getTimeTo());
                            calendar.set(14, 0);
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 2: {
                            TimeUtils.clear_MIN_MIL_SEC(calendar);
                            ((Calendar)calendar).add(11, 1);
                            break;
                        }
                        case 3: {
                            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
                            ((Calendar)calendar).add(5, 1);
                            break;
                        }
                        case 4: {
                            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
                            calendar.set(7, calendar.getFirstDayOfWeek());
                            ((Calendar)calendar).add(3, 1);
                            break;
                        }
                        case 5: {
                            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
                            calendar.set(5, 1);
                            ((Calendar)calendar).add(2, 1);
                            break;
                        }
                        default: {
                            throw new BGIllegalArgumentException();
                        }
                    }
                    close = TimeUtils.convertCalendarToDate(calendar);
                    product.setTimeTo(close);
                    ArrayList<ProductSpec> depends = new ArrayList<ProductSpec>();
                    for (Product a2 : activeProductList) {
                        ProductSpec productSpec1 = this.getTiedResolver().resolve(a2);
                        if (productSpec1.getDepends() == null || !productSpec1.getDepends().contains(product.getProductSpecId()) || !RangeUtils.intersects(a2.getTimeFrom(), a2.getTimeTo(), product.getTimeFrom(), product.getTimeTo()) || a2.getTimeTo() != null) continue;
                        depends.add(productSpec1);
                    }
                    if (depends.size() > 0) {
                        throw new BGMessageException(MessageFormat.format("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \"{0}\" \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0430 {2,choice,1#\u043f\u0440\u043e\u0434\u0443\u043a\u0442|1<\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b:} \"{1}\".", productSpec, Utils.toString(depends, "\", \""), depends.size()));
                    }
                }
            }
            catch (Tied.TieUnresolvedException ex) {
                this.processTieException(ex);
            }
            product.setDeactivationTime(time);
            ProductOrderEvent deactivateOrderEvent = EventProcessor.getInstance().request(new ProductOrderEvent(2, contractId, this.userId, customer, productSpec, activationMode, oldProduct, product, sync, true));
            if (!deactivateOrderEvent.isProcess()) {
                throw new BGMessageException(deactivateOrderEvent.getMessage());
            }
            product = deactivateOrderEvent.getNewProduct();
            this.productService.productUpdate(product);
        }
        finally {
            contractRuntime.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void productReactivate(int contractId, int productId, boolean sync) throws BGException {
        if (contractId <= 0 || productId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId);
        contractRuntime.lock();
        try {
            Product product = this.productService.productGet(contractId, productId);
            if (product == null || product.getContractId() != contractId) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID=" + productId + ".");
            }
            ProductSpec productSpec = this.productService.productSpecGet(product.getProductSpecId());
            if (productSpec == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0441 ID=" + product.getProductSpecId() + ".");
            }
            ProductSpecActivationMode activationMode = null;
            for (ProductSpecActivationMode productSpecActivationMode : productSpec.getActivationModeList()) {
                if (productSpecActivationMode.getId() != product.getActivationModeId()) continue;
                activationMode = productSpecActivationMode;
                break;
            }
            if (activationMode == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441 ID=" + product.getActivationModeId() + ".");
            }
            if (activationMode.getReactivationMode() != 1 || product.getTimeTo() == null || !product.getTimeTo().after(new Date())) {
                throw new BGMessageException("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430!");
            }
            Product oldProduct = product.clone();
            product.setDeactivationTime(null);
            product.setTimeTo(null);
            ProductOrderEvent reactivateOrderEvent = EventProcessor.getInstance().request(new ProductOrderEvent(2, contractId, this.userId, true, productSpec, activationMode, oldProduct, product, sync, true));
            if (!reactivateOrderEvent.isProcess()) {
                throw new BGMessageException(reactivateOrderEvent.getMessage());
            }
            product = reactivateOrderEvent.getNewProduct();
            this.productService.productUpdate(product);
        }
        finally {
            contractRuntime.unlock();
        }
    }
}

