/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.event;

import java.util.Vector;
import uk.co.westhawk.snmp.event.RequestPduEvent;
import uk.co.westhawk.snmp.event.RequestPduListener;
import uk.co.westhawk.snmp.stack.Pdu;

public class RequestPduReceivedSupport {
    public static final String version_id = "@(#)$Id: RequestPduReceivedSupport.java,v 1.4 2006/01/17 17:59:33 birgit Exp $ Copyright Westhawk Ltd";
    private Object source;
    private transient Vector pduListeners;

    public RequestPduReceivedSupport(Object src) {
        this.source = src;
    }

    public synchronized void empty() {
        if (this.pduListeners != null) {
            this.pduListeners.removeAllElements();
        }
    }

    public synchronized int getListenerCount() {
        int c = 0;
        if (this.pduListeners != null) {
            c = this.pduListeners.size();
        }
        return c;
    }

    public synchronized void addRequestPduListener(RequestPduListener listener) {
        if (this.pduListeners == null) {
            this.pduListeners = new Vector(5);
        }
        if (!this.pduListeners.contains(listener)) {
            this.pduListeners.addElement(listener);
        }
    }

    public synchronized void removeRequestPduListener(RequestPduListener listener) {
        if (this.pduListeners != null) {
            this.pduListeners.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireRequestPduReceived(Pdu pdu, int hostPort) {
        Vector copyOfListeners = null;
        if (this.pduListeners != null) {
            Vector vector = this.pduListeners;
            synchronized (vector) {
                copyOfListeners = (Vector)this.pduListeners.clone();
            }
        }
        if (copyOfListeners != null) {
            int sz = copyOfListeners.size();
            for (int i = sz - 1; i >= 0; --i) {
                RequestPduListener listener = (RequestPduListener)copyOfListeners.elementAt(i);
                RequestPduEvent evt = new RequestPduEvent(this.source, pdu, hostPort);
                listener.requestPduReceived(evt);
            }
        }
    }
}

