/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.dao;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.dao.BaseLocaleUrlDefinitionDAO;
import org.apache.tiles.util.LocaleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleUrlDefinitionDAO
extends BaseLocaleUrlDefinitionDAO {
    @Override
    public Definition getDefinition(String name, Locale customizationKey) {
        Map<String, Definition> defsMap = this.getDefinitions(customizationKey);
        return defsMap != null ? defsMap.get(name) : null;
    }

    @Override
    public Map<String, Definition> getDefinitions(Locale customizationKey) {
        List<String> postfixes = LocaleUtil.calculatePostfixes(customizationKey);
        HashMap<String, Definition> localeDefsMap = new HashMap<String, Definition>();
        for (String postfix : postfixes) {
            for (URL url : this.sourceURLs) {
                String path = url.toExternalForm();
                String newPath = LocaleUtil.concatPostfix(path, postfix);
                try {
                    URL newUrl = new URL(newPath);
                    Map<String, Definition> defsMap = this.loadDefinitionsFromURL(newUrl);
                    if (defsMap == null) continue;
                    localeDefsMap.putAll(defsMap);
                }
                catch (MalformedURLException e) {
                    throw new DefinitionsFactoryException("Error parsing URL " + newPath, e);
                }
            }
        }
        return localeDefsMap;
    }
}

