/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.data.AbstractClasspathAwareDataAdapterService;
import net.sf.jasperreports.data.ClasspathAwareDataAdapter;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.util.SecretsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcDataAdapterService
extends AbstractClasspathAwareDataAdapterService {
    private static final Log log = LogFactory.getLog(JdbcDataAdapterService.class);
    public static final String EXCEPTION_MESSAGE_KEY_PASSWORD_REQUIRED = "data.jdbc.password.required";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_URL = "data.jdbc.invalid.url";
    public static final String EXCEPTION_MESSAGE_KEY_CONNECTION_NOT_CREATED = "data.jdbc.connection.not.created";
    private Connection connection = null;

    public JdbcDataAdapterService(ParameterContributorContext paramContribContext, JdbcDataAdapter jdbcDataAdapter) {
        super(paramContribContext, (ClasspathAwareDataAdapter)jdbcDataAdapter);
    }

    public JdbcDataAdapterService(JasperReportsContext jasperReportsContext, JdbcDataAdapter jdbcDataAdapter) {
        super(jasperReportsContext, (ClasspathAwareDataAdapter)jdbcDataAdapter);
    }

    public JdbcDataAdapter getJdbcDataAdapter() {
        return (JdbcDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        try {
            this.connection = this.getConnection();
        }
        catch (SQLException e) {
            throw new JRException(e);
        }
        parameters.put("REPORT_CONNECTION", this.connection);
    }

    public Connection getConnection() throws SQLException {
        JdbcDataAdapter jdbcDataAdapter = this.getJdbcDataAdapter();
        if (jdbcDataAdapter != null) {
            ClassLoader oldThreadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClassLoader(oldThreadClassLoader));
                Class<?> clazz = JRClassLoader.loadClassForRealName(jdbcDataAdapter.getDriver());
                Driver driver = (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Properties connectProps = new Properties();
                Map<String, String> map = jdbcDataAdapter.getProperties();
                if (map != null) {
                    for (String key : map.keySet()) {
                        connectProps.setProperty(key, map.get(key));
                    }
                }
                String password = jdbcDataAdapter.getPassword();
                SecretsUtil secretService = SecretsUtil.getInstance(this.getJasperReportsContext());
                if (secretService != null) {
                    password = secretService.getSecret("net.sf.jasperreports.data.adapter", password);
                }
                connectProps.setProperty("user", jdbcDataAdapter.getUsername());
                connectProps.setProperty("password", password);
                this.connection = driver.connect(jdbcDataAdapter.getUrl(), connectProps);
                if (this.connection == null) {
                    boolean urlValid = driver.acceptsURL(jdbcDataAdapter.getUrl());
                    if (!urlValid) {
                        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INVALID_URL, new Object[]{jdbcDataAdapter.getUrl(), jdbcDataAdapter.getDriver()});
                    }
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CONNECTION_NOT_CREATED, new Object[]{jdbcDataAdapter.getUrl()});
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldThreadClassLoader);
            }
            return this.connection;
        }
        return null;
    }

    public String getPassword() throws JRException {
        throw new JRException(EXCEPTION_MESSAGE_KEY_PASSWORD_REQUIRED, (Object[])null);
    }

    @Override
    public void dispose() {
        block3: {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Error while closing the connection.", (Throwable)ex);
                }
            }
        }
    }
}

