/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.mikrotik;

import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import me.legrange.mikrotik.ApiConnectionException;
import me.legrange.mikrotik.MikrotikApiException;
import me.legrange.mikrotik.ResultListener;
import me.legrange.mikrotik.impl.ApiConnectionImpl;

public abstract class ApiConnection
implements AutoCloseable {
    public static final int DEFAULT_PORT = 8728;
    public static final int DEFAULT_TLS_PORT = 8729;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_COMMAND_TIMEOUT = 60000;

    public static ApiConnection connect(SocketFactory fact, String host, int port, int timeout) throws MikrotikApiException {
        return ApiConnectionImpl.connect(fact, host, port, timeout);
    }

    public static ApiConnection connect(String host) throws MikrotikApiException {
        return ApiConnection.connect(SocketFactory.getDefault(), host, 8728, 60000);
    }

    public abstract boolean isConnected();

    public abstract void login(String var1, String var2) throws MikrotikApiException;

    public abstract List<Map<String, String>> execute(String var1) throws MikrotikApiException;

    public abstract String execute(String var1, ResultListener var2) throws MikrotikApiException;

    public abstract void cancel(String var1) throws MikrotikApiException;

    public abstract void setTimeout(int var1) throws MikrotikApiException;

    @Override
    public abstract void close() throws ApiConnectionException;
}

