/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.mikrotik.impl;

import java.util.Arrays;
import java.util.LinkedList;
import me.legrange.mikrotik.impl.Command;
import me.legrange.mikrotik.impl.Parameter;
import me.legrange.mikrotik.impl.ParseException;
import me.legrange.mikrotik.impl.ScanException;
import me.legrange.mikrotik.impl.Scanner;

class Parser {
    private final Scanner scanner;
    private Scanner.Token token;
    private String text;
    private Command cmd;

    static Command parse(String text) throws ParseException {
        Parser parser = new Parser(text);
        return parser.parse();
    }

    private Command parse() throws ParseException {
        this.command();
        while (!this.is(Scanner.Token.WHERE, Scanner.Token.RETURN, Scanner.Token.EOL)) {
            this.param();
        }
        if (this.token == Scanner.Token.WHERE) {
            this.where();
        }
        if (this.token == Scanner.Token.RETURN) {
            this.returns();
        }
        this.expect(Scanner.Token.EOL);
        return this.cmd;
    }

    private void command() throws ParseException {
        StringBuilder path = new StringBuilder();
        do {
            this.expect(Scanner.Token.SLASH);
            path.append("/");
            this.next();
            this.expect(Scanner.Token.TEXT);
            path.append(this.text);
            this.next();
        } while (this.token == Scanner.Token.SLASH);
        this.cmd = new Command(path.toString());
    }

    private void param() throws ParseException {
        String name = this.text;
        this.next();
        if (this.token == Scanner.Token.EQUALS) {
            this.next();
            StringBuilder val = new StringBuilder();
            if (this.token == Scanner.Token.PIPE) {
                val.append((Object)this.token);
                this.next();
            }
            this.expect(Scanner.Token.TEXT);
            val.append(this.text);
            this.next();
            while (this.is(Scanner.Token.COMMA, Scanner.Token.SLASH)) {
                val.append((Object)this.token);
                this.next();
                this.expect(Scanner.Token.TEXT);
                val.append(this.text);
                this.next();
            }
            this.cmd.addParameter(new Parameter(name, val.toString()));
        } else {
            this.cmd.addParameter(new Parameter(name));
        }
    }

    private void where() throws ParseException {
        this.next();
        this.expr();
    }

    private void expr() throws ParseException {
        this.expect(Scanner.Token.NOT, Scanner.Token.TEXT);
        block0 : switch (this.token) {
            case NOT: {
                this.notExpr();
                break;
            }
            case TEXT: {
                String name = this.text;
                this.next();
                this.expect(Scanner.Token.EQUALS, Scanner.Token.LESS, Scanner.Token.MORE, Scanner.Token.NOT_EQUALS);
                switch (this.token) {
                    case EQUALS: {
                        this.eqExpr(name);
                        break block0;
                    }
                    case NOT_EQUALS: {
                        this.notExpr(name);
                        break block0;
                    }
                    case LESS: {
                        this.lessExpr(name);
                        break block0;
                    }
                    case MORE: {
                        this.moreExpr(name);
                        break block0;
                    }
                }
                this.hasExpr(name);
            }
        }
        switch (this.token) {
            case AND: {
                this.andExpr();
                break;
            }
            case OR: {
                this.orExpr();
            }
        }
    }

    private void andExpr() throws ParseException {
        this.next();
        this.expr();
        this.cmd.addQuery("?#&");
    }

    private void orExpr() throws ParseException {
        this.next();
        this.expr();
        this.cmd.addQuery("?#|");
    }

    private void notExpr() throws ParseException {
        this.next();
        this.expr();
        this.cmd.addQuery("?#!");
    }

    private void eqExpr(String name) throws ParseException {
        this.next();
        this.expect(Scanner.Token.TEXT);
        this.cmd.addQuery(String.format("?%s=%s", name, this.text));
        this.next();
    }

    private void lessExpr(String name) throws ScanException {
        this.next();
        this.cmd.addQuery(String.format("?<%s=%s", name, this.text));
        this.next();
    }

    private void notExpr(String name) throws ScanException {
        this.next();
        this.cmd.addQuery(String.format("?%s=%s", name, this.text));
        this.cmd.addQuery("?#!");
        this.next();
    }

    private void moreExpr(String name) throws ScanException {
        this.next();
        this.cmd.addQuery(String.format("?>%s=%s", name, this.text));
        this.next();
    }

    private void hasExpr(String name) {
        this.cmd.addQuery(String.format("?%s", name));
    }

    private void returns() throws ParseException {
        this.next();
        this.expect(Scanner.Token.TEXT);
        LinkedList<String> props = new LinkedList<String>();
        while (this.token != Scanner.Token.EOL) {
            if (this.token != Scanner.Token.COMMA) {
                props.add(this.text);
            }
            this.next();
        }
        this.cmd.addProperty(props.toArray(new String[props.size()]));
    }

    private void expect(Scanner.Token ... tokens) throws ParseException {
        if (!this.is(tokens)) {
            throw new ParseException(String.format("Expected %s but found %s at position %d", new Object[]{Arrays.asList(tokens), this.token, this.scanner.pos()}));
        }
    }

    private boolean is(Scanner.Token ... tokens) {
        for (Scanner.Token want : tokens) {
            if (this.token != want) continue;
            return true;
        }
        return false;
    }

    private void next() throws ScanException {
        this.token = this.scanner.next();
        while (this.token == Scanner.Token.WS) {
            this.token = this.scanner.next();
        }
        this.text = this.scanner.text();
    }

    private Parser(String line) throws ScanException {
        line = line.trim();
        this.scanner = new Scanner(line);
        this.next();
    }
}

