/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.eviction.EvictionPolicyComparator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.StringUtil;

public final class ConfigValidator {
    private static final ILogger LOGGER = Logger.getLogger(ConfigValidator.class);

    private ConfigValidator() {
    }

    public static void checkMapConfig(MapConfig mapConfig) {
        ConfigValidator.checkNotNative(mapConfig.getInMemoryFormat());
        ConfigValidator.logIgnoredConfig(mapConfig);
    }

    public static void checkNearCacheConfig(String mapName, NearCacheConfig nearCacheConfig, boolean isClient) {
        ConfigValidator.checkLocalUpdatePolicy(mapName, nearCacheConfig);
        ConfigValidator.checkNotNative(nearCacheConfig.getInMemoryFormat());
        ConfigValidator.checkEvictionConfig(nearCacheConfig.getEvictionConfig(), true);
        if (isClient && nearCacheConfig.isCacheLocalEntries()) {
            LOGGER.warning("The Near Cache option `cache-local-entries` is not supported in client configurations. Remove this option from your client configuration, future versions may fail startup with an exception.");
        }
        ConfigValidator.checkPreloaderConfig(nearCacheConfig, isClient);
    }

    public static void checkLocalUpdatePolicy(String mapName, NearCacheConfig nearCacheConfig) {
        NearCacheConfig.LocalUpdatePolicy localUpdatePolicy = nearCacheConfig.getLocalUpdatePolicy();
        if (localUpdatePolicy != NearCacheConfig.LocalUpdatePolicy.INVALIDATE) {
            throw new IllegalArgumentException(String.format("Wrong `local-update-policy` option is selected for `%s` map near cache. Only `%s` option is supported but found `%s`", new Object[]{mapName, NearCacheConfig.LocalUpdatePolicy.INVALIDATE, localUpdatePolicy}));
        }
    }

    public static void checkEvictionConfig(EvictionConfig evictionConfig, boolean isNearCache) {
        if (evictionConfig == null) {
            throw new IllegalArgumentException("Eviction config cannot be null!");
        }
        EvictionPolicy evictionPolicy = evictionConfig.getEvictionPolicy();
        String comparatorClassName = evictionConfig.getComparatorClassName();
        EvictionPolicyComparator comparator = evictionConfig.getComparator();
        ConfigValidator.checkEvictionConfig(evictionPolicy, comparatorClassName, comparator, isNearCache);
    }

    public static void checkEvictionConfig(EvictionPolicy evictionPolicy, String comparatorClassName, Object comparator, boolean isNearCache) {
        if (comparatorClassName != null && comparator != null) {
            throw new IllegalArgumentException("Only one of the `comparator class name` and `comparator` can be configured in the eviction configuration!");
        }
        if (!(isNearCache || evictionPolicy != null && evictionPolicy != EvictionPolicy.NONE && evictionPolicy != EvictionPolicy.RANDOM)) {
            if (StringUtil.isNullOrEmpty(comparatorClassName) && comparator == null) {
                throw new IllegalArgumentException("Eviction policy must be set to an eviction policy type rather than `null`, `NONE`, `RANDOM` or custom eviction policy comparator must be specified!");
            }
        } else if (evictionPolicy != EvictionConfig.DEFAULT_EVICTION_POLICY) {
            if (!StringUtil.isNullOrEmpty(comparatorClassName)) {
                throw new IllegalArgumentException("Only one of the `eviction policy` and `comparator class name` can be configured!");
            }
            if (comparator != null) {
                throw new IllegalArgumentException("Only one of the `eviction policy` and `comparator` can be configured!");
            }
        }
    }

    private static void checkNotNative(InMemoryFormat inMemoryFormat) {
        if (inMemoryFormat == InMemoryFormat.NATIVE && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalArgumentException("NATIVE storage format is supported in Hazelcast Enterprise only. Make sure you have Hazelcast Enterprise JARs on your classpath!");
        }
    }

    private static void checkPreloaderConfig(NearCacheConfig nearCacheConfig, boolean isClient) {
        if (!isClient && nearCacheConfig.getPreloaderConfig().isEnabled()) {
            throw new IllegalArgumentException("The Near Cache pre-loader is just available on Hazelcast clients!");
        }
    }

    private static void logIgnoredConfig(MapConfig mapConfig) {
        if (mapConfig.getMinEvictionCheckMillis() != 100L || mapConfig.getEvictionPercentage() != 25) {
            LOGGER.warning("As of version 3.7 `minEvictionCheckMillis` and `evictionPercentage` are deprecated due to a change of the eviction mechanism. The new eviction mechanism uses a probabilistic algorithm based on sampling. Please see documentation for further details.");
        }
    }
}

