/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.store;

import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.impl.record.NearCacheObjectRecord;
import com.hazelcast.internal.nearcache.impl.store.BaseHeapNearCacheRecordStore;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;

public class NearCacheObjectRecordStore<K, V>
extends BaseHeapNearCacheRecordStore<K, V, NearCacheObjectRecord> {
    public NearCacheObjectRecordStore(String name, NearCacheConfig nearCacheConfig, SerializationService serializationService, ClassLoader classLoader) {
        super(name, nearCacheConfig, serializationService, classLoader);
    }

    @Override
    protected long getKeyStorageMemoryCost(K key) {
        return 0L;
    }

    @Override
    protected long getRecordStorageMemoryCost(NearCacheObjectRecord record) {
        return 0L;
    }

    @Override
    protected NearCacheObjectRecord valueToRecord(V value) {
        value = this.toValue(value);
        long creationTime = Clock.currentTimeMillis();
        if (this.timeToLiveMillis > 0L) {
            return new NearCacheObjectRecord<V>(value, creationTime, creationTime + this.timeToLiveMillis);
        }
        return new NearCacheObjectRecord<V>(value, creationTime, -1L);
    }

    @Override
    protected void updateRecordValue(NearCacheObjectRecord record, V value) {
        record.setValue(this.toValue(value));
    }

    @Override
    protected V recordToValue(NearCacheObjectRecord record) {
        if (record.getValue() == null) {
            this.nearCacheStats.incrementMisses();
            return (V)NearCache.CACHED_AS_NULL;
        }
        return record.getValue();
    }

    @Override
    public Object selectToSave(Object ... candidates) {
        Object selectedCandidate = null;
        if (candidates != null && candidates.length > 0) {
            for (Object candidate : candidates) {
                if (candidate instanceof Data) continue;
                selectedCandidate = candidate;
                break;
            }
            if (selectedCandidate != null) {
                return selectedCandidate;
            }
            for (Object candidate : candidates) {
                if (candidate == null) continue;
                selectedCandidate = candidate;
                break;
            }
        }
        return selectedCandidate;
    }
}

