/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.client.RespControlVector;
import com.novell.ldap.rfc2251.RfcControl;
import com.novell.ldap.rfc2251.RfcLDAPOID;
import com.novell.ldap.util.Base64;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPControl
implements Cloneable,
Externalizable {
    private static RespControlVector registeredControls = new RespControlVector(5, 5);
    private RfcControl control;

    public LDAPControl() {
    }

    public LDAPControl(String oid, boolean critical, byte[] values) {
        if (oid == null) {
            throw new IllegalArgumentException("An OID must be specified");
        }
        this.control = values == null ? new RfcControl(new RfcLDAPOID(oid), new ASN1Boolean(critical)) : new RfcControl(new RfcLDAPOID(oid), new ASN1Boolean(critical), new ASN1OctetString(values));
    }

    protected LDAPControl(RfcControl control) {
        this.control = control;
    }

    public Object clone() {
        LDAPControl cont;
        try {
            cont = (LDAPControl)super.clone();
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
        byte[] vals = this.getValue();
        byte[] twin = null;
        if (vals != null) {
            twin = new byte[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                twin[i] = vals[i];
            }
            cont.control = new RfcControl(new RfcLDAPOID(this.getID()), new ASN1Boolean(this.isCritical()), new ASN1OctetString(twin));
        }
        return cont;
    }

    public String getID() {
        return new String(this.control.getControlType().stringValue());
    }

    public byte[] getValue() {
        byte[] result = null;
        ASN1OctetString val = this.control.getControlValue();
        if (val != null) {
            result = val.byteValue();
        }
        return result;
    }

    protected void setValue(byte[] controlValue) {
        this.control.setControlValue(new ASN1OctetString(controlValue));
    }

    public boolean isCritical() {
        return this.control.getCriticality().booleanValue();
    }

    public static void register(String oid, Class controlClass) {
        registeredControls.registerResponseControl(oid, controlClass);
    }

    static RespControlVector getRegisteredControls() {
        return registeredControls;
    }

    final RfcControl getASN1Object() {
        return this.control;
    }

    void newLine(int indentTabs, Writer out) throws IOException {
        String tabString = "    ";
        out.write("\n");
        for (int i = 0; i < indentTabs; ++i) {
            out.write(tabString);
        }
    }

    public void writeDSML(OutputStream oout) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(oout, "UTF-8");
        int indent = 0;
        out.write("<control type=\"");
        out.write(this.getID());
        out.write("\" criticality=\"" + this.isCritical() + "\"");
        byte[] value = this.getValue();
        if (value == null) {
            out.write("/>");
        } else {
            out.write(">");
            this.newLine(indent + 1, out);
            out.write("<controlValue xsi:type=\"xsd:base64Binary\">");
            out.write(Base64.encode(value));
            out.write("</controlValue>");
            this.newLine(indent, out);
            out.write("</control>");
        }
        ((Writer)out).close();
    }

    public static Object readDSML(InputStream input) throws IOException {
        SAXEventMultiplexer xmlreader = new SAXEventMultiplexer();
        xmlreader.setLDAPXMLHandler(LDAPControl.getXMLHandler("control", null));
        return (LDAPControl)xmlreader.parseXML(input);
    }

    static LDAPXMLHandler getXMLHandler(String tagname, LDAPXMLHandler parenthandler) {
        return new LDAPXMLHandler(tagname, parenthandler){
            String oid;
            boolean critical;
            byte[] controlvalue;

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler("controlValue", this));
            }

            protected void endElement() {
                LDAPControl control = new LDAPControl(this.oid, this.critical, this.controlvalue);
                this.setObject(control);
            }

            protected void addValue(String tag, Object value) {
                if (tag.equals("controlValue")) {
                    this.controlvalue = (byte[])value;
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.oid = attributes.getValue("type");
                if (this.oid == null) {
                    throw new SAXException("type is mandatory for a Control");
                }
                this.critical = "true".equalsIgnoreCase(attributes.getValue("criticality"));
            }
        };
    }

    public String toString() {
        StringBuffer result = new StringBuffer("LDAPControl: ");
        result.append("((oid=" + this.getID() + "");
        result.append(",critical=" + this.isCritical() + ")");
        result.append("(value=" + this.getValue() + "))");
        return result.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        StringBuffer buff = new StringBuffer();
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String header = "";
        header = header + "*************************************************************************\n";
        header = header + "** The encrypted data above and below is the Class definition and  ******\n";
        header = header + "** other data specific to Java Serialization Protocol. The data  ********\n";
        header = header + "** which is of most application specific interest is as follows... ******\n";
        header = header + "*************************************************************************\n";
        header = header + "****************** Start of application data ****************************\n";
        header = header + "*************************************************************************\n";
        buff.append(header);
        buff.append(ValueXMLhandler.newLine(0));
        buff.append("<control type=\"");
        buff.append(this.getID());
        buff.append("\" criticality=\"" + this.isCritical() + "\"");
        byte[] value = this.getValue();
        if (value == null) {
            buff.append("/>");
        } else {
            buff.append(">");
            buff.append(ValueXMLhandler.newLine(1));
            buff.append("<controlValue xsi:type=\"xsd:base64Binary\">");
            buff.append(Base64.encode(value));
            buff.append("</controlValue>");
            buff.append(ValueXMLhandler.newLine(0));
            buff.append("</control>");
        }
        buff.append(ValueXMLhandler.newLine(0));
        buff.append(ValueXMLhandler.newLine(0));
        String tail = "";
        tail = tail + "*************************************************************************\n";
        tail = tail + "****************** End of application data ******************************\n";
        tail = tail + "*************************************************************************\n";
        buff.append(tail);
        buff.append(ValueXMLhandler.newLine(0));
        out.writeUTF(buff.toString());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String readData = in.readUTF();
        String readProperties = readData.substring(readData.indexOf(60), readData.lastIndexOf(62) + 1);
        StringBuffer parsedBuff = new StringBuffer();
        ValueXMLhandler.parseInput(readProperties, parsedBuff);
        BufferedInputStream istream = new BufferedInputStream(new ByteArrayInputStream(parsedBuff.toString().getBytes()));
        LDAPControl readObject = (LDAPControl)LDAPControl.readDSML(istream);
        byte[] vals = readObject.getValue();
        this.control = vals == null ? new RfcControl(new RfcLDAPOID(readObject.getID()), new ASN1Boolean(readObject.isCritical())) : new RfcControl(new RfcLDAPOID(readObject.getID()), new ASN1Boolean(readObject.isCritical()), new ASN1OctetString(vals));
        readObject = null;
    }
}

