/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.util.DN;
import com.novell.ldap.util.RDN;

public class LDAPDN {
    public static boolean equals(String dn1, String dn2) {
        DN dnA = new DN(dn1);
        DN dnB = new DN(dn2);
        return dnA.equals(dnB);
    }

    public static String escapeRDN(String rdn) {
        int i;
        StringBuffer escapedS = new StringBuffer(rdn);
        for (i = 0; i < escapedS.length() && escapedS.charAt(i) != '='; ++i) {
        }
        if (i == escapedS.length()) {
            throw new IllegalArgumentException("Could not parse RDN: Attribute type and name must be separated by an equal symbol, '='");
        }
        if (escapedS.charAt(++i) == ' ' || escapedS.charAt(i) == '#') {
            escapedS.insert(i++, '\\');
        }
        while (i < escapedS.length()) {
            if (escapedS.charAt(i) == ',' || escapedS.charAt(i) == '+' || escapedS.charAt(i) == '\"' || escapedS.charAt(i) == '\\' || escapedS.charAt(i) == '<' || escapedS.charAt(i) == '>' || escapedS.charAt(i) == ';') {
                escapedS.insert(i++, '\\');
            }
            ++i;
        }
        if (escapedS.charAt(escapedS.length() - 1) == ' ') {
            escapedS.insert(escapedS.length() - 1, '\\');
        }
        return escapedS.toString();
    }

    public static String[] explodeDN(String dn, boolean noTypes) {
        DN dnToExplode = new DN(dn);
        return dnToExplode.explodeDN(noTypes);
    }

    public static String[] explodeRDN(String rdn, boolean noTypes) {
        RDN rdnToExplode = new RDN(rdn);
        return rdnToExplode.explodeRDN(noTypes);
    }

    public static boolean isValid(String dn) {
        try {
            new DN(dn);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    public static String normalize(String dn) {
        DN testDN = new DN(dn);
        return testDN.toString();
    }

    public static String unescapeRDN(String rdn) {
        int i;
        StringBuffer unescaped = new StringBuffer();
        for (i = 0; i < rdn.length() && rdn.charAt(i) != '='; ++i) {
            unescaped.append(rdn.charAt(i));
        }
        unescaped.append(rdn.charAt(i));
        if (i == rdn.length()) {
            throw new IllegalArgumentException("Could not parse rdn: Attribute type and name must be separated by an equal symbol, '='");
        }
        if (rdn.charAt(++i) == '\\' && i + 1 < rdn.length() - 1 && (rdn.charAt(i + 1) == ' ' || rdn.charAt(i + 1) == '#')) {
            ++i;
        }
        while (i < rdn.length()) {
            block9: {
                block7: {
                    block8: {
                        if (rdn.charAt(i) != '\\' || i == rdn.length() - 1) break block7;
                        if (rdn.charAt(i + 1) != ',' && rdn.charAt(i + 1) != '+' && rdn.charAt(i + 1) != '\"' && rdn.charAt(i + 1) != '\\' && rdn.charAt(i + 1) != '<' && rdn.charAt(i + 1) != '>' && rdn.charAt(i + 1) != ';') break block8;
                        unescaped.append(rdn.charAt(i + 1));
                        ++i;
                        break block9;
                    }
                    if (rdn.charAt(i + 1) == ' ' && i + 2 == rdn.length()) break block9;
                }
                unescaped.append(rdn.charAt(i));
            }
            ++i;
        }
        return unescaped.toString();
    }
}

