/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Encoder;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Object;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ASN1OctetString
extends ASN1Object {
    private byte[] content;
    public static final int TAG = 4;
    protected static final ASN1Identifier ID = new ASN1Identifier(0, false, 4);

    public ASN1OctetString(byte[] content) {
        super(ID);
        this.content = content;
    }

    public ASN1OctetString(String content) {
        super(ID);
        try {
            this.content = content.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee.toString());
        }
    }

    public ASN1OctetString(ASN1Decoder dec, InputStream in, int len) throws IOException {
        super(ID);
        this.content = len > 0 ? (byte[])dec.decodeOctetString(in, len) : new byte[]{};
    }

    public final void encode(ASN1Encoder enc, OutputStream out) throws IOException {
        enc.encode(this, out);
    }

    public final byte[] byteValue() {
        return this.content;
    }

    public final String stringValue() {
        String s = null;
        try {
            s = new String(this.content, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee.toString());
        }
        return s;
    }

    public String toString() {
        return super.toString() + "OCTET STRING: " + this.stringValue();
    }
}

