/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Tagged;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.eventdata.DSETimeStamp;
import com.novell.ldap.events.edir.eventdata.ReferralAddress;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class DebugParameter {
    private int type;
    private Object data;

    public DebugParameter(ASN1Tagged dseobject) throws IOException {
        switch (dseobject.getIdentifier().getTag()) {
            case 1: {
                int integervalue = this.getTaggedintValue(dseobject);
                this.data = new Integer(integervalue);
                break;
            }
            case 4: {
                int integervalue = this.getTaggedintValue(dseobject);
                this.data = new Integer(integervalue);
                break;
            }
            case 3: {
                byte[] binarydata = ((ASN1OctetString)dseobject.taggedValue()).byteValue();
                this.data = binarydata;
                break;
            }
            case 2: {
                String utf8String = ((ASN1OctetString)dseobject.taggedValue()).stringValue();
                this.data = utf8String;
                break;
            }
            case 6: {
                DSETimeStamp timeStamp = new DSETimeStamp(this.getTaggedSequence(dseobject));
                this.data = timeStamp;
                break;
            }
            case 7: {
                ArrayList<DSETimeStamp> timeVector = Collections.EMPTY_LIST;
                ASN1Sequence seq = this.getTaggedSequence(dseobject);
                int count = ((ASN1Integer)seq.get(0)).intValue();
                if (count > 0) {
                    ASN1Sequence timeseq = (ASN1Sequence)seq.get(1);
                    timeVector = new ArrayList<DSETimeStamp>();
                    for (int i = 0; i < count; ++i) {
                        timeVector.add(new DSETimeStamp((ASN1Sequence)timeseq.get(i)));
                    }
                }
                this.data = timeVector;
                break;
            }
            case 5: {
                ReferralAddress address = new ReferralAddress(this.getTaggedSequence(dseobject));
                this.data = address;
                break;
            }
            default: {
                throw new IOException("Unknown Tag in DebugParameter..");
            }
        }
        this.type = dseobject.getIdentifier().getTag();
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[DebugParameter");
        switch (this.getType()) {
            case 1: {
                buf.append("type=EVENT_TAG_DEBUG_INFO_ENTRYID");
                buf.append(" value=" + this.getData());
                break;
            }
            case 4: {
                buf.append("type=EVENT_TAG_DEBUG_INFO_INTEGER");
                buf.append("value=" + this.getData());
                break;
            }
            case 3: {
                buf.append("type=DB_PARAM_TYPE_BINARY");
                buf.append("value=" + this.getData());
                break;
            }
            case 2: {
                buf.append("type=DB_PARAM_TYPE_STRING");
                buf.append("value=" + this.getData());
                break;
            }
            case 6: {
                buf.append("type=DB_PARAM_TYPE_TIMESTAMP");
                buf.append("value=" + this.getData());
                break;
            }
            case 7: {
                buf.append("type=DB_PARAM_TYPE_TIMEVECTOR");
                buf.append("value=" + this.getData());
                break;
            }
            case 5: {
                buf.append("type=DB_PARAM_TYPE_ADDRESS");
                buf.append("value=" + this.getData());
                break;
            }
            default: {
                buf.append("type=Unknown");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    private int getTaggedintValue(ASN1Tagged tagvalue) throws IOException {
        ASN1Object obj = tagvalue.taggedValue();
        byte[] databytes = ((ASN1OctetString)obj).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(databytes);
        LBERDecoder decode = new LBERDecoder();
        int length = databytes.length;
        return ((Long)decode.decodeNumeric(in, length)).intValue();
    }

    private ASN1Sequence getTaggedSequence(ASN1Tagged tagvalue) throws IOException {
        ASN1Object obj = tagvalue.taggedValue();
        byte[] databytes = ((ASN1OctetString)obj).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(databytes);
        LBERDecoder decode = new LBERDecoder();
        return new ASN1Sequence(decode, in, databytes.length);
    }

    public Object getData() {
        return this.data;
    }
}

