/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBEREncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class GetEffectivePrivilegesRequest
extends LDAPExtendedOperation {
    public GetEffectivePrivilegesRequest(String dn, String trusteeDN, String attrName) throws LDAPException {
        super("2.16.840.1.113719.1.27.100.33", null);
        try {
            if (dn == null) {
                throw new IllegalArgumentException("PARAM_ERROR");
            }
            ByteArrayOutputStream encodedData = new ByteArrayOutputStream();
            LBEREncoder encoder = new LBEREncoder();
            ASN1OctetString asn1_dn = new ASN1OctetString(dn);
            ASN1OctetString asn1_trusteeDN = new ASN1OctetString(trusteeDN);
            ASN1OctetString asn1_attrName = new ASN1OctetString(attrName);
            asn1_dn.encode(encoder, encodedData);
            asn1_trusteeDN.encode(encoder, encodedData);
            asn1_attrName.encode(encoder, encodedData);
            this.setValue(encodedData.toByteArray());
        }
        catch (IOException ioe) {
            throw new LDAPException("ENCODING_ERROR", 83, null);
        }
    }

    static {
        try {
            LDAPExtendedResponse.register("2.16.840.1.113719.1.27.100.34", Class.forName("com.novell.ldap.extensions.GetEffectivePrivilegesResponse"));
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not register Extended Response - Class not found");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

