/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.extensions;

import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBEREncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class GetReplicaInfoRequest
extends LDAPExtendedOperation {
    public GetReplicaInfoRequest(String serverDN, String partitionDN) throws LDAPException {
        super("2.16.840.1.113719.1.27.100.17", null);
        try {
            if (serverDN == null || partitionDN == null) {
                throw new IllegalArgumentException("PARAM_ERROR");
            }
            ByteArrayOutputStream encodedData = new ByteArrayOutputStream();
            LBEREncoder encoder = new LBEREncoder();
            ASN1OctetString asn1_serverDN = new ASN1OctetString(serverDN);
            ASN1OctetString asn1_partitionDN = new ASN1OctetString(partitionDN);
            asn1_serverDN.encode(encoder, encodedData);
            asn1_partitionDN.encode(encoder, encodedData);
            this.setValue(encodedData.toByteArray());
        }
        catch (IOException ioe) {
            throw new LDAPException("ENCODING_ERROR", 83, null);
        }
    }

    static {
        try {
            LDAPExtendedResponse.register("2.16.840.1.113719.1.27.100.18", Class.forName("com.novell.ldap.extensions.GetReplicaInfoResponse"));
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not register Extended Response - Class not found");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

