/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.ldap;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import org.ietf.ldap.LDAPAttribute;
import org.ietf.ldap.LDAPConstraints;
import org.ietf.ldap.LDAPControl;
import org.ietf.ldap.LDAPEntry;
import org.ietf.ldap.LDAPException;
import org.ietf.ldap.LDAPExtendedOperation;
import org.ietf.ldap.LDAPExtendedResponse;
import org.ietf.ldap.LDAPMessageQueue;
import org.ietf.ldap.LDAPModification;
import org.ietf.ldap.LDAPReferralException;
import org.ietf.ldap.LDAPResponseQueue;
import org.ietf.ldap.LDAPSchema;
import org.ietf.ldap.LDAPSearchConstraints;
import org.ietf.ldap.LDAPSearchQueue;
import org.ietf.ldap.LDAPSearchResults;
import org.ietf.ldap.LDAPSocketFactory;
import org.ietf.ldap.LDAPUnsolicitedNotificationListener;
import org.ietf.ldap.LDAPUrl;

public class LDAPConnection
implements Cloneable {
    private com.novell.ldap.LDAPConnection conn;
    private Hashtable listenerQueues = new Hashtable();
    public static final int SCOPE_BASE = 0;
    public static final int SCOPE_ONE = 1;
    public static final int SCOPE_SUB = 2;
    public static final int SCOPE_SUBORDINATESUBTREE = 4;
    public static final String NO_ATTRS = "1.1";
    public static final String ALL_USER_ATTRS = "*";
    public static final int DEFAULT_PORT = 389;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";

    public LDAPConnection() {
        this.conn = new com.novell.ldap.LDAPConnection();
    }

    LDAPConnection(com.novell.ldap.LDAPConnection conn) {
        this.conn = conn;
    }

    com.novell.ldap.LDAPConnection getWrappedObject() {
        return this.conn;
    }

    private static com.novell.ldap.LDAPSocketFactory getSocketImpl(LDAPSocketFactory f) {
        if (f == null) {
            return null;
        }
        class SocketFactoryImpl
        implements SocketFactoryWrapper {
            private LDAPSocketFactory factory;

            SocketFactoryImpl(LDAPSocketFactory factory) {
                this.factory = factory;
            }

            public LDAPSocketFactory getWrappedObject() {
                return this.factory;
            }

            public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                return this.factory.createSocket(host, port);
            }
        }
        return new SocketFactoryImpl(f);
    }

    public LDAPConnection(LDAPSocketFactory factory) {
        this.conn = factory != null && factory instanceof com.novell.ldap.LDAPSocketFactory ? new com.novell.ldap.LDAPConnection((com.novell.ldap.LDAPSocketFactory)((Object)factory)) : new com.novell.ldap.LDAPConnection(LDAPConnection.getSocketImpl(factory));
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Object newObj = super.clone();
            ((LDAPConnection)newObj).conn = (com.novell.ldap.LDAPConnection)this.conn.clone();
            return newObj;
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    protected void finalize() throws LDAPException {
        try {
            this.conn.disconnect();
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public int getProtocolVersion() {
        return this.conn.getProtocolVersion();
    }

    public String getAuthenticationDN() {
        return this.conn.getAuthenticationDN();
    }

    public String getAuthenticationMethod() {
        return this.conn.getAuthenticationMethod();
    }

    public Map getSaslBindProperties() {
        return this.conn.getSaslBindProperties();
    }

    public Object getSaslBindCallbackHandler() {
        return this.conn.getSaslBindCallbackHandler();
    }

    public LDAPConstraints getConstraints() {
        return new LDAPSearchConstraints(this.conn.getSearchConstraints());
    }

    public String getHost() {
        return this.conn.getHost();
    }

    public int getPort() {
        return this.conn.getPort();
    }

    public Object getProperty(String name) {
        return this.conn.getProperty(name);
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return new LDAPSearchConstraints(this.conn.getSearchConstraints());
    }

    public LDAPSocketFactory getSocketFactory() {
        com.novell.ldap.LDAPSocketFactory factory = this.conn.getSocketFactory();
        if (factory == null) {
            return null;
        }
        if (factory instanceof LDAPSocketFactory) {
            return (LDAPSocketFactory)((Object)factory);
        }
        return ((SocketFactoryWrapper)factory).getWrappedObject();
    }

    public boolean isBound() {
        return this.conn.isBound();
    }

    public boolean isConnected() {
        return this.conn.isConnected();
    }

    public boolean isTLS() {
        return this.conn.isTLS();
    }

    public void setConstraints(LDAPConstraints cons) {
        this.conn.setConstraints(cons.getWrappedObject());
    }

    public static void setSocketFactory(LDAPSocketFactory factory) {
        if (factory != null && factory instanceof com.novell.ldap.LDAPSocketFactory) {
            com.novell.ldap.LDAPConnection.setSocketFactory((com.novell.ldap.LDAPSocketFactory)((Object)factory));
        } else {
            com.novell.ldap.LDAPConnection.setSocketFactory(LDAPConnection.getSocketImpl(factory));
        }
    }

    public void addUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener listen) {
        if (listen != null) {
            this.conn.addUnsolicitedNotificationListener(new UnsolImpl(listen));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnsolicitedNotificationListener(LDAPUnsolicitedNotificationListener queue) {
        com.novell.ldap.LDAPUnsolicitedNotificationListener ul = null;
        if (queue != null) {
            Hashtable hashtable = this.listenerQueues;
            synchronized (hashtable) {
                ul = (com.novell.ldap.LDAPUnsolicitedNotificationListener)this.listenerQueues.remove(queue);
            }
            if (ul != null) {
                this.conn.removeUnsolicitedNotificationListener(ul);
            }
        }
        if (ul == null) {
            throw new IllegalArgumentException("removeUnsolicitedNotificationListener: Invalid Parameter");
        }
    }

    public void startTLS() throws LDAPException {
        try {
            this.conn.startTLS();
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public void stopTLS() throws LDAPException {
        try {
            this.conn.stopTLS();
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public void abandon(LDAPSearchResults results) throws LDAPException {
        try {
            if (results == null) {
                this.conn.abandon((com.novell.ldap.LDAPSearchResults)null);
            } else {
                this.conn.abandon(results.getWrappedObject());
            }
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public void abandon(LDAPSearchResults results, LDAPConstraints cons) throws LDAPException {
        try {
            if (results == null) {
                this.conn.abandon((com.novell.ldap.LDAPSearchResults)null, cons.getWrappedObject());
            } else {
                this.conn.abandon(results.getWrappedObject(), cons.getWrappedObject());
            }
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public void abandon(int id) throws LDAPException {
        try {
            this.conn.abandon(id);
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public void abandon(int id, LDAPConstraints cons) throws LDAPException {
        try {
            this.conn.abandon(id, cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public void abandon(LDAPMessageQueue queue) throws LDAPException {
        try {
            if (queue instanceof LDAPResponseQueue) {
                this.conn.abandon(((LDAPResponseQueue)queue).getWrappedObject());
            } else if (queue instanceof LDAPSearchQueue) {
                this.conn.abandon(((LDAPSearchQueue)queue).getWrappedObject());
            }
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public void abandon(LDAPMessageQueue queue, LDAPConstraints cons) throws LDAPException {
        try {
            if (queue instanceof LDAPResponseQueue) {
                this.conn.abandon(((LDAPResponseQueue)queue).getWrappedObject(), cons.getWrappedObject());
            } else if (queue instanceof LDAPSearchQueue) {
                this.conn.abandon(((LDAPSearchQueue)queue).getWrappedObject(), cons.getWrappedObject());
            }
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public void add(LDAPEntry entry) throws LDAPException {
        try {
            this.conn.add(entry.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void add(LDAPEntry entry, LDAPConstraints cons) throws LDAPException {
        try {
            this.conn.add(entry.getWrappedObject(), cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue add(LDAPEntry entry, LDAPResponseQueue queue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.add(entry.getWrappedObject(), queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue add(LDAPEntry entry, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.add(entry.getWrappedObject(), queue.getWrappedObject(), cons.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void bind(int version, String dn, byte[] passwd) throws LDAPException {
        try {
            this.conn.bind(version, dn, passwd);
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void bind(int version, String dn, byte[] passwd, LDAPConstraints cons) throws LDAPException {
        try {
            this.conn.bind(version, dn, passwd, cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue bind(int version, String dn, byte[] passwd, LDAPResponseQueue queue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.bind(version, dn, passwd, queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue bind(int version, String dn, byte[] passwd, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.bind(version, dn, passwd, queue.getWrappedObject(), cons.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void bind(String dn, String authzid, Map props, Object cbh) throws LDAPException {
        try {
            this.conn.bind(dn, authzid, props, cbh);
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void bind(String dn, String authzid, Map props, Object cbh, LDAPConstraints cons) throws LDAPException {
        try {
            this.conn.bind(dn, authzid, props, cbh, cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void bind(String dn, String authzid, String[] mechanisms, Map props, Object cbh) throws LDAPException {
        try {
            this.conn.bind(dn, authzid, mechanisms, props, cbh);
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void bind(String dn, String authzid, String[] mechanisms, Map props, Object cbh, LDAPConstraints cons) throws LDAPException {
        try {
            this.conn.bind(dn, authzid, mechanisms, props, cbh, cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public boolean compare(String dn, LDAPAttribute attr) throws LDAPException {
        try {
            return this.conn.compare(dn, attr.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public boolean compare(String dn, LDAPAttribute attr, LDAPConstraints cons) throws LDAPException {
        try {
            return this.conn.compare(dn, attr.getWrappedObject(), cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue compare(String dn, LDAPAttribute attr, LDAPResponseQueue queue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.compare(dn, attr.getWrappedObject(), queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue compare(String dn, LDAPAttribute attr, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.compare(dn, attr.getWrappedObject(), queue.getWrappedObject(), cons.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void connect(String host, int port) throws LDAPException {
        try {
            this.conn.connect(host, port);
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public void delete(String dn) throws LDAPException {
        try {
            this.conn.delete(dn);
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void delete(String dn, LDAPConstraints cons) throws LDAPException {
        try {
            this.conn.delete(dn, cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue delete(String dn, LDAPResponseQueue queue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.delete(dn, queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue delete(String dn, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.delete(dn, queue.getWrappedObject(), cons.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void disconnect() throws LDAPException {
        try {
            this.conn.disconnect();
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public void disconnect(LDAPConstraints cons) throws LDAPException {
        try {
            this.conn.disconnect(cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            throw new LDAPException(ex);
        }
    }

    public LDAPExtendedResponse extendedOperation(LDAPExtendedOperation op) throws LDAPException {
        try {
            return new LDAPExtendedResponse(this.conn.extendedOperation(op.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPExtendedResponse extendedOperation(LDAPExtendedOperation op, LDAPSearchConstraints cons) throws LDAPException {
        try {
            return new LDAPExtendedResponse(this.conn.extendedOperation(op.getWrappedObject(), cons.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue extendedOperation(LDAPExtendedOperation op, LDAPResponseQueue queue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.extendedOperation(op.getWrappedObject(), queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue extendedOperation(LDAPExtendedOperation op, LDAPSearchConstraints cons, LDAPResponseQueue queue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.extendedOperation(op.getWrappedObject(), cons.getWrappedSearchObject(), queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPControl[] getResponseControls() {
        com.novell.ldap.LDAPControl[] controls = this.conn.getResponseControls();
        if (controls == null) {
            return null;
        }
        LDAPControl[] ietfControls = new LDAPControl[controls.length];
        for (int i = 0; i < controls.length; ++i) {
            ietfControls[i] = new LDAPControl(controls[i]);
        }
        return ietfControls;
    }

    public void modify(String dn, LDAPModification mod) throws LDAPException {
        try {
            this.conn.modify(dn, mod.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void modify(String dn, LDAPModification mod, LDAPConstraints cons) throws LDAPException {
        try {
            this.conn.modify(dn, mod.getWrappedObject(), cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void modify(String dn, LDAPModification[] mods) throws LDAPException {
        try {
            com.novell.ldap.LDAPModification[] lmods = new com.novell.ldap.LDAPModification[mods.length];
            for (int i = 0; i < mods.length; ++i) {
                lmods[i] = mods[i].getWrappedObject();
            }
            this.conn.modify(dn, lmods);
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void modify(String dn, LDAPModification[] mods, LDAPConstraints cons) throws LDAPException {
        try {
            com.novell.ldap.LDAPModification[] lmods = new com.novell.ldap.LDAPModification[mods.length];
            for (int i = 0; i < mods.length; ++i) {
                lmods[i] = mods[i].getWrappedObject();
            }
            this.conn.modify(dn, lmods, cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue modify(String dn, LDAPModification mod, LDAPResponseQueue queue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.modify(dn, mod.getWrappedObject(), queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue modify(String dn, LDAPModification mod, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.modify(dn, mod.getWrappedObject(), queue.getWrappedObject(), cons.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue modify(String dn, LDAPModification[] mods, LDAPResponseQueue queue) throws LDAPException {
        try {
            com.novell.ldap.LDAPModification[] lmods = new com.novell.ldap.LDAPModification[mods.length];
            for (int i = 0; i < mods.length; ++i) {
                lmods[i] = mods[i].getWrappedObject();
            }
            return new LDAPResponseQueue(this.conn.modify(dn, lmods, queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue modify(String dn, LDAPModification[] mods, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        try {
            com.novell.ldap.LDAPModification[] lmods = new com.novell.ldap.LDAPModification[mods.length];
            for (int i = 0; i < mods.length; ++i) {
                lmods[i] = mods[i].getWrappedObject();
            }
            return new LDAPResponseQueue(this.conn.modify(dn, lmods, queue.getWrappedObject(), cons.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPEntry read(String dn) throws LDAPException {
        try {
            return new LDAPEntry(this.conn.read(dn));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPEntry read(String dn, LDAPSearchConstraints cons) throws LDAPException {
        try {
            return new LDAPEntry(this.conn.read(dn, cons.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPEntry read(String dn, String[] attrs) throws LDAPException {
        try {
            return new LDAPEntry(this.conn.read(dn, attrs));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPEntry read(String dn, String[] attrs, LDAPSearchConstraints cons) throws LDAPException {
        try {
            return new LDAPEntry(this.conn.read(dn, attrs, cons.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public static LDAPEntry read(LDAPUrl toGet) throws LDAPException {
        try {
            return new LDAPEntry(com.novell.ldap.LDAPConnection.read(toGet.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public static LDAPEntry read(LDAPUrl toGet, LDAPSearchConstraints cons) throws LDAPException {
        try {
            return new LDAPEntry(com.novell.ldap.LDAPConnection.read(toGet.getWrappedObject(), cons.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void rename(String dn, String newRdn, boolean deleteOldRdn) throws LDAPException {
        try {
            this.conn.rename(dn, newRdn, deleteOldRdn);
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void rename(String dn, String newRdn, boolean deleteOldRdn, LDAPConstraints cons) throws LDAPException {
        try {
            this.conn.rename(dn, newRdn, deleteOldRdn, cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void rename(String dn, String newRdn, String newParentdn, boolean deleteOldRdn) throws LDAPException {
        try {
            this.conn.rename(dn, newRdn, newParentdn, deleteOldRdn);
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public void rename(String dn, String newRdn, String newParentdn, boolean deleteOldRdn, LDAPConstraints cons) throws LDAPException {
        try {
            this.conn.rename(dn, newRdn, newParentdn, deleteOldRdn, cons.getWrappedObject());
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue rename(String dn, String newRdn, boolean deleteOldRdn, LDAPResponseQueue queue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.rename(dn, newRdn, deleteOldRdn, queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue rename(String dn, String newRdn, boolean deleteOldRdn, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.rename(dn, newRdn, deleteOldRdn, queue.getWrappedObject(), cons.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue rename(String dn, String newRdn, String newParentdn, boolean deleteOldRdn, LDAPResponseQueue queue) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.rename(dn, newRdn, newParentdn, deleteOldRdn, queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPResponseQueue rename(String dn, String newRdn, String newParentdn, boolean deleteOldRdn, LDAPResponseQueue queue, LDAPConstraints cons) throws LDAPException {
        try {
            return new LDAPResponseQueue(this.conn.rename(dn, newRdn, newParentdn, deleteOldRdn, queue.getWrappedObject(), cons.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean typesOnly) throws LDAPException {
        try {
            return new LDAPSearchResults(this.conn.search(base, scope, filter, attrs, typesOnly));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchConstraints cons) throws LDAPException {
        try {
            return new LDAPSearchResults(this.conn.search(base, scope, filter, attrs, typesOnly, cons.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPSearchQueue search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchQueue queue) throws LDAPException {
        try {
            return new LDAPSearchQueue(this.conn.search(base, scope, filter, attrs, typesOnly, queue.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPSearchQueue search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchQueue queue, LDAPSearchConstraints cons) throws LDAPException {
        try {
            return new LDAPSearchQueue(this.conn.search(base, scope, filter, attrs, typesOnly, queue.getWrappedObject(), cons.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public static LDAPSearchResults search(LDAPUrl toGet) throws LDAPException {
        try {
            return new LDAPSearchResults(com.novell.ldap.LDAPConnection.search(toGet.getWrappedObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public static LDAPSearchResults search(LDAPUrl toGet, LDAPSearchConstraints cons) throws LDAPException {
        try {
            return new LDAPSearchResults(com.novell.ldap.LDAPConnection.search(toGet.getWrappedObject(), cons.getWrappedSearchObject()));
        }
        catch (com.novell.ldap.LDAPException ex) {
            if (ex instanceof com.novell.ldap.LDAPReferralException) {
                throw new LDAPReferralException((com.novell.ldap.LDAPReferralException)ex);
            }
            throw new LDAPException(ex);
        }
    }

    public LDAPSchema fetchSchema(String schemaDN) throws LDAPException {
        try {
            return new LDAPSchema(this.conn.fetchSchema(schemaDN));
        }
        catch (com.novell.ldap.LDAPException novellException) {
            throw new LDAPException(novellException);
        }
    }

    public String getSchemaDN() throws LDAPException {
        try {
            return this.conn.getSchemaDN();
        }
        catch (com.novell.ldap.LDAPException novellException) {
            throw new LDAPException(novellException);
        }
    }

    public String getSchemaDN(String entryDN) throws LDAPException {
        try {
            return this.conn.getSchemaDN(entryDN);
        }
        catch (com.novell.ldap.LDAPException novellException) {
            throw new LDAPException(novellException);
        }
    }

    private class UnsolImpl
    implements com.novell.ldap.LDAPUnsolicitedNotificationListener {
        LDAPUnsolicitedNotificationListener listen;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UnsolImpl(LDAPUnsolicitedNotificationListener ul) {
            this.listen = ul;
            Hashtable hashtable = LDAPConnection.this.listenerQueues;
            synchronized (hashtable) {
                LDAPConnection.this.listenerQueues.put(ul, this);
            }
        }

        public void messageReceived(com.novell.ldap.LDAPExtendedResponse msg) {
            this.listen.messageReceived(new LDAPExtendedResponse(msg));
        }

        private LDAPUnsolicitedNotificationListener getWrappedObject() {
            return this.listen;
        }
    }

    private static interface SocketFactoryWrapper
    extends com.novell.ldap.LDAPSocketFactory {
        public LDAPSocketFactory getWrappedObject();
    }
}

