<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:common="http://common.bitel.ru"
	xmlns:utils="ru.bitel.common.Utils">

<xsl:output method="html" encoding="UTF-8"
	media-type="text/html"
    omit-xml-declaration="yes"
    doctype-public="-//W3C//DTD HTML 4.01//EN"
    doctype-system="http://www.w3.org/TR/html4/strict.dtd"/>

<xsl:decimal-format name="summa" decimal-separator="." grouping-separator=" "/>

<xsl:template match="/">
	<xsl:call-template name="main">
		<xsl:with-param name="mode" select="'login'"/>
	</xsl:call-template>
</xsl:template>

<xsl:variable name="CONTEXT_PATH"><xsl:value-of select="/data/@contextPath"/></xsl:variable>
<xsl:variable name="WEBEXECUTER">webexecuter</xsl:variable>
<xsl:variable name="PDFEXECUTER">pdfexecuter</xsl:variable> 
<xsl:variable name="PUBEXECUTER">pubexecuter</xsl:variable>
<xsl:variable name="CONTRACT_ID"><xsl:value-of select="/data/@id"/></xsl:variable>

<xsl:template name="main">
	<xsl:param name="mode"/>
	<xsl:variable name="contractTitle" select="/data/@contract"/>
	<xsl:variable name="pageTitle"><xsl:call-template name="title"/></xsl:variable>
	<html>
		<head>
			<link href="{$CONTEXT_PATH}/css/redmond/jquery-ui-1.8.13.custom.css" rel="stylesheet" type="text/css"/>
			<link href="{$CONTEXT_PATH}/style.css" rel="stylesheet" type="text/css" />
			<!-- специальный пустой css файл для пользовательский стилей, не перетирается при обновлениях -->
			<link href="{$CONTEXT_PATH}/custom.css" rel="stylesheet" type="text/css"/>
			<script src="{$CONTEXT_PATH}/js/jquery-min.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.form.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.ui.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.ui.core.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.ui.widget.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.ui.mouse.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.ui.button.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.ui.draggable.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.ui.position.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.ui.resizable.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.ui.dialog.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.effects.core.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.bgiframe-2.1.2.js"></script>
			<script src="{$CONTEXT_PATH}/js/utils.js"></script>
			<script src="{$CONTEXT_PATH}/js/common.js"></script>
			<script src="{$CONTEXT_PATH}/js/bgbilling.js"></script>
			<script src="{$CONTEXT_PATH}/js/jquery.bg.widgets.js"></script>
			<title><xsl:value-of select="$pageTitle"/> | BGBilling</title>
			<xsl:call-template name="head"/>
			
			<script><![CDATA[
				function disableButton( button ) 
				{	
					button.disabled = true;	   
				}
			]]></script>
			
		</head>
		<body>
			<div id="all">
				<!-- logo  -->
				<div class="header">
					<div class="logo"></div>
				</div>
				<!-- end logo  -->
				
				<!-- title  -->
				<div class="pageTitle">
					<xsl:if test="$mode='login'">Договор № <xsl:value-of select="$contractTitle"/></xsl:if>
		           	<xsl:if test="$mode='pub'"><xsl:value-of select="$pageTitle"/></xsl:if>
				</div>
				<!-- end title  -->
				
				<!-- contracts  -->
				<div class="contracts">
					<xsl:if test="$mode='login'">
					<xsl:for-each select="/data/sub_contract">
						<b>Субдоговор:</b>
						<ul>
							<li style="background: none;"><a href="{$WEBEXECUTER}?action=Super&amp;mid=contract&amp;id={@id}"><xsl:value-of select="@title"/></a></li>
						</ul>
					</xsl:for-each>
					<xsl:for-each select="/data/super_contract">
						<b>Супердоговор:</b>
						<ul>
							<li style="background: none;"><a href="{$WEBEXECUTER}?action=Super&amp;mid=contract&amp;id=-1"><xsl:value-of select="@title"/></a></li>
						</ul>
					</xsl:for-each>
					<xsl:if test="/data/sub_contracts">
						<b>Субдоговор:</b>
						<xsl:choose><xsl:when test="count(/data/sub_contracts/item) &lt;= 5">
							<ul>
								<xsl:for-each select="/data/sub_contracts/item">
									<li>
										<xsl:if test="position() = 1">
											<xsl:attribute name="style">background: none;</xsl:attribute>
										</xsl:if>
										<a href="{$WEBEXECUTER}?action=Super&amp;mid=contract&amp;id={@id}">
											<xsl:value-of select="@title"/>
										</a>
									</li>
								</xsl:for-each>
							</ul>
						</xsl:when><xsl:otherwise>
							<form action="{$WEBEXECUTER}?action=Super&amp;mid=contract&amp;" method="POST" style="display: inline">
								<select name="id" onChange="this.form.submit();" style="margin: 0pt; margin-left: 5pt;">
							        <option value="-1">-</option>
							        <xsl:for-each select="/data/sub_contracts/item">
						                <option value="{@id}">
					                        <xsl:if test="@id=$CONTRACT_ID">
				                                <xsl:attribute name="selected"><xsl:text>selected</xsl:text></xsl:attribute>
					                        </xsl:if>
					                        <xsl:value-of select="@title"/>
						                </option>
							        </xsl:for-each>
								</select>
	                        </form>
						</xsl:otherwise></xsl:choose>
					</xsl:if>
					</xsl:if>
				</div>
				<!-- end contracts  -->
				
				<!-- slim blue line  -->
				<div class="line"></div>
				<!-- end slim blue line  -->

				<!-- menu -->
				<xsl:if test="$mode='login'">
				<div class="menu">
					<p>Меню</p>
					<ul>
						<xsl:for-each select="data/menu/item">
							<li>
								<a href="?action={@action}&amp;mid={@mid}&amp;module={@module}&amp;contractId={$CONTRACT_ID}"><xsl:value-of select="@title"/></a>
							</li>
						</xsl:for-each>		
						<li>
							<a onClick="return confirm('Покинуть страницу статистики?');" href="?action=Exit&amp;mid=contract">Выход</a>
						</li>
					</ul>
				</div>
				</xsl:if>
				<!-- end menu -->
				
				<!-- content -->
				<div class="content">
					<noscript>
		        		<div class="errorMessage">
							ВНИМАНИЕ!!! Для корректной работы с данным сайтом необходимо включить
							поддержку JavaScript в браузере. Как это сделать смотрите
							<a href="help/javascript.html">здесь</a>.
						</div>
		        	</noscript>
	        	
		        	<script>
				      <![CDATA[ <!--
							document.cookie = 'BGBILLING=1';
							var ccc = document.cookie;
							if ( ccc == undefined || ccc.length == 0 || ccc.indexOf( "BGBILLING" ) == -1 ) { document.write( '<div class="errorMessage">ВНИМАНИЕ!!! Для корректной работы с данным сайтом необходимо включить поддержку Cookies в браузере. Как это сделать смотрите <a href="#"	onClick="window.open(\'help/cookies.html\', \'mywin2\', \'toolbar=no,status=no,width=600,height=455\'); return false;">здесь</a>.</div>' ); }
				      	--> ]]> 
				    </script>
				
					<xsl:if test="$mode='login'">
						<div class="pageTitle" id="pageTitle"><xsl:value-of select="$pageTitle"/></div>
						<br/>
						<xsl:call-template name="error"/>
					</xsl:if>
				
					<div id="idDiv{data/@action}">
						<xsl:apply-templates/>
					</div>
				</div>
				<!-- end content -->

				<!-- empty -->
				<div class="empty">&#160;</div>
				<!-- end empty -->
				
				<!-- footer  -->
				<div class="footer">
					<div class="line"></div>
					<p>© 2007-<xsl:value-of select="/data/@year"/> <a href="http://www.bitel.ru/" style="color: white;"> BiTel, Ltd.</a></p>
				</div>
				<!-- end footer -->
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="title"></xsl:template>


<!--
 Если задан параметр "text", то просто обрамляется стандартным сообщением об ошибке и уходит, если же не
 задан, то анализируется /data/text(), то есть стандартную ошибку биллинга
 и если(!) она есть, то выводится таким же образом ошибка.
 Также сообщения, то есть при статусе "message" будем тоже рисовать,
 но в рамочке для сообщений.
-->
<xsl:template name="error">
	<xsl:param name="text"/>
	<xsl:choose>
		<xsl:when test="$text"><div class="errorMessage"><xsl:value-of select="$text"/></div></xsl:when>
		<xsl:when test="/data/@status = 'error'">
			<div class="errorMessage"><pre><xsl:value-of select="/data/text()"/></pre></div><br/>
		</xsl:when>
		<xsl:when test="/data/@status = 'message'">
			<div class="infoMessage"><xsl:value-of select="/data/text()"/></div>
		</xsl:when>
	</xsl:choose>
</xsl:template>


<!--
 Обычная чистая кнопка, на неё можно поставить событие onClick и всё.
 Также используется как шаблон во всех остальных кнопках.
 Формы не содержит и не требует, ибо просто пустая болванка.
-->
<xsl:template name="button">
	<xsl:param name="id"/>
	<xsl:param name="title"/>
	<xsl:param name="onclick"/>
	<xsl:param name="type" select="'button'"/>
	<xsl:param name="disabled"/>

	<button id="{$id}" class="gradbtn blue" type="{$type}" onClick="{$onclick};">
	<xsl:if test="$disabled"><xsl:attribute name="disabled">1</xsl:attribute></xsl:if>
	<xsl:value-of select="$title"/></button>					
</xsl:template>


<!--
 Кнопка, в событии которой - просто переход на указанный адрес.
 Формы не содержит и не требует.
-->
<xsl:template name="rawLinkButton">
	<xsl:param name="id"/>
	<xsl:param name="title"/>
	<xsl:param name="url"/>
	<xsl:call-template name="button">
		<xsl:with-param name="id" select="$id"/>
		<xsl:with-param name="title" select="$title"/>
		<xsl:with-param name="onclick">document.location.href='<xsl:value-of select="$url"/>';</xsl:with-param>
	</xsl:call-template>
</xsl:template>


<!--
 Пара кнопок, аналоги OK и CANCEL, надписи по умолчанию - Применить и Отмена.
 Действия по умолчанию - submit родительской формы (можно сменить) и reset
 родительской формы соответственно (можно сменить). Надо вкладывать в форму.
-->
<xsl:template name="okCancel">
	<xsl:param name="title1"/>
	<xsl:param name="title2"/>
	<xsl:param name="onclick1"/>
	<xsl:param name="onclick2"/>
	<xsl:variable name="hidname" select="utils:guid()"/>
	<input type="hidden" name="{$hidname}" id="{$hidname}" />
	<div>
		<xsl:call-template name="button" >
			<xsl:with-param name="title">
				<xsl:choose>
				<xsl:when test="$title1"><xsl:value-of select="$title1"/></xsl:when>
				<xsl:otherwise>Применить</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="onclick">
				<xsl:choose>
				<xsl:when test="$onclick1"><xsl:value-of select="$onclick1"/></xsl:when>
				<xsl:otherwise>jQuery('#<xsl:value-of select="$hidname"/>')[0].form.submit()</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="button">
			<xsl:with-param name="title">
				<xsl:choose>
				<xsl:when test="$title2"><xsl:value-of select="$title2"/></xsl:when>
				<xsl:otherwise>Отмена</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="onclick">
				<xsl:choose>
				<xsl:when test="$onclick2"><xsl:value-of select="$onclick2"/></xsl:when>
				<xsl:otherwise>jQuery('#<xsl:value-of select="$hidname"/>')[0].form.reset()</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
	</div>
</xsl:template>


<!--
 Кнопка-сабмит.
 Требует форму, которую отправляет по нажатию.
 Если есть параметр confirm - кнопка спросит -
 сделать ли действие и сделает лишь в случае положительного ответа.
-->
<xsl:template name="submit">
	<xsl:param name="id"/>
	<xsl:param name="title"/>
	<xsl:param name="confirm"/>
	<xsl:variable name="hidname" select="utils:guid()"/>
	<input type="hidden" name="{$hidname}" id="{$hidname}" />
	<xsl:call-template name="button">
		<xsl:with-param name="id" select="$id"/>
		<xsl:with-param name="title">
			<xsl:choose>
				<xsl:when test="$title"><xsl:value-of select="$title"/></xsl:when>
				<xsl:otherwise>Применить</xsl:otherwise>
			</xsl:choose>
		</xsl:with-param>		
		<xsl:with-param name="onclick"><xsl:if test="$confirm">if (confirm('<xsl:value-of select="$confirm"/>')) </xsl:if>{disableButton(this);jQuery('#<xsl:value-of select="$hidname"/>')[0].form.submit();return false}</xsl:with-param>
	</xsl:call-template>
</xsl:template>


<!-- 
 Кнопка субмит в виде ссылки.
-->
<xsl:template name="submit_text">
	<xsl:param name="title"/>
	<xsl:param name="confirm"/>
	<xsl:variable name="hidname" select="utils:guid()"/>
	<input type="hidden" name="{$hidname}" id="{$hidname}" />
	<xsl:variable name="onclick"><xsl:if test="$confirm">if (confirm('<xsl:value-of select="$confirm"/>')) </xsl:if>jQuery('#<xsl:value-of select="$hidname"/>')[0].form.submit()</xsl:variable>
	<span onClick="{$onclick}" class="spanaslink"><xsl:value-of select="$title"/></span>
</xsl:template>


<!--
 Панелька, внизу и вверху таблицы можно поставить. На ней - листалка страниц
 Идея с неким шаблоном report, который содержит внизу и вверху по две разных
 (одна с hidden, другая - нет) подобных панели (как это было до этого) - не
 очень удачная - негибкая, и вынуждает нас обволакивать всё это снаружи
 отдельной формой. Тем более она не работала как положено.
 Впрочем, это была присказка...
 Этот же пагесБар - отдельная форма, куда передаётся некая 'data', которая
 сюда вставится. Ещё нужно название узла - 'node', откуда брать стандатрные
 данные о странице. 
 Параметр "action" - экшен формы с кнопками, по умолчанию - вебэкзекутер.
-->
<xsl:template name="pagesBar">
	<xsl:param name="node"/>
	<xsl:param name="data"/>
	<xsl:param name="action"/>

	<xsl:if test="$node/@pageIndex">
		<xsl:variable name="pages">
			<xsl:choose>
			<xsl:when test="$node/@pageCount and $node/@pageCount > 0"><xsl:value-of select="$node/@pageCount"/></xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="page">
			<xsl:choose>
			<xsl:when test="$node/@pageIndex"><xsl:value-of select="$node/@pageIndex"/></xsl:when>
			</xsl:choose>
		</xsl:variable>
		<form method="post">
			<xsl:attribute name="action">
				<xsl:choose>
					<xsl:when test="$action"><xsl:value-of select="$action"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="$WEBEXECUTER"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:copy-of select="$data"/>
			<!-- сюда подставится текущая страница -->
			<input type="hidden" name="pageIndex" value="1" id="idPageIndex"/>
			<table border="0" cellpadding="0" cellspacing="0" class="tablePagesBar" style="margin-top:5px ! important; margin-bottom: 5px ! important">
			<tr>
				<td style="padding-right:10px;">Страница&#x0A;</td>
        		<td>
					<xsl:choose>
        				<xsl:when test="$page = 1">
							<img src="img/butt_back.gif" width="15" height="15"/>&#160;
							<img src="img/butt_back1.gif" width="15" height="15"/>
        				</xsl:when>
        				<xsl:otherwise>
    	    				<img src="img/butt_back.gif" width="15" height="15" style="cursor:pointer;" ><xsl:attribute name="onClick">setPage(1, this);</xsl:attribute></img>&#160;
	        				<img src="img/butt_back1.gif" width="15" height="15" style="cursor:pointer;"><xsl:attribute name="onClick">setPage(<xsl:value-of select="$page - 1"/>, this);</xsl:attribute></img>
        				</xsl:otherwise>
        			</xsl:choose>
				</td>
				<td style="padding-left:5px; padding-right:5px;">
        			<xsl:value-of select="$page"/>
 					<xsl:text>&#160;из&#160;</xsl:text>
        			<xsl:value-of select="$pages"/>
				</td>
				<td>
        			<xsl:choose>
        				<xsl:when test="$page = $pages">
    	    				<img src="img/butt_foward1.gif" width="15" height="15"/>&#160;
	        				<img src="img/butt_foward.gif" width="15" height="15"/>
        				</xsl:when>
        				<xsl:otherwise>
        					<img src="img/butt_foward1.gif" width="15" height="15" style="cursor:pointer;"><xsl:attribute name="onClick">setPage(<xsl:value-of select="$page + 1"/>, this);</xsl:attribute></img>&#160;
        					<img src="img/butt_foward.gif" width="15" height="15" style="cursor:pointer;"><xsl:attribute name="onClick">setPage(<xsl:value-of select="$pages"/>, this);</xsl:attribute></img>
        				</xsl:otherwise>
        			</xsl:choose>
        		</td>
        	</tr>
			</table>
		</form>
	</xsl:if>
</xsl:template>
	
<xsl:template name="formatSessionTime">
	<xsl:param name="time"/>

	<xsl:value-of select="format-number( floor($time div 3600), '00' )"/>:<xsl:value-of select="format-number( floor(($time mod 3600) div 60), '00' )"/>:<xsl:value-of select="format-number( $time mod 60, '00' )"/>
	[<xsl:value-of select="$time"/>]
</xsl:template>


<xsl:template name="head">
</xsl:template>

<!--
 Выбор дня-месяца-года из комбобоксов. Этот шаблон используется для отчетов, где нужно выводить информацию за прошлые периоды (за 5 последний лет, включая текущий).    
 Параметры: 
 withSubmit - рисовать кнопку submit.
 withLabel - рисовать надписи День,Месяц,Год.
 withZero - нулевой выбор даты предоставлять.
-->

<xsl:template name="dayFilterForm">
<xsl:param name="withSubmit" select="'1'"/>
<xsl:param name="withLabel" select="'1'"/>
<xsl:param name="withZero" select="'1'"/>
<xsl:param name="nowrap" select="1"/>
<xsl:param name="day" select="1"/>
<xsl:param name="inFuture" select="1"/>

<xsl:call-template name="dayFilterFormAbstract">	
	<xsl:with-param name="withSubmit" select="$withSubmit"/>
	<xsl:with-param name="withLabel" select="$withLabel"/>
	<xsl:with-param name="withZero" select="$withZero"/>
	<xsl:with-param name="nowrap" select="$nowrap"/>
	<xsl:with-param name="day" select="$day"/>
	<xsl:with-param name="inFuture" select="0"/>
</xsl:call-template>

</xsl:template>


<!--
 Выбор дня-месяца-года из комбобоксов. Этот шаблон используется для для смены статуса(например), где нужно менять статус либо 
 с сегодняшенго дня либо в будущем(в прошлом нельзя) . Поэтому в списке годов выводится текущий год или следующий год.   
 Параметры: 
 withSubmit - рисовать кнопку submit.
 withLabel - рисовать надписи День,Месяц,Год.
 withZero - нулевой выбор даты предоставлять.
-->


<xsl:template name="dayFilterFormFuture">

<xsl:param name="withSubmit" select="'1'"/>
<xsl:param name="withLabel" select="'1'"/>
<xsl:param name="withZero" select="'1'"/>
<xsl:param name="nowrap" select="1"/>
<xsl:param name="day" select="1"/>
<xsl:param name="inFuture" select="1"/>
<xsl:param name="nameprefix" select="''"/>


<xsl:call-template name="dayFilterFormAbstract">
	<xsl:with-param name="withSubmit" select="$withSubmit"/>
	<xsl:with-param name="withLabel" select="$withLabel"/>
	<xsl:with-param name="withZero" select="$withZero"/>
	<xsl:with-param name="nowrap" select="$nowrap"/>
	<xsl:with-param name="day" select="$day"/>
	<xsl:with-param name="inFuture" select="1"/>
	<xsl:with-param name="nameprefix" select="$nameprefix"/>
</xsl:call-template>

</xsl:template>

<!--
 Выбор дня-месяца-года из комбобоксов. Универсальный шаблон, лучше использовать dayFilterForm или dayFilterFormFuture
 Параметры: 
 withSubmit - рисовать кнопку submit.
 withLabel - рисовать надписи День,Месяц,Год.
 withZero - нулевой выбор даты предоставлять.
-->
<xsl:template name="dayFilterFormAbstract">
<xsl:param name="withSubmit" select="'1'"/>
<xsl:param name="withLabel" select="'1'"/>
<xsl:param name="withZero" select="'1'"/>
<xsl:param name="nowrap" select="1"/>
<xsl:param name="inFuture" select="1"/>
<xsl:param name="day" select="1"/>
<xsl:param name="nameprefix" select="''"/>

<xsl:choose><xsl:when test="$nowrap">
<table border='0' cellspacing="0">
	<tr>
		<xsl:if test="$day">
		<xsl:if test="$withLabel = 1">
		<td>День:</td>
		</xsl:if>
		<td>
			<select class="gradbtn " name='{$nameprefix}day'>
				<xsl:if test="$withZero = 1">
				<option value='0'><xsl:if test="date/@day = '0' or /data/date/@day = '0' or /data/day = '0'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>--</option>
				</xsl:if>
				<xsl:call-template name="day_list"/>
			</select>
		</td>
		</xsl:if>
		<xsl:if test="$withLabel = 1">
		<td>Месяц:</td>
		</xsl:if>
		<td>
			<select class="gradbtn " name='{$nameprefix}month'>
				<xsl:call-template name="month_list"/>
			</select>
		</td>
		<xsl:if test="$withLabel = 1">
		<td>Год:</td>
		</xsl:if>
		<td>
			<xsl:choose>
			<xsl:when test="$inFuture">
			
			<select class="gradbtn " name="{$nameprefix}year">
				<option value="{/data/date/@year}"><xsl:value-of select="/data/date/@year"/></option>
				<option value="{/data/date/@year + 1}"><xsl:value-of select="/data/date/@year + 1"/></option>
			</select>
			
			</xsl:when>
			<xsl:otherwise>
			
			<select class="gradbtn " name='{$nameprefix}year'>
		  		<xsl:call-template name="year_list"/>
			</select>
			
			</xsl:otherwise>
			</xsl:choose>
		</td>
		<xsl:if test="$withSubmit = 1">
		<td>
			<xsl:call-template name="submit">
				<xsl:with-param name="title" select="'Вывести'"/>
			</xsl:call-template>
		</td>
		</xsl:if>
	</tr>
</table>
</xsl:when><xsl:otherwise>
<table border='0' cellspacing="0">
	<tr>
		<xsl:if test="$day">
		<td>День:<br/>
			<select class="gradbtn " name='{$nameprefix}day'>
				<option value='0'><xsl:if test="date/@day = '0'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>--</option>
				<xsl:call-template name="day_list"/>
			</select>
		</td>
		</xsl:if>
		<td>Месяц:<br/>
			<select class="gradbtn " name='{$nameprefix}month'>
				<xsl:call-template name="month_list"/>
			</select>
		</td>
		<td>Год:<br/>
			<select class="gradbtn " name='{$nameprefix}year'>
		  		<xsl:call-template name="year_list"/>
			</select>
		</td>
		<xsl:if test="$withSubmit">
		<td><br/>
			<xsl:call-template name="submit">
				<xsl:with-param name="title" select="'Вывести'"/>
				<xsl:with-param name="guid" select="'_v'"/>
			</xsl:call-template>
		</td>
		</xsl:if>
	</tr>
</table>
</xsl:otherwise></xsl:choose>
</xsl:template>


<!-- в диалапе используется, и в voiceip -->
<xsl:template name="periodFilter">
	<td>Месяц:<br/>
		<select class="gradbtn" name='month' onChange="this.form.day_from.value='';this.form.day_to.value='';">
			<xsl:call-template name="month_list"/>
		</select>
	</td>
	<td>Год:<br/>
		<select class="gradbtn" name='year'>
			<xsl:call-template name="year_list"/>
		</select>
	</td>
	<td>
		Числа месяца:<br/> c
		<xsl:variable name="dayFrom" select="date/@day_from | /data/date_from/@date"/>
		<input type="text" name="day_from" size="4" value="{$dayFrom[$dayFrom>0]}"></input>
		по
		<xsl:variable name="dayTo" select="date/@day_to | /data/date_to/@date"/>
		<input type="text" name="day_to" size="4" value="{$dayTo[$dayTo>0]}" style="margin-right: 4pt"></input>
	</td>
	<td><br/>
		<xsl:call-template name="submit">
			<xsl:with-param name="title" select="'Применить'"/>
			<xsl:with-param name="guid" select="'_v'"/>
		</xsl:call-template>
	</td>
</xsl:template>
	
	
<!-- используется в voiceip и vod -->
<xsl:template name="loginFilter">
	<xsl:param name="login_title"/>
	<xsl:param name="login_name" select="'login'"/>
	<xsl:variable name="module" select="/data/@module"/>
	<table class="filter">
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="$login_title"><xsl:value-of select="$login_title"/></xsl:when>
					<xsl:when test="$module!='voice'">Логин:</xsl:when>
					<xsl:when test="$module='voice'">Телефон:</xsl:when>
				</xsl:choose>
			</td>
			<td>
				<select class="gradbtn " name="{$login_name}">
					<xsl:call-template name="logins_list"/>
				</select>
			</td>
			<td>Месяц:</td>
			<td><select class="gradbtn " name='month'>
					<xsl:call-template name="month_list"/>
			</select></td>
			<td>Год:</td>
			<td><select class="gradbtn " name='year'>
					<xsl:call-template name="year_list"/>
			</select></td>
			<td nowrap="nowrap">Числа месяца:</td>
			<td style="text-align:center">c</td>
			<td><input type="text" name="day_from" size="4" ><xsl:attribute name="value"><xsl:value-of select="date/@day_from | /data/date_from/@date"/></xsl:attribute></input></td>
			<td style="text-align:center">по</td>
			<td><input type="text" name="day_to" size="4" ><xsl:attribute name="value"><xsl:value-of select="date/@day_to | /data/date_to/@date"/></xsl:attribute></input></td>
			<td>
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Вывести'"/>
				</xsl:call-template>
			</td>
		</tr>
	</table>
</xsl:template>


<!--utils-->
<xsl:template name="action">
	<input type="hidden" name="module" value="{/data/@module}"/>
	<input type="hidden" name="mid" value="{/data/@mid}"/>
	<input type="hidden" name="action" value="{/data/@action}"/>
</xsl:template>
	
<xsl:template name="module">
	<input type="hidden" name="module" value="{/data/@module}"/>
	<input type="hidden" name="mid" value="{/data/@mid}"/>
</xsl:template>


<!--
 Комбобокс со списком месяцев.
 Требует обёртки в select.
-->
<xsl:template name="month_list">	
	<xsl:variable name="selected">
		<xsl:choose>
			<xsl:when test="/data/date/@month"><xsl:value-of select="/data/date/@month"/></xsl:when>
			<!-- новый --><xsl:when test="/data/date_from/@month"><xsl:value-of select="/data/date_from/@month"/></xsl:when>
			<xsl:when test="/data/date/@selected_month"><xsl:value-of select="number(/data/date/@selected_month)+1"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="number(/data/date/@curr_month)+1"/></xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<option value='1'><xsl:if test="$selected = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>январь</option>
	<option value='2'><xsl:if test="$selected = '2'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>февраль</option>
	<option value='3'><xsl:if test="$selected = '3'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>март</option>
	<option value='4'><xsl:if test="$selected = '4'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>апрель</option>
	<option value='5'><xsl:if test="$selected = '5'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>май</option>
	<option value='6'><xsl:if test="$selected = '6'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>июнь</option>
	<option value='7'><xsl:if test="$selected = '7'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>июль</option>
	<option value='8'><xsl:if test="$selected = '8'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>август</option>
	<option value='9'><xsl:if test="$selected = '9'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>сентябрь</option>
	<option value='10'><xsl:if test="$selected = '10'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>октябрь</option>
	<option value='11'><xsl:if test="$selected = '11'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>ноябрь</option>
	<option value='12'><xsl:if test="$selected = '12'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>декабрь</option>
</xsl:template>

<!--
 Комбобокс со списком годов.
 Требует обёртки в select.
 Берёт либо из списка переданных годов, либо 4 последних года.
 TODO запутанная схема указания годов.
-->
<xsl:template name="year_list">
	<xsl:variable name="year">
	  <xsl:choose>
		<xsl:when test="/data/date/@year"><xsl:value-of select="/data/date/@year"/></xsl:when>
		<xsl:when test="/data/date/@selected_year"><xsl:value-of select="/data/date/@selected_year"/></xsl:when>
		<xsl:otherwise><xsl:value-of select="/data/date/@curr_year"/></xsl:otherwise>
	  </xsl:choose>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="date/year">
			<xsl:for-each select="date/year">
			  <option>
			  	<xsl:variable name="value">
				  <xsl:choose>
					<xsl:when test="@value"><xsl:value-of select="@value"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="@year"/></xsl:otherwise>
				  </xsl:choose>
				</xsl:variable>
				 <xsl:attribute name="value"><xsl:value-of select="$value"/></xsl:attribute>
				 <xsl:if test="$value = $year"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
				 <xsl:value-of select="$value"/>
			  </option>
			</xsl:for-each>
		</xsl:when>
		<!-- новый -->
		<xsl:otherwise>
			<xsl:call-template name="next_year">
				<xsl:with-param name="year" select="/data/@year - 4"/>
				<xsl:with-param name="count" select="0"/>
				<xsl:with-param name="selected" select="$year"/>  
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<!-- служебный рекурсивный шаблон -->
<xsl:template name="next_year">
	<xsl:param name="year"/>
	<xsl:param name="count"/>
	<xsl:param name="selected"/>

	<option value="{$year}">
		<xsl:if test="$selected = $year"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
		<xsl:value-of select="$year"/>
	</option>
	
	<xsl:if test="$count &lt; 4">
		<xsl:call-template name="next_year">
			<xsl:with-param name="year" select="$year + 1"/>
			<xsl:with-param name="count" select="$count + 1"/>
			<xsl:with-param name="selected" select="$selected"/>  
		</xsl:call-template>
	</xsl:if>
</xsl:template>


<!--
 Комбобокс со списком дней от 1 до 31.
 Требует обёртки в select.
 Выбранный день задаётся в date/@day или /data/day или /data/date/@day TODO
-->
<xsl:template name="day_list">	
	<xsl:call-template name="next_day">
		<xsl:with-param name="count" select="'1'"/> 
	</xsl:call-template>
</xsl:template>
<!-- служебный рекурсивный шаблон -->
<xsl:template name="next_day">
	<xsl:param name="count"/>
	<option value="{$count}">
		<xsl:if test="date/@day = $count or /data/day = $count or /data/date/@day = $count"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
		<xsl:value-of select="$count"/>
	</option>
	
	<xsl:if test="$count &lt; 31">
		<xsl:call-template name="next_day">
			<xsl:with-param name="count" select="$count + 1"/> 
		</xsl:call-template>
	</xsl:if>
</xsl:template>


<!--
 Транслитерация?
 Не используется.
-->
<xsl:template name="mask">
	<xsl:param name="title"/>
	<xsl:value-of select="translate($title, ' абвгдеёжзийклмнопрстуфхцчшщъыьэюяАБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ.\/', 'asudacbalsanfcruyfcnskduchnrkfuhneuhscenkrfcaudfhhewksrufgadfg')"/>
</xsl:template>
	

<!--
 Список логинов.
 Используется в dialup, voiceip и паре фильтров выше.
 Список берёт из /data/logins/item , текущий выделенный id из /data/logins/@id.
-->
<xsl:template name="logins_list">
   	<xsl:for-each select="/data/logins/item">
		<option value="{@id}">
			<xsl:if test="/data/logins/@id=@id"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
			<xsl:value-of select="@title"/>
		</option>
   	</xsl:for-each>
</xsl:template>


<!--
 Конвертация переносов строк в <br>
-->    
<xsl:template name="n2br">
	<xsl:param name="text"/>
    <xsl:param name="from" select="'&#xA;'"/>  
    <xsl:param name="to"><xsl:element name="br"/></xsl:param>
    <xsl:choose>
      	<xsl:when test="contains($text, $from)">
      		<xsl:value-of select="substring-before($text, $from)"/>
			<xsl:copy-of select="$to"/>
    		<xsl:call-template name="n2br">
	  			<xsl:with-param name="text" select="substring-after($text, $from)"/>
	  			<xsl:with-param name="from" select="$from"/>
	  			<xsl:with-param name="to" select="$to"/>
			</xsl:call-template>
		</xsl:when> 
		<xsl:otherwise>
			<xsl:value-of select="$text"/>  
		</xsl:otherwise>
    </xsl:choose>       
</xsl:template>


<xsl:template name="unit_list">	
	<option>
		<xsl:if test="/data/unit/@unit='1' or /data/unit='1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
		<xsl:attribute name="value">1</xsl:attribute>байт</option>
	<option>
		<xsl:if test="/data/unit/@unit='1024' or /data/unit='1024' "><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
		<xsl:attribute name="value">1024</xsl:attribute>КБ</option>
	<option>
		<xsl:if test="/data/unit/@unit='1048576' or /data/unit='1048576'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
		<xsl:attribute name="value">1048576</xsl:attribute>МБ</option>
	<option>
		<xsl:if test="/data/unit/@unit='1073741824' or /data/unit='1073741824'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
		<xsl:attribute name="value">1073741824</xsl:attribute>ГБ</option>
</xsl:template>


<xsl:template name="unit_title"> 
	<xsl:param name="unit"/>
	<xsl:choose>
		<xsl:when test="$unit=1">байт</xsl:when>
		<xsl:when test="$unit=1024">КБ</xsl:when>
		<xsl:when test="$unit=1048576">МБ</xsl:when>
		<xsl:when test="$unit=1073741824">ГБ</xsl:when>
	</xsl:choose>
</xsl:template>


</xsl:stylesheet>
