<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://common.bitel.ru">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
<xsl:choose>
	<xsl:when test="data/@action = 'DistributeBalance'">Распределение средств</xsl:when>
	<xsl:when test="data/@action = 'ChangeTariff'">Управление тарифными планами</xsl:when>
	<xsl:when test="data/@action = 'TariffOption'">Тарифные опции</xsl:when>
	<xsl:when test="data/@action = 'ContractStatus'">Управление статусом</xsl:when>
	<xsl:otherwise>НОВОСТИ</xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:variable name="tarifQuestion" select="'Вы уверены что хотите сменить тариф? '"/>

<xsl:template match="/data">
<xsl:choose>
	<xsl:when test="@action = 'DistributeBalance'">
		<xsl:call-template name="DistributeBalance"/>
	</xsl:when>
	<xsl:when test="@action = 'ChangeTariff'">		
	 	<xsl:call-template name="ChangeTariff"/>
	</xsl:when>
	<xsl:when test="@action = 'TariffOption' and @operation='activate' and (option_id &lt;= 0 or mode_id &lt;= 0)">
	 	<xsl:call-template name="TariffOptionActivate"/>
	</xsl:when>
	<xsl:when test="@action = 'TariffOption'">
	 	<xsl:call-template name="TariffOption"/>
	</xsl:when>
	<xsl:when test="@action = 'ContractStatus'">
		<xsl:call-template name="ContractStatus" />
	</xsl:when>
</xsl:choose>
</xsl:template>

<!-- распределение средств -->
<xsl:template name="DistributeBalance">
	<form method='post' action='{$WEBEXECUTER}'>
	<xsl:call-template name="action"/>
		
	<input type="hidden" name="commit" value="1"/>
	<table class="filter">
	  <tr>
		<td>Свободные средства: <b><xsl:value-of select="format-number( free/@amount, '### ##0.00', 'summa')"/></b></td>
	  </tr>
	</table>
	
	<table class="layout">
		<tr><td colspan="2">
			<table class="table tableWidth">
				<thead>
					<tr>
						<td style="width: 150px;">Договор</td>
						<td>Примечание</td>
						<td style="width: 150px;">Баланс\сальдо</td>
						<td style="width: 100px;">Сумма</td>
					</tr>
				</thead>
				<tbody>
					<xsl:for-each select="/data/subs/sub">
						<tr>
							<td><xsl:value-of select="@title"/></td>
							<td><xsl:value-of select="@comment"/></td>
							<td><xsl:value-of select="@debt"/></td>
							<td><input type="text" size="10" style="text-align: center;">
									<xsl:attribute name="name">
										<xsl:value-of select="@cid"/>
									</xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:for-each>
				</tbody>
			</table>
		</td></tr>
		<tr class="foot">
		<td style="text-align: left;">
			<button type="button" onclick="document.location='{$WEBEXECUTER}?action=GetBalance&amp;mid=0&amp;module=contract&amp;contractId={$CONTRACT_ID}'">Назад, к просмотру баланса</button>
		</td>
		<td>
			<xsl:call-template name="submit">
				<xsl:with-param name="title" select="'Распределить'"/>
				<xsl:with-param name="align" select="'right'"/>
			</xsl:call-template>
		</td></tr>
	</table>	
	</form>
</xsl:template>


<!-- смена тарифных планов -->
<xsl:template name="ChangeTariff">
	<table class="table800">
		<thead>
		  <tr>
		  	<td>Тарифный план</td>
		  	<td>С даты</td>
		  	<td>По дату</td>
		  	<td>Сменить</td>
		  </tr>
		 </thead>
		 <tbody>
		  <xsl:for-each select="/data/history/row">
			<tr>
				<td><font>
				<xsl:if test="@active=0">
					<xsl:attribute name="color">#8e8e8e</xsl:attribute>
				</xsl:if><xsl:value-of select="@tariff"/><xsl:if test="@type=1"> (персональный)</xsl:if></font></td>
				<td><xsl:value-of select="@date1"/></td>
				<td><xsl:value-of select="@date2"/></td>
				<td>
					<xsl:if test="@group">
						<form method='get' action='{$WEBEXECUTER}'>
							<xsl:call-template name="action"/>
							<input type="hidden" name="command" value="change"/>
							<input type="hidden" name="from_tariff"><xsl:attribute name="value"><xsl:value-of select="@contractTariffId"/></xsl:attribute></input>
							<input type="hidden" name="step"><xsl:attribute name="value"><xsl:value-of select="/data/@step"/></xsl:attribute></input>
							<table class="layout"><tr>
								<xsl:choose>
									<xsl:when test="/data/@step=0">
										<td nowrap="1" style="border: 0px;">Перейти на тариф: <select name="to_tariff"><option value="-1">---</option><xsl:for-each select="tariff_list/item" >
													<option value="{@id}"><xsl:value-of select="@title"/></option>
												</xsl:for-each>			
											</select>
										</td>
										<td style="border: 0px;">
											<xsl:call-template name="submit">				
												<xsl:with-param name="title" select="'Выбрать дату'"/>
											</xsl:call-template>
										</td>
									</xsl:when>
									<xsl:when test="/data/@step=1">
										<xsl:if test="@tariffId=/data/@from_tariff">
											<td nowrap="1" style="border: 0px;">	
											<input type="hidden" name="to_tariff"><xsl:attribute name="value"><xsl:value-of select="/data/@to_tariff"/></xsl:attribute></input>	Перейти на тариф: <b><xsl:value-of select="/data/@to_tariff_title"/></b> с даты: <select name="from_date">
													<xsl:for-each select="date_list/item">
														<option>
															<xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
															<xsl:value-of select="@value"/>
														</option>
													</xsl:for-each>
												</select>
											</td>
											<td style="border: 0px;">
												<xsl:call-template name="submit">				
													<xsl:with-param name="title" select="'Сменить тариф'"/>
													<xsl:with-param name="confirm" select="'Вы уверены, что хотите сменить тариф?'"/>
												</xsl:call-template>
											</td>
										</xsl:if>
									</xsl:when>		
								</xsl:choose>
							</tr></table>
						</form>
					</xsl:if>
					<xsl:if test="@canCancel=1">
						<form method='post' action='{$WEBEXECUTER}'>
							<xsl:call-template name="action"/>
							<input type="hidden" name="command" value="cancel"/>
							<input type="hidden" name="contractTariffId" value="{@contractTariffId}"/>
							
							<div style="float: left;">
								Предыдущий тариф: "<xsl:value-of select="@previousTariffTitle"/>"
							</div>
							<div style="float: left; padding-left: 10px;">
								<xsl:call-template name="submit">
									<xsl:with-param name="title" select="'Отменить переход'"/>
									<xsl:with-param name="confirm" select="'Вы уверены, что хотите отменить переход на тариф?'"/>
								</xsl:call-template>
							</div>
						</form>
					</xsl:if>
				</td>
			</tr>
		  </xsl:for-each>
		  </tbody>	
	</table>		
	
	<em class="comment">Серым цветом выделены неактивные тарифные планы.</em>
	
	
</xsl:template>

<xsl:template name="nav">
	<xsl:param name="all"/>

	<form id="show_form" method="get" action="{$WEBEXECUTER}">
		<xsl:call-template name="action"/>
		<input type="hidden" id="operation" name="operation"/>
	</form>

	<table class="filter" style="margin-bottom: 5pt;">
	<tr>
		<xsl:choose>
			<xsl:when test="/data/@operation = 'history'">
				<td style="padding-right:5pt;"><a href="#" onclick="jQuery('#operation')[0].value='execute';jQuery('#show_form')[0].submit();">Текущие опции</a></td>
				<td><b>История опций</b></td>
			</xsl:when>
			<xsl:when test="/data/@operation != 'execute' and $all">
				<td style="padding-right:5pt;"><a href="#" onclick="jQuery('#operation')[0].value='execute';jQuery('#show_form')[0].submit();">Текущие опции</a></td>
				<td><a href="#" onclick="jQuery('#operation')[0].value='history';jQuery('#show_form')[0].submit();">История опций</a></td>
			</xsl:when>
			<xsl:otherwise>
				<td style="padding-right:5pt;"><b>Текущие опции</b></td>
				<td><a href="#" onclick="jQuery('#operation')[0].value='history';jQuery('#show_form')[0].submit();">История опций</a></td>
			</xsl:otherwise>
		</xsl:choose>
	</tr>
	</table>
</xsl:template>


<!-- тарифные опции -->
<xsl:template name="TariffOption">

	<xsl:call-template name="nav"/>

	<table class="table800">
		<thead>
		  <tr>
		  	<td>Опция</td>
		  	<td>Начало</td>
		  	<td>Окончание</td>
		  	<td>Стоимость активации*</td>
		  	<xsl:if test="/data/@operation != 'history'">
		  		<td> </td>
		  	</xsl:if>
		  </tr>
		 </thead>
		 <tbody>
		 	<xsl:for-each select="common:result/data/item">
		 		<tr>
		 			<xsl:variable name="optionId" select="@optionId"/>
					<td><xsl:value-of select="@optionTitle"/></td>
					<td><xsl:value-of select="@timeFrom"/></td>
					<td>
					
						<xsl:choose>
							<xsl:when test="@timeTo and string-length(@timeTo) &gt; 0">
								<xsl:value-of select="@timeTo"/>

								<xsl:variable name="optionId" select="@optionId"/>
								<xsl:variable name="activatedMode" select="@activatedMode"/>
								<xsl:if test="/data/options/data/item[@id=$optionId]/modeList/item[@id=$activatedMode]/@reactivationMode = 1">
									<xsl:call-template name="button">
										<xsl:with-param name="align" select="'center'"/>
										<xsl:with-param name="onclick">if( confirm( &quot;Вы уверены, что хотите реактивировать опцию?&quot; ) ){ jQuery('#reactivate_form')[0].id.value='<xsl:value-of select="@id"/>';jQuery('#reactivate_form')[0].submit(); }</xsl:with-param>
										<!--  <xsl:with-param name="onclick">if( confirm( &quot;Вы уверены, что хотите реактивировать опцию?&quot; ) ){ $('reactivate_form').id.value='<xsl:value-of select="@id"/>';$('reactivate_form').submit(); }</xsl:with-param>-->
										<xsl:with-param name="title" select="'Реактивировать'"/>
									</xsl:call-template>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="button">
									<xsl:with-param name="align" select="'center'"/>
									<xsl:with-param name="onclick">if( confirm( &quot;Вы уверены, что хотите деактивировать опцию?&quot; ) ){ jQuery('#deactivate_form')[0].id.value='<xsl:value-of select="@id"/>';jQuery('#deactivate_form')[0].submit(); }</xsl:with-param>
									<!--  <xsl:with-param name="onclick">if( confirm( &quot;Вы уверены, что хотите деактивировать опцию?&quot; ) ){ $('deactivate_form').id.value='<xsl:value-of select="@id"/>';$('deactivate_form').submit(); }</xsl:with-param>-->
									<xsl:with-param name="title" select="'Деактивировать'"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<td><xsl:value-of select="@summa"/></td>
					
					<xsl:if test="/data/@operation != 'history'">
						<td>
							<xsl:variable name="id" select="@id"/>
							<xsl:variable name="optionId" select="@optionId"/>
							<xsl:variable name="activatedMode" select="@activatedMode"/>
	
							<xsl:choose>
								<xsl:when test="/data/options/data/item[@id=$optionId]/modeList/item[@id=$activatedMode]/@deleteMode = 2 and /data/future_options/data/item[@id=$id]">
								
									<xsl:call-template name="button">
										<xsl:with-param name="align" select="'center'"/>
										<xsl:with-param name="onclick">if( confirm( &quot;Вы уверены, что хотите отменить опцию?&quot; ) ){ jQuery('#delete_form')[0].id.value='<xsl:value-of select="@id"/>';jQuery('#delete_form')[0].submit(); }</xsl:with-param>
										<xsl:with-param name="title" select="'Отменить'"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</xsl:if>
				</tr>						
			</xsl:for-each>			
		 </tbody>	
	</table>
		
	<em class="comment">*Стоимость активации - сумма, снимаемая в момент активации опции и
		не отражает периодической платы за пользование,<br/> если таковая предусмотрена в тарифном плане.</em>
	
	<form id="deactivate_form" method="post" action="{$WEBEXECUTER}">
		<xsl:call-template name="action"/>
		<input type="hidden" name="operation" value="deactivate"/>
		<input type="hidden" id="contractTariffOptionId" name="id"/>
	</form>
	
	<form id="reactivate_form" method="post" action="{$WEBEXECUTER}">
		<xsl:call-template name="action"/>
		<input type="hidden" name="operation" value="reactivate"/>
		<input type="hidden" name="id"/>
	</form>
	
	<form id="delete_form" method="post" action="{$WEBEXECUTER}">
		<xsl:call-template name="action"/>
		<input type="hidden" name="operation" value="delete"/>
		<input type="hidden" name="id"/>
	</form>
	
	
	<xsl:if test="/data/@operation != 'history'">
		<br/>	
		<form id="activate_form" method="post" action="{$WEBEXECUTER}">
			<xsl:call-template name="action"/>
			<input type="hidden" name="operation" value="activate"/>
			
			<table class="filter">
				<tr>
					<td>
						<xsl:call-template name="submit">
							<xsl:with-param name="title" select="'Активировать опцию'"/>
						</xsl:call-template>
					</td>
				</tr>			
			</table>
		</form>
	</xsl:if>
	
</xsl:template>

<xsl:template name="TariffOptionActivate">
	
	<xsl:call-template name="nav"><xsl:with-param name="all" select="'1'"/></xsl:call-template>
	
		<xsl:choose><xsl:when test="not(available_options/data/item)">
		<em>
			На данный момент нет опций, которые Вы могли бы активировать.
		</em>
	</xsl:when><xsl:otherwise>
		<em>
			Выберите тарифную опцию, которую хотите активировать, режим активации и нажмите "Активировать".
		</em>
	</xsl:otherwise></xsl:choose>
	
	<xsl:for-each select="available_options/data/item">
		<div style="width:800px">
		<form method="get" action="{$WEBEXECUTER}">
		<xsl:call-template name="action"/>
		<input type="hidden" name="operation" value="activate"/>
		<input type="hidden" name="option_id" value="{@id}"/>
		
		<p style="font-size:120%; font-weight: bold; margin-bottom: 5px;"><xsl:value-of select="@title"/></p>
		<xsl:if test="string-length(description)&gt;0">
		<xsl:value-of select="description" disable-output-escaping="yes"/><br/>
		</xsl:if>
		
		<div style="display: inline-block; padding-left: 30pt; padding-bottom: 5pt;">
		<table class="table" style="margin-top: 5pt; margin-bottom: 5pt; font-size: 90%;">
		<thead><tr>
			<th>Режим активации</th>
			<th>Стоимость активации, руб.</th>
		</tr></thead>
		<tbody>
			<xsl:for-each select="modeList/item">
				<tr>
					<td style="vertical-align: bottom; text-align: left">
						<input type="radio" name="mode_id" value="{@id}" id="activationMode{@id}" onchange="$('activate{../../@id}').disabled=false;"/>
						<label for="activationMode{@id}"><xsl:value-of select="@modeTitle" /></label>
					</td>
					<td style="vertical-align: bottom"><xsl:value-of select="format-number(@chargeSumma, '### ### ### ##0.00', 'summa')"/></td>
				</tr>
			</xsl:for-each>
		</tbody>
		</table>	
		
		<div align="right">
		<xsl:call-template name="button">
			<xsl:with-param name="id">activate<xsl:value-of select="@id"/></xsl:with-param>
			<xsl:with-param name="align" select="'right'"/>
			<xsl:with-param name="onclick">if( confirm( &quot;Вы уверены, что хотите активировать опцию?&quot; ) ){ this.form.submit(); }else{return false;}</xsl:with-param>
			<xsl:with-param name="title" select="'Активировать'"/>
			<xsl:with-param name="disabled" select="'1'"/>
		</xsl:call-template>
		</div>
		</div>
		
		</form>
		</div>
	</xsl:for-each>
	
</xsl:template>

<xsl:template name="ContractStatus">
	
	Текущий статус: <b><xsl:value-of select="/data/@statusstr"/></b>.
	
	<br/><br/>

	<xsl:choose>
		<!-- если canchange=1 (CANCHANGE_DISABLED) -->
		<xsl:when test="/data/@canchange=1">
			Смена статуса запрещена системой.
		</xsl:when>		
		<!-- если canchange=2 (CANCHANGE_DISABLED_BADSTATUS) -->
		<xsl:when test="/data/@canchange=2">
			Смена статуса невозможна из текущего статуса.
		</xsl:when>		
		<!-- если canchange=3 (CANCHANGE_DO) -->
		<xsl:when test="/data/@canchange=3">
			<form method="post" action="{$WEBEXECUTER}">
				<xsl:call-template name="module"/>
				<input type="hidden" name="action" value="ContractStatus" />
				<input type="hidden" name="command" value="Change" />
				<table class="filter">
					<tr>
						<td>
						<xsl:choose>
							<!-- CONTRACT_STATUS_ACTIVE -->
							<xsl:when test="/data/@statusint=0">
								Приостановить
								<input type="hidden" name="status" value="4" />
							</xsl:when>
							<!-- CONTRACT_STATUS_SUSPENDED -->
							<xsl:when test="/data/@statusint=4">
								Активировать
								<input type="hidden" name="status" value="0" />
							</xsl:when>						
						</xsl:choose>
						договор с
						</td>					
						<!-- если есть список дат, то он рисуется, иначе рисуются поля для ручного ввода даты -->
						<xsl:choose>
						<xsl:when test="/data/date_list">
							<td>
								<select class="gradbtn " name="from_date" >
									<xsl:for-each select="/data/date_list/item">
										<option value="{@value}"><xsl:value-of select="@value"/></option>
									</xsl:for-each>
								</select>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td>
								<xsl:call-template name="dayFilterFormFuture">
									<xsl:with-param name="withZero" select="'0'"/>
									<xsl:with-param name="withLabel" select="'0'"/>
									<xsl:with-param name="withSubmit" select="'0'"/>
								</xsl:call-template>
							</td>
						</xsl:otherwise>
						</xsl:choose>					
						<!-- 
						раскомментировать если требуется возможность указывать даду ДО при смене статуса
						ЗАМЕТКА: мы не можем использовать там dayFilterFormFuture вместе с nameprefix потому что он кривой и не полностью его поддерживает
						<xsl:if test="/data/@statusint=0">
						<td>
						по
						</td>
						<xsl:choose>
						<xsl:when test="/data/date_list_to">
							<td>
								<select class="gradbtn " name="to_date" >
									<xsl:for-each select="/data/date_list_to/item">
										<option value="{@value}"><xsl:value-of select="@value"/></option>
									</xsl:for-each>
								</select>
							</td>
						</xsl:when>
						<xsl:otherwise>
							<td>
								<table cellspacing="0" border="0"><tbody><tr>
                      				<td>
                      					<select name="to_day" class="gradbtn ">
                      						<option value="1"><xsl:if test="/data/to_date/@to_day = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>1</option>
                      						<option value="2"><xsl:if test="/data/to_date/@to_day = '2'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>2</option>
                      						<option value="3"><xsl:if test="/data/to_date/@to_day = '3'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>3</option>
                      						<option value="4"><xsl:if test="/data/to_date/@to_day = '4'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>4</option>
                      						<option value="5"><xsl:if test="/data/to_date/@to_day = '5'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>5</option>
                      						<option value="6"><xsl:if test="/data/to_date/@to_day = '6'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>6</option>
                      						<option value="7"><xsl:if test="/data/to_date/@to_day = '7'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>7</option>
                      						<option value="8"><xsl:if test="/data/to_date/@to_day = '8'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>8</option>
                      						<option value="9"><xsl:if test="/data/to_date/@to_day = '9'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>9</option>
                      						<option value="10"><xsl:if test="/data/to_date/@to_day = '10'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>10</option>
                      						<option value="11"><xsl:if test="/data/to_date/@to_day = '11'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>11</option>
                      						<option value="12"><xsl:if test="/data/to_date/@to_day = '12'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>12</option>
                      						<option value="13"><xsl:if test="/data/to_date/@to_day = '13'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>13</option>
                      						<option value="14"><xsl:if test="/data/to_date/@to_day = '14'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>14</option>
                      						<option value="15"><xsl:if test="/data/to_date/@to_day = '15'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>15</option>
                      						<option value="16"><xsl:if test="/data/to_date/@to_day = '16'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>16</option>
                      						<option value="17"><xsl:if test="/data/to_date/@to_day = '17'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>17</option>
                      						<option value="18"><xsl:if test="/data/to_date/@to_day = '18'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>18</option>
                      						<option value="19"><xsl:if test="/data/to_date/@to_day = '19'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>19</option>
                      						<option value="20"><xsl:if test="/data/to_date/@to_day = '20'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>20</option>
                      						<option value="21"><xsl:if test="/data/to_date/@to_day = '21'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>21</option>
                      						<option value="22"><xsl:if test="/data/to_date/@to_day = '22'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>22</option>
                      						<option value="23"><xsl:if test="/data/to_date/@to_day = '23'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>23</option>
                      						<option value="24"><xsl:if test="/data/to_date/@to_day = '24'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>24</option>
                      						<option value="25"><xsl:if test="/data/to_date/@to_day = '25'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>25</option>
                      						<option value="26"><xsl:if test="/data/to_date/@to_day = '26'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>26</option>
                      						<option value="27"><xsl:if test="/data/to_date/@to_day = '27'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>27</option>
                      						<option value="28"><xsl:if test="/data/to_date/@to_day = '28'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>28</option>
                      						<option value="29"><xsl:if test="/data/to_date/@to_day = '29'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>29</option>
                      						<option value="30"><xsl:if test="/data/to_date/@to_day = '30'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>30</option>
                      						<option value="31"><xsl:if test="/data/to_date/@to_day = '31'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>31</option>
                      					</select>
                      				</td>
                      				<td>
                      					<select name="to_month" class="gradbtn ">
                      						<option value="1"><xsl:if test="/data/to_date/@to_month = '1'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>январь</option>
                      						<option value="2"><xsl:if test="/data/to_date/@to_month = '2'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>февраль</option>
                      						<option value="3"><xsl:if test="/data/to_date/@to_month = '3'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>март</option>
                      						<option value="4"><xsl:if test="/data/to_date/@to_month = '4'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>апрель</option>
                      						<option value="5"><xsl:if test="/data/to_date/@to_month = '5'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>май</option>
                      						<option value="6"><xsl:if test="/data/to_date/@to_month = '6'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>июнь</option>
                      						<option value="7"><xsl:if test="/data/to_date/@to_month = '7'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>июль</option>
                      						<option value="8"><xsl:if test="/data/to_date/@to_month = '8'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>август</option>
                      						<option value="9"><xsl:if test="/data/to_date/@to_month = '9'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>сентябрь</option>
                      						<option value="10"><xsl:if test="/data/to_date/@to_month = '10'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>октябрь</option>
                      						<option value="11"><xsl:if test="/data/to_date/@to_month = '11'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>ноябрь</option>
                      						<option value="12"><xsl:if test="/data/to_date/@to_month = '12'"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>декабрь</option>
                      					</select>
                      				</td>
                      				<td>
                      					<select name="to_year" class="gradbtn">
                      						<option value="{/data/to_date/@to_year}"><xsl:value-of select="/data/to_date/@to_year"/></option>
											<option value="{/data/to_date/@to_year + 1}"><xsl:value-of select="/data/to_date/@to_year + 1"/></option>
                      					</select>
                      				</td>
                    			</tr></tbody></table>
							</td>
						</xsl:otherwise>
						</xsl:choose>	
						</xsl:if>
						-->			
						<td>
							<xsl:call-template name="submit">
								<xsl:with-param name="title" select="'Выполнить'"/>
							</xsl:call-template>
						</td>
					</tr>
				</table>
			</form>
		</xsl:when>
		<!-- если canchange=4 (CANCHANGE_CANCEL_ALLOW) -->
		<xsl:when test="/data/@canchange=4">
			<form method="post" action="{$WEBEXECUTER}">
				<xsl:call-template name="module"/>
				<input type="hidden" name="action" value="ContractStatus" />
				<input type="hidden" name="command" value="Cancel" />
				<div style="float:left; margin-right: 10px;">На будущее число было запланирована смена статуса. Вы можете отменить её.</div>
				<div>
					<xsl:call-template name="submit">
						<xsl:with-param name="title" select="'Отменить'"/>
					</xsl:call-template>
				</div>
			</form>
		</xsl:when>
		<!-- если canchange=5 (CANCHANGE_CANCEL_DENY) --> 
		<xsl:when test="/data/@canchange=5">
			На будущее число было запланирована смена(-ы) статуса, которую вы отменить не можете.
		</xsl:when>
		<!-- если canchange иной -->
		<xsl:otherwise>
			Ошибка. Статус нельзя изменить. Обратитесь к оператору. canchange=<xsl:value-of select="/data/@canchange"/>. 
		</xsl:otherwise>
	</xsl:choose>		

	<br/><br/>
		
	<table class="table800">
		<thead>
			  <tr>
				<td>Период</td>
				<td>Статус</td>
				<td>Комментарий</td>
			  </tr>
		</thead>
		<xsl:if test="statuses/status">
			<tbody>
			  <xsl:for-each select="statuses/status">
				<tr>
					<xsl:if test="@future=1">
						<xsl:attribute name="class">row_status_inactive</xsl:attribute>
					</xsl:if>
					<td><xsl:value-of select="@period"/></td>
					<td><xsl:value-of select="@status"/></td>		
					<td><xsl:value-of select="@comment"/></td>
				</tr>		
			  </xsl:for-each>
			</tbody>
		</xsl:if>
	</table>
	
	<em class="comment">
		Здесь можно приостановить или активировать договор. Приостановить договор можно
		не ранее завтрашнего числа. Активировать можно начиная с сегодняшнего.<br/> 
		В таблице серым цветом отмечены неактивные периоды (например, будущие).
	</em>

</xsl:template>


</xsl:stylesheet>
