/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Arrays;
import junit.framework.TestCase;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SingleCompressedNameBase;
import org.xbill.DNS.TextParseException;

public class SingleCompressedNameBaseTest
extends TestCase {
    private void assertEquals(byte[] exp, byte[] act) {
        SingleCompressedNameBaseTest.assertTrue((boolean)Arrays.equals(exp, act));
    }

    public void test_ctor() throws TextParseException {
        TestClass tc = new TestClass();
        SingleCompressedNameBaseTest.assertNull((Object)tc.getSingleName());
        Name n = Name.fromString("my.name.");
        Name sn = Name.fromString("my.single.name.");
        tc = new TestClass(n, 1, 1, 100L, sn, "The Description");
        SingleCompressedNameBaseTest.assertSame((Object)n, (Object)tc.getName());
        SingleCompressedNameBaseTest.assertEquals((int)1, (int)tc.getType());
        SingleCompressedNameBaseTest.assertEquals((int)1, (int)tc.getDClass());
        SingleCompressedNameBaseTest.assertEquals((long)100L, (long)tc.getTTL());
        SingleCompressedNameBaseTest.assertSame((Object)sn, (Object)tc.getSingleName());
    }

    public void test_rrToWire() throws IOException, TextParseException {
        Name n = Name.fromString("my.name.");
        Name sn = Name.fromString("My.Single.Name.");
        TestClass tc = new TestClass(n, 1, 1, 100L, sn, "The Description");
        byte[] exp = new byte[]{2, 77, 121, 6, 83, 105, 110, 103, 108, 101, 4, 78, 97, 109, 101, 0};
        DNSOutput dout = new DNSOutput();
        tc.rrToWire(dout, null, false);
        byte[] out = dout.toByteArray();
        this.assertEquals(exp, out);
        tc = new TestClass(n, 1, 1, 100L, sn, "The Description");
        exp = new byte[]{2, 109, 121, 6, 115, 105, 110, 103, 108, 101, 4, 110, 97, 109, 101, 0};
        dout = new DNSOutput();
        tc.rrToWire(dout, null, true);
        out = dout.toByteArray();
        this.assertEquals(exp, out);
    }

    private static class TestClass
    extends SingleCompressedNameBase {
        public TestClass() {
        }

        public TestClass(Name name, int type, int dclass, long ttl, Name singleName, String desc) {
            super(name, type, dclass, ttl, singleName, desc);
        }

        public Name getSingleName() {
            return super.getSingleName();
        }

        public Record getObject() {
            return null;
        }
    }
}

