/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import junit.framework.TestCase;
import org.xbill.DNS.InvalidTTLException;
import org.xbill.DNS.TTL;

public class TTLTest
extends TestCase {
    private final long S = 1L;
    private final long M = 60L;
    private final long H = 3600L;
    private final long D = 86400L;
    private final long W = 604800L;

    public void test_parseTTL() {
        TTLTest.assertEquals((long)9876L, (long)TTL.parseTTL("9876"));
        TTLTest.assertEquals((long)0L, (long)TTL.parseTTL("0S"));
        TTLTest.assertEquals((long)0L, (long)TTL.parseTTL("0M"));
        TTLTest.assertEquals((long)0L, (long)TTL.parseTTL("0H"));
        TTLTest.assertEquals((long)0L, (long)TTL.parseTTL("0D"));
        TTLTest.assertEquals((long)0L, (long)TTL.parseTTL("0W"));
        TTLTest.assertEquals((long)1L, (long)TTL.parseTTL("1s"));
        TTLTest.assertEquals((long)60L, (long)TTL.parseTTL("1m"));
        TTLTest.assertEquals((long)3600L, (long)TTL.parseTTL("1h"));
        TTLTest.assertEquals((long)86400L, (long)TTL.parseTTL("1d"));
        TTLTest.assertEquals((long)604800L, (long)TTL.parseTTL("1w"));
        TTLTest.assertEquals((long)98L, (long)TTL.parseTTL("98S"));
        TTLTest.assertEquals((long)4560L, (long)TTL.parseTTL("76M"));
        TTLTest.assertEquals((long)194400L, (long)TTL.parseTTL("54H"));
        TTLTest.assertEquals((long)2764800L, (long)TTL.parseTTL("32D"));
        TTLTest.assertEquals((long)6048000L, (long)TTL.parseTTL("10W"));
        TTLTest.assertEquals((long)5220758L, (long)TTL.parseTTL("98S11M1234H2D01W"));
    }

    public void test_parseTTL_invalid() {
        try {
            TTL.parseTTL(null);
            TTLTest.fail((String)"NumberFormatException not throw");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            TTL.parseTTL("");
            TTLTest.fail((String)"NumberFormatException not throw");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            TTL.parseTTL("S");
            TTLTest.fail((String)"NumberFormatException not throw");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            TTL.parseTTL("10S4B");
            TTLTest.fail((String)"NumberFormatException not throw");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            TTL.parseTTL("1S4294967295S");
            TTLTest.fail((String)"NumberFormatException not throw");
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            TTL.parseTTL("4294967296");
            TTLTest.fail((String)"NumberFormatException not throw");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void test_format() {
        TTLTest.assertEquals((String)"0S", (String)TTL.format(0L));
        TTLTest.assertEquals((String)"1S", (String)TTL.format(1L));
        TTLTest.assertEquals((String)"59S", (String)TTL.format(59L));
        TTLTest.assertEquals((String)"1M", (String)TTL.format(60L));
        TTLTest.assertEquals((String)"59M", (String)TTL.format(3540L));
        TTLTest.assertEquals((String)"1M33S", (String)TTL.format(93L));
        TTLTest.assertEquals((String)"59M59S", (String)TTL.format(3599L));
        TTLTest.assertEquals((String)"1H", (String)TTL.format(3600L));
        TTLTest.assertEquals((String)"10H1M21S", (String)TTL.format(36081L));
        TTLTest.assertEquals((String)"23H59M59S", (String)TTL.format(86399L));
        TTLTest.assertEquals((String)"1D", (String)TTL.format(86400L));
        TTLTest.assertEquals((String)"4D18H45M30S", (String)TTL.format(413130L));
        TTLTest.assertEquals((String)"6D23H59M59S", (String)TTL.format(604799L));
        TTLTest.assertEquals((String)"1W", (String)TTL.format(604800L));
        TTLTest.assertEquals((String)"10W4D1H21M29S", (String)TTL.format(6398489L));
        TTLTest.assertEquals((String)"3550W5D3H14M7S", (String)TTL.format(Integer.MAX_VALUE));
    }

    public void test_format_invalid() {
        try {
            TTL.format(-1L);
            TTLTest.fail((String)"InvalidTTLException not thrown");
        }
        catch (InvalidTTLException e) {
            // empty catch block
        }
        try {
            TTL.format(0x100000000L);
            TTLTest.fail((String)"InvalidTTLException not thrown");
        }
        catch (InvalidTTLException invalidTTLException) {
            // empty catch block
        }
    }
}

