/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPReferralHandler;
import com.novell.ldap.client.Debug;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;

public class LDAPConstraints
implements Cloneable,
Serializable {
    private int msLimit = 0;
    private int hopLimit = 10;
    private boolean doReferrals = false;
    private LDAPReferralHandler refHandler = null;
    private LDAPControl[] controls = null;
    private static Object nameLock = new Object();
    private static int lConsNum = 0;
    private String name;
    private Hashtable properties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConstraints() {
        Object object = nameLock;
        synchronized (object) {
            this.name = "LDAPConstraints(" + ++lConsNum + "): ";
        }
        Debug.trace("APIRequests", this.name + "Created, follow referrals = " + this.doReferrals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConstraints(int msLimit, boolean doReferrals, LDAPReferralHandler handler, int hop_limit) {
        this.msLimit = msLimit;
        this.doReferrals = doReferrals;
        this.refHandler = handler;
        this.hopLimit = hop_limit;
        Object object = nameLock;
        synchronized (object) {
            this.name = "LDAPConstraints(" + ++lConsNum + "): ";
        }
        Debug.trace("APIRequests", this.name + "Created, follow referrals = " + doReferrals);
    }

    public LDAPControl[] getControls() {
        return this.controls;
    }

    public int getHopLimit() {
        return this.hopLimit;
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    Hashtable getProperties() {
        return this.properties;
    }

    public boolean getReferralFollowing() {
        return this.doReferrals;
    }

    LDAPReferralHandler getReferralHandler() {
        return this.refHandler;
    }

    public int getTimeLimit() {
        return this.msLimit;
    }

    public void setControls(LDAPControl control) {
        if (control == null) {
            this.controls = null;
            return;
        }
        this.controls = new LDAPControl[1];
        this.controls[0] = (LDAPControl)control.clone();
    }

    public void setControls(LDAPControl[] controls) {
        if (controls == null || controls.length == 0) {
            this.controls = null;
            return;
        }
        this.controls = new LDAPControl[controls.length];
        for (int i = 0; i < controls.length; ++i) {
            this.controls[i] = (LDAPControl)controls[i].clone();
        }
    }

    public void setHopLimit(int hop_limit) {
        this.hopLimit = hop_limit;
    }

    public void setProperty(String name, Object value) throws LDAPException {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(name, value);
    }

    void setProperties(Hashtable props) {
        this.properties = (Hashtable)props.clone();
    }

    public void setReferralFollowing(boolean doReferrals) {
        this.doReferrals = doReferrals;
        Debug.trace("APIRequests", this.name + "Follow referrals = " + doReferrals);
    }

    public void setReferralHandler(LDAPReferralHandler handler) {
        this.refHandler = handler;
    }

    public void setTimeLimit(int msLimit) {
        this.msLimit = msLimit;
    }

    public Object clone() {
        try {
            Object newObj = super.clone();
            if (this.controls != null) {
                ((LDAPConstraints)newObj).controls = (LDAPControl[])this.controls.clone();
            }
            if (this.properties != null) {
                ((LDAPConstraints)newObj).properties = (Hashtable)this.properties.clone();
            }
            return newObj;
        }
        catch (CloneNotSupportedException ce) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    private void writeObject(ObjectOutputStream objectOStrm) throws IOException {
        objectOStrm.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectIStrm) throws IOException, ClassNotFoundException {
        objectIStrm.defaultReadObject();
    }
}

