/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeDescriptionList;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcFilter;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcSearchRequest;
import java.io.IOException;
import java.util.Iterator;

public class LDAPSearchRequest
extends LDAPMessage {
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    public static final int EQUALITY_MATCH = 3;
    public static final int SUBSTRINGS = 4;
    public static final int GREATER_OR_EQUAL = 5;
    public static final int LESS_OR_EQUAL = 6;
    public static final int PRESENT = 7;
    public static final int APPROX_MATCH = 8;
    public static final int EXTENSIBLE_MATCH = 9;
    public static final int INITIAL = 0;
    public static final int ANY = 1;
    public static final int FINAL = 2;

    public LDAPSearchRequest() {
        super(3);
    }

    public LDAPSearchRequest(String base, int scope, String filter, String[] attrs, int dereference, int maxResults, int serverTimeLimit, boolean typesOnly, LDAPControl[] cont) throws LDAPException {
        super(3, new RfcSearchRequest(new RfcLDAPDN(base), new ASN1Enumerated(scope), new ASN1Enumerated(dereference), new ASN1Integer(maxResults), new ASN1Integer(serverTimeLimit), new ASN1Boolean(typesOnly), new RfcFilter(filter), new RfcAttributeDescriptionList(attrs)), cont);
    }

    public LDAPSearchRequest(String base, int scope, RfcFilter filter, String[] attrs, int dereference, int maxResults, int serverTimeLimit, boolean typesOnly, LDAPControl[] cont) {
        super(3, new RfcSearchRequest(new RfcLDAPDN(base), new ASN1Enumerated(scope), new ASN1Enumerated(dereference), new ASN1Integer(maxResults), new ASN1Integer(serverTimeLimit), new ASN1Boolean(typesOnly), filter, new RfcAttributeDescriptionList(attrs)), cont);
    }

    public String getDN() {
        return this.getASN1Object().getRequestDN();
    }

    public int getScope() {
        return ((ASN1Enumerated)((RfcSearchRequest)this.getASN1Object().get(1)).get(1)).intValue();
    }

    public int getDereference() {
        return ((ASN1Enumerated)((RfcSearchRequest)this.getASN1Object().get(1)).get(2)).intValue();
    }

    public int getMaxResults() {
        return ((ASN1Integer)((RfcSearchRequest)this.getASN1Object().get(1)).get(3)).intValue();
    }

    public int getServerTimeLimit() {
        return ((ASN1Integer)((RfcSearchRequest)this.getASN1Object().get(1)).get(4)).intValue();
    }

    public boolean isTypesOnly() {
        return ((ASN1Boolean)((RfcSearchRequest)this.getASN1Object().get(1)).get(5)).booleanValue();
    }

    public String[] getAttributes() {
        RfcAttributeDescriptionList attrs = (RfcAttributeDescriptionList)((RfcSearchRequest)this.getASN1Object().get(1)).get(7);
        String[] rAttrs = new String[attrs.size()];
        for (int i = 0; i < rAttrs.length; ++i) {
            rAttrs[i] = ((RfcAttributeDescription)attrs.get(i)).stringValue();
        }
        return rAttrs;
    }

    public String getStringFilter() {
        return this.getRfcFilter().filterToString();
    }

    private RfcFilter getRfcFilter() {
        return (RfcFilter)((RfcSearchRequest)this.getASN1Object().get(1)).get(6);
    }

    public Iterator getSearchFilter() {
        return this.getRfcFilter().getFilterIterator();
    }

    protected void setDeserializedValues(LDAPMessage readObject, RfcControls asn1Ctrls) throws IOException, ClassNotFoundException {
        if (!(readObject instanceof LDAPSearchRequest)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPSearchRequest object");
        }
        try {
            LDAPSearchRequest tmpObject = (LDAPSearchRequest)readObject;
            String base = tmpObject.getDN();
            int scope = tmpObject.getScope();
            String filter = tmpObject.getStringFilter();
            String[] attrs = tmpObject.getAttributes();
            int dereference = tmpObject.getDereference();
            int maxResults = tmpObject.getMaxResults();
            int serverTimeLimit = tmpObject.getServerTimeLimit();
            boolean typesOnly = tmpObject.isTypesOnly();
            tmpObject = null;
            RfcSearchRequest operation = null;
            operation = new RfcSearchRequest(new RfcLDAPDN(base), new ASN1Enumerated(scope), new ASN1Enumerated(dereference), new ASN1Integer(maxResults), new ASN1Integer(serverTimeLimit), new ASN1Boolean(typesOnly), new RfcFilter(filter), new RfcAttributeDescriptionList(attrs));
            this.message = new RfcLDAPMessage(operation, asn1Ctrls);
        }
        catch (LDAPException le) {
            throw new IOException("LDAPException occured while de-serializing the stored object. There is a corruption in stored object. Restore it beforeusing this feature." + le);
        }
        readObject = null;
    }
}

