/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import com.novell.ldap.events.edir.eventdata.DSETimeStamp;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class EntryEventData
implements EventResponseData {
    private final String perpetratorDN;
    private final String entry;
    private final String newdn;
    private final String classid;
    private final int verb;
    private final int flags;
    private final DSETimeStamp timeStamp;

    public EntryEventData(ASN1Object message) throws IOException {
        byte[] data = ((ASN1OctetString)message).byteValue();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        LBERDecoder decode = new LBERDecoder();
        int[] length = new int[1];
        this.perpetratorDN = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.entry = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.classid = ((ASN1OctetString)decode.decode(in, length)).stringValue();
        this.timeStamp = new DSETimeStamp((ASN1Sequence)decode.decode(in, length));
        this.verb = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.flags = ((ASN1Integer)decode.decode(in, length)).intValue();
        this.newdn = ((ASN1OctetString)decode.decode(in, length)).stringValue();
    }

    public String getEntry() {
        return this.entry;
    }

    public String getPerpetratorDN() {
        return this.perpetratorDN;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getNewdn() {
        return this.newdn;
    }

    public String getClassid() {
        return this.classid;
    }

    public int getVerb() {
        return this.verb;
    }

    public DSETimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    private void addObject(StringBuffer buf, String dataname, String value) {
        buf.append("(" + dataname + "=" + value + ")");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("EntryEventData[");
        this.addObject(buf, "Entry", this.getEntry());
        this.addObject(buf, "Prepetrator", this.getPerpetratorDN());
        this.addObject(buf, "ClassId", this.getClassid());
        buf.append("(Verb=" + this.getVerb() + ")");
        buf.append("(Flags=" + this.getFlags() + ")");
        buf.append("(NewDN=" + this.getNewdn() + ")");
        buf.append("(TimeStamp=" + this.getTimeStamp() + ")");
        buf.append("]");
        return buf.toString();
    }
}

