/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.util;

import com.novell.ldap.util.DN;
import java.util.ArrayList;
import java.util.Vector;

public class RDN {
    private ArrayList types;
    private ArrayList values;
    private String rawValue;

    public RDN(String rdn) {
        this.rawValue = rdn;
        DN dn = new DN(rdn);
        Vector rdns = dn.getRDNs();
        if (rdns.size() != 1) {
            throw new IllegalArgumentException("Invalid RDN: see API documentation");
        }
        RDN thisRDN = (RDN)rdns.elementAt(0);
        this.types = thisRDN.types;
        this.values = thisRDN.values;
        this.rawValue = thisRDN.rawValue;
    }

    public RDN() {
        this.types = new ArrayList();
        this.values = new ArrayList();
        this.rawValue = "";
    }

    public boolean equals(RDN rdn) {
        if (this.values.size() != rdn.values.size()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            int j;
            for (j = 0; !(j >= this.values.size() || ((String)this.values.get(i)).equalsIgnoreCase((String)rdn.values.get(j)) && this.equalAttrType((String)this.types.get(i), (String)rdn.types.get(j))); ++j) {
            }
            if (j < rdn.values.size()) continue;
            return false;
        }
        return true;
    }

    private boolean equalAttrType(String attr1, String attr2) {
        if (Character.isDigit(attr1.charAt(0)) ^ Character.isDigit(attr2.charAt(0))) {
            throw new IllegalArgumentException("OID numbers are not currently compared to attribute names");
        }
        return attr1.equalsIgnoreCase(attr2);
    }

    protected String getRawValue() {
        return this.rawValue;
    }

    public void add(String attrType, String attrValue, String rawValue) {
        this.types.add(attrType);
        this.values.add(attrValue);
        this.rawValue = this.rawValue + rawValue;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean noTypes) {
        int length = this.types.size();
        String toReturn = "";
        if (length < 1) {
            return null;
        }
        if (!noTypes) {
            toReturn = this.types.get(0) + "=";
        }
        toReturn = toReturn + this.values.get(0);
        for (int i = 1; i < length; ++i) {
            toReturn = toReturn + "+";
            if (!noTypes) {
                toReturn = toReturn + this.types.get(i) + "=";
            }
            toReturn = toReturn + this.values.get(i);
        }
        return toReturn;
    }

    public String[] explodeRDN(boolean noTypes) {
        int length = this.types.size();
        if (length < 1) {
            return null;
        }
        String[] toReturn = new String[this.types.size()];
        if (!noTypes) {
            toReturn[0] = this.types.get(0) + "=";
        }
        toReturn[0] = toReturn[0] + this.values.get(0);
        for (int i = 1; i < length; ++i) {
            if (!noTypes) {
                int n = i;
                toReturn[n] = toReturn[n] + this.types.get(i) + "=";
            }
            int n = i;
            toReturn[n] = toReturn[n] + this.values.get(i);
        }
        return toReturn;
    }

    public String getType() {
        return (String)this.types.get(0);
    }

    public String[] getTypes() {
        String[] toReturn = new String[this.types.size()];
        for (int i = 0; i < this.types.size(); ++i) {
            toReturn[i] = (String)this.types.get(i);
        }
        return toReturn;
    }

    public String getValue() {
        return (String)this.values.get(0);
    }

    public String[] getValues() {
        String[] toReturn = new String[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            toReturn[i] = (String)this.values.get(i);
        }
        return toReturn;
    }

    public boolean isMultivalued() {
        return this.values.size() > 1;
    }
}

