/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.sasl.client.DigestChallenge;
import com.novell.sasl.client.ResponseAuth;
import com.novell.security.sasl.RealmCallback;
import com.novell.security.sasl.RealmChoiceCallback;
import com.novell.security.sasl.SaslClient;
import com.novell.security.sasl.SaslException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class DigestMD5SaslClient
implements SaslClient {
    private String m_authorizationId = "";
    private String m_protocol = "";
    private String m_serverName = "";
    private Map m_props;
    private CallbackHandler m_cbh;
    private int m_state;
    private String m_qopValue = "";
    private char[] m_HA1 = null;
    private String m_digestURI;
    private DigestChallenge m_dc;
    private String m_clientNonce = "";
    private String m_realm = "";
    private String m_name = "";
    private static final int STATE_INITIAL = 0;
    private static final int STATE_DIGEST_RESPONSE_SENT = 1;
    private static final int STATE_VALID_SERVER_RESPONSE = 2;
    private static final int STATE_INVALID_SERVER_RESPONSE = 3;
    private static final int STATE_DISPOSED = 4;
    private static final int NONCE_BYTE_COUNT = 32;
    private static final int NONCE_HEX_COUNT = 64;
    private static final String DIGEST_METHOD = "AUTHENTICATE";

    public static SaslClient getClient(String authorizationId, String protocol, String serverName, Map props, CallbackHandler cbh) {
        String desiredQOP = (String)props.get("com.novell.security.sasl.qop");
        String desiredStrength = (String)props.get("com.novell.security.sasl.strength");
        String serverAuth = (String)props.get("com.novell.security.sasl.server.authentication");
        if (desiredQOP != null && !"auth".equals(desiredQOP)) {
            return null;
        }
        if (serverAuth != null && !"false".equals(serverAuth)) {
            return null;
        }
        if (cbh == null) {
            return null;
        }
        return new DigestMD5SaslClient(authorizationId, protocol, serverName, props, cbh);
    }

    private DigestMD5SaslClient(String authorizationId, String protocol, String serverName, Map props, CallbackHandler cbh) {
        this.m_authorizationId = authorizationId;
        this.m_protocol = protocol;
        this.m_serverName = serverName;
        this.m_props = props;
        this.m_cbh = cbh;
        this.m_state = 0;
    }

    public boolean hasInitialResponse() {
        return false;
    }

    public boolean isComplete() {
        return this.m_state == 2 || this.m_state == 3 || this.m_state == 4;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new IllegalStateException("unwrap: QOP has neither integrity nor privacy>");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new IllegalStateException("wrap: QOP has neither integrity nor privacy>");
    }

    public Object getNegotiatedProperty(String propName) {
        if (this.m_state != 2) {
            throw new IllegalStateException("getNegotiatedProperty: authentication exchange not complete.");
        }
        if ("com.novell.security.sasl.qop".equals(propName)) {
            return "auth";
        }
        return null;
    }

    public void dispose() throws SaslException {
        if (this.m_state != 4) {
            this.m_state = 4;
        }
    }

    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        byte[] response = null;
        switch (this.m_state) {
            case 0: {
                if (challenge.length == 0) {
                    throw new SaslException("response = byte[0]");
                }
                try {
                    response = this.createDigestResponse(challenge).getBytes("UTF-8");
                    this.m_state = 1;
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new SaslException("UTF-8 encoding not suppported by platform", e);
                }
            }
            case 1: {
                if (this.checkServerResponseAuth(challenge)) {
                    this.m_state = 2;
                    break;
                }
                this.m_state = 3;
                throw new SaslException("Could not validate response-auth value from server");
            }
            case 2: 
            case 3: {
                throw new SaslException("Authentication sequence is complete");
            }
            case 4: {
                throw new SaslException("Client has been disposed");
            }
            default: {
                throw new SaslException("Unknown client state.");
            }
        }
        return response;
    }

    char[] convertToHex(byte[] hash) {
        int fifteen = 15;
        char[] hex = new char[32];
        for (int i = 0; i < 16; ++i) {
            hex[i * 2] = DigestMD5SaslClient.getHexChar((byte)((hash[i] & 0xF0) >> 4));
            hex[i * 2 + 1] = DigestMD5SaslClient.getHexChar((byte)(hash[i] & 0xF));
        }
        return hex;
    }

    char[] DigestCalcHA1(String algorithm, String userName, String realm, String password, String nonce, String clientNonce) throws SaslException {
        byte[] hash;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(userName.getBytes("UTF-8"));
            md.update(":".getBytes("UTF-8"));
            md.update(realm.getBytes("UTF-8"));
            md.update(":".getBytes("UTF-8"));
            md.update(password.getBytes("UTF-8"));
            hash = md.digest();
            if ("md5-sess".equals(algorithm)) {
                md.update(hash);
                md.update(":".getBytes("UTF-8"));
                md.update(nonce.getBytes("UTF-8"));
                md.update(":".getBytes("UTF-8"));
                md.update(clientNonce.getBytes("UTF-8"));
                hash = md.digest();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("No provider found for MD5 hash", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException("UTF-8 encoding not supported by platform.", e);
        }
        return this.convertToHex(hash);
    }

    char[] DigestCalcResponse(char[] HA1, String serverNonce, String nonceCount, String clientNonce, String qop, String method, String digestUri, boolean clientResponseFlag) throws SaslException {
        byte[] respHash;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (clientResponseFlag) {
                md.update(method.getBytes("UTF-8"));
            }
            md.update(":".getBytes("UTF-8"));
            md.update(digestUri.getBytes("UTF-8"));
            if ("auth-int".equals(qop)) {
                md.update(":".getBytes("UTF-8"));
                md.update("00000000000000000000000000000000".getBytes("UTF-8"));
            }
            byte[] HA2 = md.digest();
            char[] HA2Hex = this.convertToHex(HA2);
            md.update(new String(HA1).getBytes("UTF-8"));
            md.update(":".getBytes("UTF-8"));
            md.update(serverNonce.getBytes("UTF-8"));
            md.update(":".getBytes("UTF-8"));
            if (qop.length() > 0) {
                md.update(nonceCount.getBytes("UTF-8"));
                md.update(":".getBytes("UTF-8"));
                md.update(clientNonce.getBytes("UTF-8"));
                md.update(":".getBytes("UTF-8"));
                md.update(qop.getBytes("UTF-8"));
                md.update(":".getBytes("UTF-8"));
            }
            md.update(new String(HA2Hex).getBytes("UTF-8"));
            respHash = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("No provider found for MD5 hash", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SaslException("UTF-8 encoding not supported by platform.", e);
        }
        return this.convertToHex(respHash);
    }

    private String createDigestResponse(byte[] challenge) throws SaslException {
        int[] selections;
        StringBuffer digestResponse = new StringBuffer(512);
        this.m_dc = new DigestChallenge(challenge);
        this.m_digestURI = this.m_protocol + "/" + this.m_serverName;
        if ((this.m_dc.getQop() & 1) != 1) {
            throw new SaslException("Client only supports qop of 'auth'");
        }
        this.m_qopValue = "auth";
        Callback[] callbacks = new Callback[3];
        ArrayList realms = this.m_dc.getRealms();
        int realmSize = realms.size();
        callbacks[0] = realmSize == 0 ? new RealmCallback("Realm") : (realmSize == 1 ? new RealmCallback("Realm", (String)realms.get(0)) : new RealmChoiceCallback("Realm", realms.toArray(new String[realmSize]), 0, false));
        callbacks[1] = new PasswordCallback("Password", false);
        callbacks[2] = this.m_authorizationId == null || this.m_authorizationId.length() == 0 ? new NameCallback("Name") : new NameCallback("Name", this.m_authorizationId);
        try {
            this.m_cbh.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Handler does not support necessary callbacks", e);
        }
        catch (IOException e) {
            throw new SaslException("IO exception in CallbackHandler.", e);
        }
        this.m_realm = realmSize > 1 ? ((selections = ((RealmChoiceCallback)callbacks[0]).getSelectedIndexes()).length > 0 ? ((RealmChoiceCallback)callbacks[0]).getChoices()[selections[0]] : ((RealmChoiceCallback)callbacks[0]).getChoices()[0]) : ((RealmCallback)callbacks[0]).getText();
        this.m_clientNonce = this.getClientNonce();
        this.m_name = ((NameCallback)callbacks[2]).getName();
        if (this.m_name == null) {
            this.m_name = ((NameCallback)callbacks[2]).getDefaultName();
        }
        if (this.m_name == null) {
            throw new SaslException("No user name was specified.");
        }
        this.m_HA1 = this.DigestCalcHA1(this.m_dc.getAlgorithm(), this.m_name, this.m_realm, new String(((PasswordCallback)callbacks[1]).getPassword()), this.m_dc.getNonce(), this.m_clientNonce);
        char[] response = this.DigestCalcResponse(this.m_HA1, this.m_dc.getNonce(), "00000001", this.m_clientNonce, this.m_qopValue, DIGEST_METHOD, this.m_digestURI, true);
        digestResponse.append("username=\"");
        digestResponse.append(this.m_authorizationId);
        if (0 != this.m_realm.length()) {
            digestResponse.append("\",realm=\"");
            digestResponse.append(this.m_realm);
        }
        digestResponse.append("\",cnonce=\"");
        digestResponse.append(this.m_clientNonce);
        digestResponse.append("\",nc=");
        digestResponse.append("00000001");
        digestResponse.append(",qop=");
        digestResponse.append(this.m_qopValue);
        digestResponse.append(",digest-uri=\"ldap/");
        digestResponse.append(this.m_serverName);
        digestResponse.append("\",response=");
        digestResponse.append(response);
        digestResponse.append(",charset=utf-8,nonce=\"");
        digestResponse.append(this.m_dc.getNonce());
        digestResponse.append("\"");
        return digestResponse.toString();
    }

    boolean checkServerResponseAuth(byte[] serverResponse) throws SaslException {
        ResponseAuth responseAuth = null;
        responseAuth = new ResponseAuth(serverResponse);
        char[] response = this.DigestCalcResponse(this.m_HA1, this.m_dc.getNonce(), "00000001", this.m_clientNonce, this.m_qopValue, DIGEST_METHOD, this.m_digestURI, false);
        String responseStr = new String(response);
        return responseStr.equals(responseAuth.getResponseValue());
    }

    private static char getHexChar(byte value) {
        switch (value) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'a';
            }
            case 11: {
                return 'b';
            }
            case 12: {
                return 'c';
            }
            case 13: {
                return 'd';
            }
            case 14: {
                return 'e';
            }
            case 15: {
                return 'f';
            }
        }
        return 'Z';
    }

    String getClientNonce() throws SaslException {
        byte[] nonceBytes = new byte[32];
        char[] hexNonce = new char[64];
        try {
            SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
            prng.nextBytes(nonceBytes);
            for (int i = 0; i < 32; ++i) {
                hexNonce[i * 2] = DigestMD5SaslClient.getHexChar((byte)(nonceBytes[i] & 0xF));
                hexNonce[i * 2 + 1] = DigestMD5SaslClient.getHexChar((byte)((nonceBytes[i] & 0xF0) >> 4));
            }
            return new String(hexNonce);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SaslException("No random number generator available", e);
        }
    }

    public String getMechanismName() {
        return "DIGEST-MD5";
    }
}

