/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.mikrotik.impl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import me.legrange.mikrotik.impl.Parameter;

class Command {
    private final String cmd;
    private final List<Parameter> params = new LinkedList<Parameter>();
    private final List<String> queries = new LinkedList<String>();
    private final List<String> properties = new LinkedList<String>();
    private String tag;

    public String toString() {
        return String.format("cmd[%s] = %s, params = %s, queries = %s, props=%s ", this.tag, this.cmd, this.params, this.queries, this.properties);
    }

    Command(String cmd) {
        if (!cmd.startsWith("/")) {
            cmd = "/" + cmd;
        }
        this.cmd = cmd;
    }

    String getCommand() {
        return this.cmd;
    }

    void addParameter(String name, String value) {
        this.params.add(new Parameter(name, value));
    }

    void addParameter(Parameter param) {
        this.params.add(param);
    }

    void addProperty(String ... names) {
        this.properties.addAll(Arrays.asList(names));
    }

    void addQuery(String ... queries) {
        this.queries.addAll(Arrays.asList(queries));
    }

    void setTag(String tag) {
        this.tag = tag;
    }

    List<String> getQueries() {
        return this.queries;
    }

    String getTag() {
        return this.tag;
    }

    List<String> getProperties() {
        return this.properties;
    }

    List<Parameter> getParameters() {
        return this.params;
    }
}

