/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common;

import java.awt.Component;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;

public interface XMLStreamResolver {
    public void resolveElement(XMLStreamReader var1) throws BGException;

    public static class XMLStreamResolverReader {
        private XMLStreamResolverParam[] params;
        protected int currentDepth = 0;

        XMLStreamResolverReader(XMLStreamResolverParam param) {
            this.params = new XMLStreamResolverParam[]{param};
        }

        XMLStreamResolverReader(XMLStreamResolverParam ... param) {
            this.params = param;
        }

        public XMLStreamResolverReader(String path, XMLStreamResolver resolver) {
            this(new XMLStreamResolverParam(path, resolver));
        }

        protected void process(InputStream is) throws XMLStreamException {
            int i;
            XMLInputFactory xmlif = null;
            xmlif = XMLInputFactory.newInstance();
            xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            xmlif.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            XMLStreamReader xmlr = xmlif.createXMLStreamReader(is);
            int type = xmlr.getEventType();
            if (type == 7) {
                for (i = 0; i < this.params.length; ++i) {
                    this.params[i].startDocument();
                }
            }
            try {
                block8: while (xmlr.hasNext()) {
                    type = xmlr.next();
                    switch (type) {
                        case 1: {
                            ++this.currentDepth;
                            for (i = 0; i < this.params.length; ++i) {
                                this.params[i].startElement(this.currentDepth, xmlr);
                            }
                            continue block8;
                        }
                        case 2: {
                            --this.currentDepth;
                            for (i = 0; i < this.params.length; ++i) {
                                this.params[i].endElement(this.currentDepth, xmlr);
                            }
                            continue block8;
                        }
                        case 4: {
                            for (i = 0; i < this.params.length; ++i) {
                                this.params[i].characters(this.currentDepth, xmlr);
                            }
                            continue block8;
                        }
                    }
                }
            }
            catch (BGException bGException) {
                // empty catch block
            }
        }

        public static Data process(String path, XMLStreamResolver resolver, InputStream is) {
            Data data = new Data();
            XMLStreamResolverReader reader = new XMLStreamResolverReader(new XMLStreamResolverParam(path, resolver), data);
            try {
                reader.process(is);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            return data;
        }

        public static Data processAndCheckStatus(InputStream is, Component component, XMLStreamResolverParam ... resolvers) {
            Data data = new Data(component, false);
            resolvers = Arrays.copyOf(resolvers, resolvers.length + 1);
            resolvers[resolvers.length - 1] = data;
            XMLStreamResolverReader reader = new XMLStreamResolverReader(resolvers);
            try {
                reader.process(is);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            return data;
        }
    }

    public static class Data
    extends XMLStreamResolverParam {
        protected static final String[] dataPath = new String[]{"", "data"};
        private String dataTextContent = "";
        private Map<String, String> dataAttributes = new HashMap<String, String>();
        private final Component component;
        private boolean result;

        public Data() {
            super(dataPath, null);
            this.component = null;
        }

        public Data(Component component, boolean haltOnError) {
            super(dataPath, null);
            this.component = component;
        }

        @Override
        protected void startElement(int depth, XMLStreamReader xmlr) {
            if (this.pathDepth > this.path.length || ++depth == this.pathDepth && this.path[depth].equals(xmlr.getLocalName())) {
                ++this.pathDepth;
            }
            if (this.pathDepth == this.path.length) {
                this.dataAttributes = new HashMap<String, String>();
                int count = xmlr.getAttributeCount();
                for (int i = 0; i < count; ++i) {
                    this.dataAttributes.put(xmlr.getAttributeLocalName(i), xmlr.getAttributeValue(i));
                }
                String status = this.dataAttributes.get("status");
                this.result = !status.equals("error");
            }
        }

        protected void onData() {
        }

        @Override
        protected void endElement(int depth, XMLStreamReader xmlr) {
            if (this.pathDepth == this.path.length && this.component != null) {
                String status = this.dataAttributes.get("status");
                if (status.equals("error")) {
                    if (Utils.notBlankString(this.dataTextContent)) {
                        ClientUtils.showErrorMessageDialog((String)this.dataTextContent);
                    }
                } else if (status.equals("message") && Utils.notBlankString(this.dataTextContent)) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), this.dataTextContent, "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                }
            }
            if (this.pathDepth > 1) {
                --this.pathDepth;
            }
        }

        @Override
        protected void characters(int depth, XMLStreamReader xmlr) {
            if (this.pathDepth == this.path.length) {
                this.dataTextContent = xmlr.getText();
            }
        }

        public String getDataTextContent() {
            return this.dataTextContent;
        }

        public Map<String, String> getDataAttributes() {
            return this.dataAttributes;
        }

        public boolean getResult() {
            return this.result;
        }
    }

    public static class XMLStreamResolverParam {
        protected static final Pattern pattern = Pattern.compile("/");
        protected final String[] path;
        protected final XMLStreamResolver resolver;
        protected int pathDepth = 1;

        public XMLStreamResolverParam(String path, XMLStreamResolver resolver) {
            this.path = pattern.split(path);
            this.resolver = resolver;
        }

        XMLStreamResolverParam(String[] path, XMLStreamResolver resolver) {
            this.path = path;
            this.resolver = resolver;
        }

        protected void startElement(int depth, XMLStreamReader xmlr) throws BGException {
            if (this.pathDepth > this.path.length || depth == this.pathDepth && this.path[depth].equals(xmlr.getLocalName())) {
                ++this.pathDepth;
            }
            if (this.pathDepth == this.path.length) {
                this.resolver.resolveElement(xmlr);
            }
        }

        protected void endElement(int depth, XMLStreamReader xmlr) {
            if (this.pathDepth > 1) {
                --this.pathDepth;
            }
        }

        protected void characters(int depth, XMLStreamReader xmlr) {
        }

        protected void startDocument() {
        }
    }
}

