/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action.pub;

import bitel.billing.server.admin.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.bean.PasswordManager;
import bitel.billing.server.util.MailMsg;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.common.Utils;

public class ActionPasswordForgot
extends ActionBase {
    String paramContract;

    @Override
    public void doAction() throws SQLException, BGException {
        this.rootNode.setAttribute("xslt", "forgot.xsl");
        String paramEmail = this.getParameter("email");
        this.paramContract = this.getParameter("contract");
        this.rootNode.setAttribute("userName", this.paramContract);
        if (this.paramContract != null) {
            ContractDao contractDao = new ContractDao(this.con, this.userId);
            Contract contract = contractDao.getByTitle(this.paramContract);
            contractDao.close();
            if (contract == null) {
                this.sendError("contractNotFound");
                return;
            }
            int paramId = this.setup.getInt("contract.password.forgot.email.param.id", -1);
            ContractParameterManager contractParameterManager = new ContractParameterManager(this.con);
            String contractEmail = contractParameterManager.getEmailFromParam(contract.getId(), paramId);
            if (contractEmail == null) {
                this.sendError("emailNotFound");
                return;
            }
            if (paramEmail != null) {
                if (!this.checkEmail(paramEmail, contractEmail)) {
                    Element errorElement = this.sendError("emailNotValid");
                    errorElement.setAttribute("email", paramEmail);
                } else {
                    Integer authMode;
                    PasswordManager passwordManager = new PasswordManager(this.con);
                    long passwordExpireHour = this.setup.getLong("contract.password.forgot.expire.hour", 24L);
                    String emailLink = this.setup.get("contract.password.forgot.link", "http://localhost:8080/bgbilling/webexecuter?action=ChangePassword&mid=contract&passwordOnce=${password}");
                    String emailSubject = this.setup.get("contract.password.forgot.email.subject", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f");
                    String emailText = this.setup.get("contract.password.forgot.email.body", "\u0414\u043b\u044f \u0432\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 {contract} - \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435 \u043d\u0438\u0436\u0435 (\u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0438 {hour} \u0447\u0430\u0441\u043e\u0432) \u0438 \u0441\u043c\u0435\u043d\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c.");
                    String charArray = this.setup.get("contract.password.forgot.char.array", "1234567890QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm");
                    String password = passwordManager.getOncePassword(charArray);
                    HashMap<Integer, Integer> authModes = new HashMap<Integer, Integer>();
                    String modes = this.setup.get("web.auth.modes", null);
                    if (modes != null) {
                        String[] parts = modes.split(";");
                        for (int i = 0; i < parts.length; ++i) {
                            String[] mid_mode = parts[i].split(":");
                            if (mid_mode.length != 2) continue;
                            authModes.put(Utils.parseInt(mid_mode[0].trim(), 0), Utils.parseInt(mid_mode[1].trim(), 0));
                        }
                    }
                    if ((authMode = (Integer)authModes.get(0)) != null && authMode > 0 && authMode < 3) {
                        if (authMode == 1) {
                            passwordManager.deleteByContract(contract.getTitle());
                            passwordManager.addPassword(contract.getTitle(), passwordExpireHour, password);
                        } else if (authMode == 2) {
                            paramId = this.setup.getInt("web.auth.contract.text.parameter", 0);
                            if (paramId > 0) {
                                String value = new ContractParameterManager(this.con).getTextlikeParam(contract.getId(), paramId);
                                passwordManager.deleteByContract(value);
                                passwordManager.addPassword(value, passwordExpireHour, password);
                            } else {
                                log.error((Object)"Not set parameter 'web.auth.contract.text.parameter' in config!");
                            }
                        }
                        emailText = emailText.replaceAll("\\{contract\\}", contract.getTitle());
                        emailText = emailText.replaceAll("\\{hour\\}", String.valueOf(passwordExpireHour));
                        emailLink = emailLink.contains("${password}") ? emailLink.replaceAll("\\$\\{password\\}", password) : emailLink + "&passwordOnce=" + password;
                        new MailMsg(this.setup).sendMessage(paramEmail, emailSubject, emailText + "\n" + emailLink);
                        this.createElement(this.rootNode, "ok");
                    } else {
                        this.sendError("authModeNotSetByContract").setAttribute("email", paramEmail);
                    }
                }
            } else {
                this.getMaskEmails(contractEmail);
            }
        }
    }

    private boolean checkEmail(String email, String emailList) {
        boolean result;
        block1: {
            String token;
            result = false;
            if (email == null || emailList == null) break block1;
            StringTokenizer st = new StringTokenizer(emailList, "\n");
            email = email.toLowerCase();
            while (st.hasMoreTokens() && !(result = (token = st.nextToken().toLowerCase()).equals(email) || token.indexOf("<" + email + ">") > -1)) {
            }
        }
        return result;
    }

    private void getMaskEmails(String emails) {
        String[] emailsArray;
        Element maskEmailElement = this.createElement(this.rootNode, "maskEmail");
        Pattern patternEmail = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", 2);
        for (String email : emailsArray = emails.split("\n")) {
            String emailString = "";
            if (email.indexOf("<") == -1) {
                Matcher matcherEmail = patternEmail.matcher(email);
                if (matcherEmail.find()) {
                    emailString = matcherEmail.group();
                    if (matcherEmail.find()) {
                        emailString = email;
                    }
                }
            } else {
                int index = email.indexOf("<");
                Matcher matcherEmail = patternEmail.matcher(email.substring(index, email.length()));
                if (matcherEmail.find()) {
                    emailString = matcherEmail.group();
                }
            }
            Element row = this.createElement(maskEmailElement, "row");
            row.setAttribute("mail", Utils.maskEmail(emailString));
        }
    }

    private Element sendError(String error) {
        Element errorElement = this.createElement(this.rootNode, "error");
        errorElement.setAttribute("id", error);
        return errorElement;
    }
}

