/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.errorlog.bean;

import bitel.billing.server.admin.errorlog.bean.PeriodicProcessErrorMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class PeriodicErrorManager {
    private static int MAX_ERROR = 10;
    public static String MAX_ERROR_PARAM = "max.periodic.errors";
    private int maxErrors;
    private int counter = 0;
    private PeriodicProcessErrorMessage errorMessage;
    private Connection con;

    public PeriodicErrorManager(Connection con) {
        this.con = con;
        this.maxErrors = 10;
    }

    public void initErrorMessage(int mid, String moduleName, String marker, Date calcDate) {
        ModuleSetup msetup;
        String title = "\u041b\u043e\u0433 \u043e\u0448\u0438\u0431\u043e\u043a \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 \u043c\u043e\u0434\u0443\u043b\u044f " + moduleName + " (mid=" + marker + ")";
        this.errorMessage = new PeriodicProcessErrorMessage(calcDate, marker, title, "");
        Setup setup = Setup.getSetup();
        if (setup != null && (msetup = setup.getModuleSetup(mid)) != null) {
            this.maxErrors = msetup.getInt(MAX_ERROR_PARAM, MAX_ERROR);
        }
    }

    public boolean isCapReached() {
        ++this.counter;
        return this.counter >= this.maxErrors;
    }

    public void addErrorToList(String errorSubj, String errorText) {
        if (Utils.notBlankString(this.errorMessage.text)) {
            this.errorMessage.text = this.errorMessage.text + "\n\n-----------------------------------------------------\n\n";
        }
        this.errorMessage.text = this.errorMessage.text + errorSubj + "\n" + errorText;
    }

    public void addErrorToList(String errorSubj, String errorText, Exception ex) {
        this.addErrorToList(errorSubj, errorText);
        this.errorMessage.text = this.errorMessage.text + "\n" + ex.toString();
        StackTraceElement[] trace = ex.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            this.errorMessage.text = this.errorMessage.text + "\n\tat " + trace[i];
        }
    }

    public int getCounter() {
        return this.counter;
    }

    public void processErrors() {
        if (this.counter == 0) {
            return;
        }
        if (this.counter >= this.maxErrors) {
            this.errorMessage.text = this.errorMessage.text + "\n\n\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u041f\u0440\u0438 \u0434\u0430\u043d\u043d\u043e\u043c \u043e\u0431\u0441\u0447\u0435\u0442\u0435 \u0431\u044b\u043b\u043e \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u0447\u0438\u0441\u043b\u043e \u043e\u0448\u0438\u0431\u043e\u043a. \u0412 \u0436\u0443\u0440\u043d\u0430\u043b \u0431\u044b\u043b\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e " + this.maxErrors + " \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0438\u0437 " + this.counter + " \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445.";
        }
        try {
            String sql = "INSERT INTO periodic_errors(calc_date,subject,text,marker,reg_time) VALUES(?,?,?,?,?)";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setDate(1, TimeUtils.convertDateToSqlDate(this.errorMessage.getMonth()));
            ps.setString(2, this.errorMessage.getSubject());
            ps.setString(3, this.errorMessage.getText());
            ps.setString(4, this.errorMessage.getMarker());
            ps.setDate(5, TimeUtils.convertDateToSqlDate(this.errorMessage.getRegistrationTime()));
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteErrorsByMarker(String marker, Date recalcTime) {
        try {
            String sql = "DELETE FROM periodic_errors WHERE marker=? AND calc_date=?";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setString(1, marker);
            ps.setDate(2, TimeUtils.convertDateToSqlDate(recalcTime));
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<PeriodicProcessErrorMessage> getErrors(Date month, Period regPeriod, Page page, String contains) {
        ArrayList<PeriodicProcessErrorMessage> result = new ArrayList<PeriodicProcessErrorMessage>();
        try {
            String sql = "SELECT calc_date, marker, subject, text, id, reg_time FROM periodic_errors WHERE MONTH(calc_date) = MONTH(?) AND YEAR(calc_date) = YEAR(?) ";
            if (regPeriod != null) {
                sql = sql + " AND ( reg_time >= ? OR reg_time <= ? )";
            }
            if (Utils.notBlankString(contains)) {
                sql = sql + " AND ( subject LIKE ? OR text LIKE ? ) ";
            }
            sql = sql + page.sqlLimit();
            PreparedStatement ps = this.con.prepareStatement(sql);
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(month));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(month));
            if (regPeriod != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(regPeriod.getDateFrom()));
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(regPeriod.getDateTo()));
            }
            if (Utils.notBlankString(contains)) {
                ps.setString(index++, "%" + contains + "%");
                ps.setString(index++, "%" + contains + "%");
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PeriodicProcessErrorMessage message = this.readErrorFromRS(rs);
                result.add(message);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private PeriodicProcessErrorMessage readErrorFromRS(ResultSet rs) throws SQLException {
        PeriodicProcessErrorMessage message = new PeriodicProcessErrorMessage(rs.getDate(1), rs.getString(2), rs.getString(3), rs.getString(4));
        message.setId(rs.getInt(5));
        message.setRegistrationTime(rs.getDate(6));
        return message;
    }

    public boolean deleteErrorsByIds(String ids) {
        boolean result = false;
        try {
            String sql = "DELETE FROM periodic_errors WHERE id IN (" + ids + ")";
            PreparedStatement ps = this.con.prepareStatement(sql);
            int count = ps.executeUpdate();
            if (count > 0) {
                result = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public int getErrorCount(Date month) {
        int result = 0;
        try {
            String sql = "SELECT COUNT(*) FROM periodic_errors WHERE MONTH(calc_date) = MONTH(?) AND YEAR(calc_date) = YEAR(?) ";
            PreparedStatement ps = this.con.prepareStatement(sql);
            ps.setDate(1, TimeUtils.convertDateToSqlDate(month));
            ps.setDate(2, TimeUtils.convertDateToSqlDate(month));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

