/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.action;

import bitel.billing.common.IPUtils;
import bitel.billing.server.admin.resource.action.base.ActionBase;
import bitel.billing.server.admin.resource.bean.ip.IPResourceRange;
import bitel.billing.server.ipn.bean.IPNResourceManager;
import java.sql.SQLException;
import java.util.Calendar;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionFreeIPResourceList
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        long ip2;
        long ip1;
        boolean maskMode;
        Calendar date = TimeUtils.convertDateToCalendar(this.getDateParameter("date"));
        int categoryId = this.getIntParameter("category_id", 0);
        if (this.mid <= 0 || date == null || categoryId < 0) {
            throw new BGIllegalArgumentException();
        }
        String fromNumber = this.getParameter("range1");
        String toNumber = this.getParameter("range2");
        String net = this.getParameter("net");
        String mask = this.getParameter("mask");
        boolean bl = maskMode = mask != null;
        if (maskMode) {
            ip1 = Utils.parseLong(net, 0L);
            ip2 = Utils.parseLong(mask, 0L);
        } else {
            ip1 = Utils.parseLong(fromNumber, 0L);
            ip2 = Utils.parseLong(toNumber, 0L);
        }
        String rangeSizeString = this.getParameter("rangeSize");
        int rangeSize = this.getIntParameter("rangeSize", 0);
        if (rangeSizeString != null || maskMode && ip1 <= 0L) {
            Iterable ranges = new IPNResourceManager(this.con, this.mid).getFreeResourceIterator(categoryId, date);
            Element list = this.createElement(this.rootNode, "list");
            if (maskMode) {
                if (ip2 <= 0L) {
                    ip2 = 32L;
                }
                for (IPResourceRange range : ranges) {
                    long address1 = range.getIp1();
                    long address2 = range.getIp2();
                    this.subnet(address1, address2, (short)ip2, list, this.moduleSetup.getInt("ip.resource.subnet.free.max", Integer.MAX_VALUE));
                }
            } else {
                for (IPResourceRange range : ranges) {
                    long address1 = range.getIp1();
                    long address2 = range.getIp2();
                    if (address2 - address1 + 1L < (long)rangeSize) continue;
                    if (rangeSize > 0) {
                        address2 = address1 + (long)rangeSize - 1L;
                    }
                    String saddr1 = IPUtils.convertLongIpToString(address1);
                    String saddr2 = IPUtils.convertLongIpToString(address2);
                    String addr = saddr1 + " - " + saddr2;
                    Element item = this.addListItem((Node)list, addr, addr);
                    item.setAttribute("hostMin", saddr1);
                    item.setAttribute("hostMax", saddr2);
                }
            }
        } else {
            throw new RuntimeException("TODO?");
        }
    }

    private void subnet(long address1, long address2, short bitmask, Element list, int max) {
        IPUtils.Netv4 netv4;
        for (int i = 0; i < max && (netv4 = IPUtils.subnet(address1, address2, bitmask)) != null; ++i) {
            String smask = IPUtils.convertLongIpToString(netv4.netmask);
            String saddr = IPUtils.convertLongIpToString(netv4.address);
            String snet = IPUtils.convertLongIpToString(netv4.network);
            String hostMin = IPUtils.convertLongIpToString(netv4.hostMin);
            String hostMax = IPUtils.convertLongIpToString(netv4.hostMax);
            String addr = snet + "/" + netv4.bitmask + " (" + smask + " : " + hostMin + " - " + hostMax + ")";
            Element item = this.addListItem((Node)list, addr, addr);
            item.setAttribute("bitmask", String.valueOf(netv4.bitmask));
            item.setAttribute("netmask", smask);
            item.setAttribute("net", saddr);
            item.setAttribute("hostMin", hostMin);
            item.setAttribute("hostMax", hostMax);
            address1 = netv4.hostMax + 1L;
        }
    }
}

