/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.action.base;

import bitel.billing.server.admin.resource.bean.ResourceCategory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.common.Utils;

public abstract class ActionBase
extends bitel.billing.server.admin.action.base.ActionBase {
    protected void addSubcategories(ResourceCategory<?> category, Element parent) {
        Element categoryNode = this.createElement(parent, "item");
        categoryNode.setAttribute("id", String.valueOf(category.getId()));
        categoryNode.setAttribute("title", category.getTitle());
        categoryNode.setAttribute("comment", category.getComment());
        List<?> subCategories = category.getSubCategories();
        if (subCategories != null) {
            for (int index = 0; index < subCategories.size(); ++index) {
                this.addSubcategories((ResourceCategory)subCategories.get(index), categoryNode);
            }
        }
    }

    protected List<String> parseNumberResources(String numbers) throws BGException {
        String[] tokens;
        ArrayList<String> result = new ArrayList<String>();
        for (String token : tokens = numbers.split("\\s*\\,\\s*")) {
            String[] range = token.split("\\s*\\-\\s*");
            if (range.length == 1) {
                if (Utils.parseLong(range[0], -1L) < 0L) {
                    throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 " + range[0]);
                }
                result.add(range[0]);
                continue;
            }
            if (range.length == 2) {
                if (range[0].length() != range[1].length()) {
                    throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u0430 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 " + token + " \u043d\u0435 \u0440\u0430\u0432\u043d\u0430 \u0434\u043b\u0438\u043d\u0435 \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u0430");
                }
                long numberFrom = Utils.parseLong(range[0], 0L);
                long numberTo = Utils.parseLong(range[1], 0L);
                if (numberFrom == 0L) {
                    throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: " + range[0]);
                }
                if (numberTo == 0L) {
                    throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430: " + range[1]);
                }
                if (numberFrom > numberTo) {
                    throw new BGMessageException("\u041d\u0430\u0447\u0430\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 " + token + " \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 \u043a\u043e\u043d\u0435\u0447\u043d\u044b\u0439");
                }
                if (numberTo - numberFrom > 10000L) {
                    throw new BGMessageException("\u0420\u0430\u0437\u043c\u0435\u0440 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 " + token + " \u0431\u043e\u043b\u0435\u0435 10000 \u043d\u043e\u043c\u0435\u0440\u043e\u0432, \u043f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0433\u0440\u0430\u043d\u0438\u0446\u044b");
                }
                for (long number = numberFrom; number <= numberTo; ++number) {
                    result.add(String.valueOf(number));
                }
                continue;
            }
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d " + token);
        }
        return result;
    }

    public void marshallAsTable(Class<?> clazz, Iterable<? extends Object> iter) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter w = factory.createXMLStreamWriter((OutputStream)this.response.getOutputStream());
            w.writeStartDocument("UTF-8", "1.0");
            w.writeStartElement("data");
            w.writeStartElement("table");
            w.writeStartElement("data");
            for (Object object : iter) {
                m.marshal(object, w);
            }
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndDocument();
            w.flush();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

