/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.BalanceService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.BalanceDetailItem;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionContractBalanceDetail
extends ActionBase {
    @Override
    public void doAction() throws BGException {
        List<BalanceDetailItem> list = this.context.getService(BalanceService.class, 0).balanceDetailList(this.cid, this.getPeriod(), this.getBooleanParameter("availableSum", false));
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (BalanceDetailItem currentBalanceItem : list) {
            Element row = this.createElement(data, "row");
            if (currentBalanceItem.getType() == 7 || currentBalanceItem.getType() == 8) {
                Calendar calendar = TimeUtils.convertDateToCalendar(currentBalanceItem.getDate());
                row.setAttribute("date", TimeUtils.monthNames[calendar.get(2)] + " " + calendar.get(1));
                row.setAttribute("summa", Utils.formatBigDecimalSumm(currentBalanceItem.getSumAfterChange()));
            } else {
                row.setAttribute("date", TimeUtils.formatDate(currentBalanceItem.getDate()));
                row.setAttribute("summa", Utils.formatBigDecimalSumm(currentBalanceItem.getSum()));
            }
            row.setAttribute("comment", currentBalanceItem.getComment());
            row.setAttribute("contractTitle", currentBalanceItem.getContractTitle());
            row.setAttribute("type", currentBalanceItem.getTypeTitle());
        }
        table.setAttribute("summa", list.size() > 0 ? Utils.formatBigDecimalSumm(list.get(list.size() - 1).getSum()) : "0");
    }
}

